/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.bean;

import cn.hutool.core.lang.func.Func0;
import cn.hutool.core.map.reference.ReferenceConcurrentMap;
import cn.hutool.core.map.reference.WeakKeyValueConcurrentMap;
import java.beans.PropertyDescriptor;
import java.util.Map;

public enum BeanInfoCache {
    INSTANCE;

    private final WeakKeyValueConcurrentMap<Class<?>, Map<String, PropertyDescriptor>> pdCache = new WeakKeyValueConcurrentMap();
    private final WeakKeyValueConcurrentMap<Class<?>, Map<String, PropertyDescriptor>> ignoreCasePdCache = new WeakKeyValueConcurrentMap();

    public Map<String, PropertyDescriptor> getPropertyDescriptorMap(Class<?> beanClass, boolean ignoreCase) {
        return this.getCache(ignoreCase).get(beanClass);
    }

    public Map<String, PropertyDescriptor> getPropertyDescriptorMap(Class<?> beanClass, boolean ignoreCase, Func0<Map<String, PropertyDescriptor>> supplier) {
        return this.getCache(ignoreCase).computeIfAbsent(beanClass, key -> (Map)supplier.callWithRuntimeException());
    }

    public void putPropertyDescriptorMap(Class<?> beanClass, Map<String, PropertyDescriptor> fieldNamePropertyDescriptorMap, boolean ignoreCase) {
        this.getCache(ignoreCase).put(beanClass, fieldNamePropertyDescriptorMap);
    }

    public void clear() {
        this.pdCache.clear();
        this.ignoreCasePdCache.clear();
    }

    private ReferenceConcurrentMap<Class<?>, Map<String, PropertyDescriptor>> getCache(boolean ignoreCase) {
        return ignoreCase ? this.ignoreCasePdCache : this.pdCache;
    }
}

