/*
 * Decompiled with CFR 0.152.
 */
package io.spring.up.boot.advice;

import io.spring.up.core.data.JsonObject;
import io.spring.up.exception.WebException;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
@ResponseBody
public class ExceptionAdvice {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExceptionAdvice.class);

    @ExceptionHandler(value={WebException.class})
    public JsonObject handle(WebException ex, HttpServletResponse response) {
        response.setStatus(ex.getStatus().value());
        LOGGER.error("[ UP ] Error occurs: " + ex.getMessage());
        return ex.toJson();
    }
}

