/*
 * Decompiled with CFR 0.152.
 */
package io.spring.up.boot.resolver;

import io.spring.up.annotations.JsonBody;
import io.spring.up.core.data.JsonArray;
import io.spring.up.core.data.JsonObject;
import io.spring.up.core.rules.Ruler;
import io.spring.up.cv.Encodings;
import io.spring.up.exception.internal.JsonDecodeException;
import io.spring.up.exception.web._400ParameterMissingException;
import io.spring.up.exception.web._500ParameterTypeException;
import io.spring.up.exception.web._500WebRequestIoException;
import io.spring.up.tool.Ut;
import io.spring.up.tool.fn.Fn;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.nio.charset.Charset;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class ArgumentResolver
implements HandlerMethodArgumentResolver {
    private static final String JSON_REQUEST_BODY = "JSON_REQUEST_BODY";

    public boolean supportsParameter(MethodParameter methodParameter) {
        boolean isMatch = methodParameter.hasParameterAnnotation(JsonBody.class);
        if (isMatch) {
            boolean bl = isMatch = Ut.isJObject(methodParameter.getParameterType()) || Ut.isJArray(methodParameter.getParameterType());
            if (!isMatch) {
                throw new _500ParameterTypeException(this.getClass(), methodParameter.getParameterType());
            }
        }
        return isMatch;
    }

    public Object resolveArgument(MethodParameter methodParameter, ModelAndViewContainer modelAndViewContainer, NativeWebRequest nativeWebRequest, WebDataBinderFactory webDataBinderFactory) throws Exception {
        String body = this.getRequestBody(methodParameter, nativeWebRequest);
        Object reference = this.resolveArgument(body);
        this.verifyInput(methodParameter, reference);
        return reference;
    }

    private void verifyInput(MethodParameter methodParameter, Object reference) {
        Annotation rule = methodParameter.getParameterAnnotation(JsonBody.class);
        boolean required = (Boolean)Ut.invoke(rule, "required", new Object[0]);
        if (null == reference && required) {
            throw new _400ParameterMissingException(this.getClass(), methodParameter.getParameterName(), methodParameter.getMethod().getName());
        }
        if (null != reference) {
            String folder = (String)Ut.invoke(rule, "folder", new Object[0]);
            String value = (String)Ut.invoke(rule, "value", new Object[0]);
            String path = this.resolvePath(folder, value);
            if (Ut.isJArray(reference)) {
                Ruler.verify(path, (JsonArray)reference);
            } else if (Ut.isJObject(reference)) {
                Ruler.verify(path, (JsonObject)reference);
            }
        }
    }

    private String resolvePath(String folder, String value) {
        String path = folder + "/" + value;
        return path.replace("//", "/");
    }

    private String getRequestBody(MethodParameter methodParameter, NativeWebRequest request) {
        HttpServletRequest servletRequest = (HttpServletRequest)request.getNativeRequest(HttpServletRequest.class);
        String jsonBody = (String)servletRequest.getAttribute(JSON_REQUEST_BODY);
        if (jsonBody == null) {
            try {
                jsonBody = IOUtils.toString((InputStream)servletRequest.getInputStream(), (Charset)Encodings.CHARSET);
                servletRequest.setAttribute(JSON_REQUEST_BODY, (Object)jsonBody);
            }
            catch (IOException e) {
                throw new _500WebRequestIoException(methodParameter.getMethod().getDeclaringClass(), (Throwable)e);
            }
        }
        return jsonBody;
    }

    private Object resolveArgument(String body) {
        return Fn.getJvm(null, () -> {
            try {
                if (body.trim().startsWith("{")) {
                    return new JsonObject(body);
                }
                if (body.trim().startsWith("[")) {
                    return new JsonArray(body);
                }
                return null;
            }
            catch (JsonDecodeException ex) {
                if (body.trim().startsWith("{")) {
                    throw new _500ParameterTypeException(this.getClass(), JsonObject.class);
                }
                if (body.trim().startsWith("[")) {
                    throw new _500ParameterTypeException(this.getClass(), JsonArray.class);
                }
                throw ex;
            }
        }, new Object[]{body});
    }
}

