/*
 * Decompiled with CFR 0.152.
 */
package io.spring.up.config;

import io.spring.up.config.Node;
import io.spring.up.config.Pool;
import io.spring.up.core.data.JsonObject;
import io.spring.up.tool.Ut;
import io.spring.up.tool.fn.Fn;

public class ConfigNode
implements Node<JsonObject> {
    private final transient String key;

    ConfigNode(String key) {
        this.key = key;
    }

    @Override
    public JsonObject read() {
        JsonObject merged = new JsonObject();
        JsonObject direct = this.readDirect(this.key);
        JsonObject original = this.readInternal(this.key);
        if (null != direct && !direct.isEmpty()) {
            merged.mergeIn(direct, true);
        }
        if (null != original && !original.isEmpty()) {
            merged.mergeIn(original, true);
        }
        return merged;
    }

    private JsonObject readInternal(String key) {
        String filename = "internal/application-" + key + ".yml";
        return Fn.pool(Pool.INTERNAL, filename, () -> (JsonObject)Ut.ioJYaml(filename));
    }

    private JsonObject readDirect(String key) {
        String filename = "application-" + key + ".yml";
        return Fn.pool(Pool.CONFIG, filename, () -> (JsonObject)Ut.ioJYaml(filename));
    }
}

