/*
 * Decompiled with CFR 0.152.
 */
package io.spring.up.core.data;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.ByteArraySerializer;
import io.spring.up.core.data.JsonArray;
import io.spring.up.core.data.JsonObject;
import io.spring.up.exception.internal.JsonDecodeException;
import io.spring.up.exception.internal.JsonEncodeException;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class Json {
    public static ObjectMapper mapper = new ObjectMapper();
    public static ObjectMapper prettyMapper = new ObjectMapper();

    public static String encode(Object obj) throws JsonEncodeException {
        try {
            return mapper.writeValueAsString(obj);
        }
        catch (Exception e) {
            throw new JsonEncodeException("Failed to encode as JSON: " + e.getMessage());
        }
    }

    public static String encodePrettily(Object obj) throws JsonEncodeException {
        try {
            return prettyMapper.writeValueAsString(obj);
        }
        catch (Exception e) {
            throw new JsonEncodeException("Failed to encode as JSON: " + e.getMessage());
        }
    }

    public static <T> T decodeValue(String str, Class<T> clazz) throws JsonDecodeException {
        try {
            return (T)mapper.readValue(str, clazz);
        }
        catch (Exception e) {
            throw new JsonDecodeException("Failed to decode:" + e.getMessage());
        }
    }

    static Object checkAndCopy(Object val, boolean copy) {
        if (!(val == null || val instanceof Number && !(val instanceof BigDecimal) || val instanceof Boolean || val instanceof String || val instanceof Character)) {
            if (val instanceof CharSequence) {
                val = val.toString();
            } else if (val instanceof JsonObject) {
                if (copy) {
                    val = ((JsonObject)val).copy();
                }
            } else if (val instanceof JsonArray) {
                if (copy) {
                    val = ((JsonArray)val).copy();
                }
            } else if (val instanceof Map) {
                val = copy ? new JsonObject((Map)val).copy() : new JsonObject((Map)val);
            } else if (val instanceof List) {
                val = copy ? new JsonArray((List)val).copy() : new JsonArray((List)val);
            } else if (val instanceof byte[]) {
                val = Base64.getEncoder().encodeToString((byte[])val);
            } else if (val instanceof Instant) {
                val = DateTimeFormatter.ISO_INSTANT.format((Instant)val);
            } else {
                throw new IllegalStateException("Illegal type in JsonObject: " + val.getClass());
            }
        }
        return val;
    }

    static <T> Stream<T> asStream(Iterator<T> sourceIterator) {
        Iterable iterable = () -> sourceIterator;
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    static {
        mapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        prettyMapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        prettyMapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        SimpleModule module = new SimpleModule();
        module.addSerializer(JsonObject.class, (JsonSerializer)new JsonObjectSerializer());
        module.addSerializer(JsonArray.class, (JsonSerializer)new JsonArraySerializer());
        module.addSerializer(Instant.class, (JsonSerializer)new InstantSerializer());
        module.addSerializer(byte[].class, (JsonSerializer)new ByteArraySerializer());
        mapper.registerModule((Module)module);
        prettyMapper.registerModule((Module)module);
    }

    private static class InstantSerializer
    extends JsonSerializer<Instant> {
        private InstantSerializer() {
        }

        public void serialize(Instant value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeString(DateTimeFormatter.ISO_INSTANT.format(value));
        }
    }

    private static class JsonArraySerializer
    extends JsonSerializer<JsonArray> {
        private JsonArraySerializer() {
        }

        public void serialize(JsonArray value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeObject((Object)value.getList());
        }
    }

    private static class JsonObjectSerializer
    extends JsonSerializer<JsonObject> {
        private JsonObjectSerializer() {
        }

        public void serialize(JsonObject value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeObject(value.getMap());
        }
    }
}

