/*
 * Decompiled with CFR 0.152.
 */
package io.spring.up.core.rules;

import io.spring.up.core.data.JsonArray;
import io.spring.up.core.data.JsonObject;
import io.spring.up.core.rules.Pool;
import io.spring.up.core.rules.Rule;
import io.spring.up.exception.WebException;
import io.spring.up.tool.Ut;
import io.spring.up.tool.fn.Fn;
import java.text.MessageFormat;

public class Ruler {
    private static final String ROOT = "rules/{0}.yml";

    private static JsonObject getConfig(String path) {
        String filename = MessageFormat.format(ROOT, path);
        return Fn.pool(Pool.RULE_MAP, filename, () -> (JsonObject)Ut.ioJYaml(filename));
    }

    public static void verify(String file, JsonObject data) {
        JsonObject config = Ruler.getConfig(file);
        Ruler.verify(config, data);
    }

    public static void verify(String file, JsonArray data) {
        JsonObject config = Ruler.getConfig(file);
        Ut.itJArray(data, (item, index) -> Ruler.verify(config, item));
    }

    private static void verify(String name, Object value, JsonArray rules) {
        Ut.itJArray(rules, (item, index) -> Ruler.verify(name, value, item));
    }

    private static void verify(String name, Object value, JsonObject rule) {
        String type = Fn.getNull(() -> rule.getString("type"), rule);
        JsonObject config = Fn.getNull(() -> rule.getJsonObject("config"), rule);
        Fn.safeNull(() -> {
            Rule ruler = Rule.get(type);
            Fn.safeNull(() -> {
                WebException error = ruler.verify(name, value, config);
                Fn.safeNull(() -> {
                    String message = Fn.getNull(() -> rule.getString("message"), rule);
                    if (null != message) {
                        error.setInfo(message);
                        throw error;
                    }
                }, error);
            }, ruler);
        }, type, config);
    }

    private static void verify(JsonObject config, JsonObject data) {
        Fn.safeNull(() -> Ut.itJObject(data, (field, value) -> {
            Object ruleConfig = config.getValue((String)field);
            if (null != ruleConfig && Ut.isJArray(ruleConfig)) {
                Ruler.verify(field, value, (JsonArray)ruleConfig);
            }
        }), config);
    }
}

