/*
 * Decompiled with CFR 0.152.
 */
package io.spring.up.exception;

import io.spring.up.core.data.JsonObject;
import io.spring.up.exception.AbstractException;
import io.spring.up.log.Errors;
import java.util.Objects;
import org.springframework.http.HttpStatus;

public abstract class WebException
extends AbstractException {
    protected static final String INFO = "info";
    private final String message;
    protected HttpStatus status;
    private String info;

    public WebException(String message) {
        super(message);
        this.message = message;
        this.status = HttpStatus.BAD_REQUEST;
    }

    public WebException(Class<?> clazz, Object ... args) {
        super("");
        this.message = Errors.formatWeb(clazz, this.getCode(), args);
        this.status = HttpStatus.BAD_REQUEST;
    }

    @Override
    public abstract int getCode();

    @Override
    public String getMessage() {
        return this.message;
    }

    public HttpStatus getStatus() {
        return this.status;
    }

    public void setStatus(HttpStatus status) {
        this.status = status;
    }

    public String getInfo() {
        return this.info;
    }

    public void setInfo(String info) {
        this.info = info;
    }

    @Override
    public JsonObject toJson() {
        JsonObject data = new JsonObject();
        data.put("code", this.getCode());
        data.put("message", this.getMessage());
        if (Objects.nonNull(this.info)) {
            data.put(INFO, this.info);
        }
        return data;
    }
}

