/*
 * Decompiled with CFR 0.152.
 */
package io.spring.up.log;

import io.spring.up.config.Node;
import io.spring.up.core.data.JsonObject;
import io.spring.up.exception.internal.ErrorMissingException;
import io.spring.up.tool.Ut;
import io.spring.up.tool.fn.Fn;
import java.text.MessageFormat;

public class Errors {
    public static String formatUp(Class<?> clazz, int code, Object ... args) {
        return Errors.normalize(clazz, code, "[ ERR{0} ] Up Exception : {1}", args);
    }

    public static String formatWeb(Class<?> clazz, int code, Object ... args) {
        return Errors.normalize(clazz, code, "[ ERR{0} ] Web Exception : {1}", args);
    }

    private static String normalize(Class<?> clazz, int code, String tpl, Object ... args) {
        return Fn.getJvm(() -> {
            String key = ("E" + Math.abs(code)).intern();
            JsonObject errors = Node.infix("error");
            if (null == errors) {
                throw new ErrorMissingException(code);
            }
            if ((errors = Ut.readJson(new JsonObject(), errors, "error")).containsKey(key)) {
                String pattern = errors.getString(key);
                String error = MessageFormat.format(pattern, args);
                return MessageFormat.format(tpl, String.valueOf(code), error);
            }
            throw new ErrorMissingException(code);
        }, clazz);
    }
}

