/*
 * Decompiled with CFR 0.152.
 */
package io.spring.up.log;

import io.spring.up.exception.AbstractException;
import io.spring.up.tool.fn.Evaluater;
import io.spring.up.tool.fn.Fn;
import java.text.MessageFormat;
import java.util.function.Consumer;
import org.slf4j.Logger;

public class Log {
    public static void jvm(Logger logger, Throwable ex) {
        Log.error(logger, "[ JVM ERROR ] Jvm Exception: {0}", Fn.getNull("None", () -> ex.getMessage(), ex));
    }

    public static void debug(Logger logger, String message, String ... args) {
        Log.output(() -> ((Logger)logger).isDebugEnabled(), arg_0 -> ((Logger)logger).debug(arg_0), message, args);
    }

    public static void error(Logger logger, AbstractException ex) {
        Log.error(logger, ex.getMessage(), new String[0]);
    }

    public static void error(Logger logger, String message, String ... args) {
        Log.output(() -> ((Logger)logger).isErrorEnabled(), arg_0 -> ((Logger)logger).error(arg_0), message, args);
    }

    public static void warn(Logger logger, String message, String ... args) {
        Log.output(() -> ((Logger)logger).isWarnEnabled(), arg_0 -> ((Logger)logger).warn(arg_0), message, args);
    }

    public static void warn(Logger logger, AbstractException ex) {
        Log.warn(logger, ex.getMessage(), new String[0]);
    }

    public static void info(Logger logger, String message, String ... args) {
        Log.output(() -> ((Logger)logger).isInfoEnabled(), arg_0 -> ((Logger)logger).info(arg_0), message, args);
    }

    private static void output(Evaluater evaluater, Consumer<String> fnLog, String message, Object ... params) {
        if (evaluater.test()) {
            fnLog.accept(Log.format(message, params));
        }
    }

    private static String format(String pattern, Object ... args) {
        String message = pattern;
        if (0 < args.length) {
            message = MessageFormat.format(message, args);
        }
        return message;
    }
}

