/*
 * Decompiled with CFR 0.152.
 */
package io.spring.up.tool;

import io.spring.up.cv.Encodings;
import io.spring.up.tool.fn.Fn;
import java.security.MessageDigest;

class Codec {
    private static final char[] HEX_ARR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    Codec() {
    }

    static String encryptMD5(String input) {
        return Fn.getJvm(() -> {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] source = input.getBytes(Encodings.CHARSET);
            digest.update(source);
            byte[] middle = digest.digest();
            char[] middleStr = new char[32];
            int position = 0;
            for (int idx = 0; idx < 16; ++idx) {
                byte byte0 = middle[idx];
                middleStr[position++] = HEX_ARR[byte0 >>> 4 & 0xF];
                middleStr[position++] = HEX_ARR[byte0 & 0xF];
            }
            return new String(middleStr);
        }, input);
    }

    static String encryptSHA256(String input) {
        return Codec.sha(input, "SHA-256");
    }

    static String encryptSHA512(String input) {
        return Codec.sha(input, "SHA-512");
    }

    private static String sha(String strText, String strType) {
        return Fn.getJvm(() -> {
            MessageDigest messageDigest = MessageDigest.getInstance(strType);
            messageDigest.update(strText.getBytes());
            byte[] byteBuffer = messageDigest.digest();
            StringBuilder strHexString = new StringBuilder();
            for (int i = 0; i < byteBuffer.length; ++i) {
                String hex = Integer.toHexString(0xFF & byteBuffer[i]);
                if (hex.length() == 1) {
                    strHexString.append('0');
                }
                strHexString.append(hex);
            }
            return strHexString.toString();
        }, strText, strType);
    }
}

