/*
 * Decompiled with CFR 0.152.
 */
package io.spring.up.tool;

import cn.hutool.core.io.FileUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import com.fasterxml.jackson.dataformat.yaml.snakeyaml.error.MarkedYAMLException;
import io.spring.up.core.data.JsonArray;
import io.spring.up.core.data.JsonObject;
import io.spring.up.exception.internal.EmptyStreamException;
import io.spring.up.exception.internal.YamlFormatException;
import io.spring.up.log.Log;
import io.spring.up.tool.fn.Fn;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

class IO {
    private static final Logger LOGGER = LoggerFactory.getLogger(IO.class);
    private static final ObjectMapper YAML = new YAMLMapper();

    IO() {
    }

    static JsonArray getJArray(String filename) {
        return Fn.getJvm(new JsonArray(), () -> {
            String content = IO.getString(filename);
            return null == content ? new JsonArray() : new JsonArray(content);
        }, filename);
    }

    static JsonObject getJObject(String filename) {
        return Fn.getJvm(new JsonObject(), () -> {
            String content = IO.getString(filename);
            return null == content ? new JsonObject() : new JsonObject(content);
        }, filename);
    }

    static String getString(String filename) {
        return Fn.getJvm("", () -> {
            InputStream in = IO.getStream(filename);
            return null == in ? "" : IO.getContent(in);
        }, filename);
    }

    static Properties getProp(String filename) {
        return Fn.getJvm(new Properties(), () -> {
            InputStream in = IO.getStream(filename);
            Properties prop = new Properties();
            if (null != in) {
                prop.load(in);
                in.close();
            }
            return prop;
        }, filename);
    }

    static InputStream getStream(String filename) {
        File file = IO.getFile(filename);
        return Fn.getJvm(null, () -> FileUtil.getInputStream((File)file), new Object[]{file});
    }

    static File getFile(String filename) {
        File file = new File(filename);
        if (file.exists()) {
            return file;
        }
        URL url = IO.getURL(filename);
        return null == url ? null : new File(url.getFile());
    }

    static URL getURL(String filename) {
        return Fn.getJvm(() -> {
            URL url = Thread.currentThread().getContextClassLoader().getResource(filename);
            if (null == url) {
                url = IO.class.getResource(filename);
            }
            if (null == url) {
                url = new ClassPathResource(filename).getURL();
            }
            return url;
        }, filename);
    }

    static <T> T getJYaml(String filename) {
        JsonNode node;
        boolean isArray = IO.isJArray(filename);
        Iterable<Object> ret = null;
        ret = isArray ? (null == (node = IO.getYamlNode(filename)) ? new JsonArray() : new JsonArray(node.toString())) : (null == (node = IO.getYamlNode(filename)) ? new JsonObject() : new JsonObject(node.toString()));
        return (T)ret;
    }

    private static JsonNode getYamlNode(String filename) {
        InputStream in = IO.getStream(filename);
        if (null == in) {
            Log.warn(LOGGER, new EmptyStreamException(filename));
        }
        JsonNode node = null;
        try {
            node = YAML.readTree(in);
            if (null == node) {
                Log.warn(LOGGER, new EmptyStreamException(filename));
            }
        }
        catch (MarkedYAMLException ex) {
            throw new YamlFormatException(filename);
        }
        catch (IOException ex) {
            Log.jvm(LOGGER, ex);
        }
        return node;
    }

    private static boolean isJArray(String filename) {
        String content = IO.getString(filename);
        return Fn.getJvm(Boolean.FALSE, () -> content.trim().startsWith("-"), content);
    }

    private static String[] getLines(InputStream in) {
        ArrayList lineList = new ArrayList();
        return Fn.getJvm(lineList.toArray(new String[0]), () -> {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            while (null != (line = reader.readLine())) {
                lineList.add(line);
            }
            reader.close();
            return lineList.toArray(new String[0]);
        }, in);
    }

    private static String getContent(InputStream in) {
        String[] lines;
        StringBuilder buffer = new StringBuilder(16);
        for (String line : lines = IO.getLines(in)) {
            buffer.append(line);
        }
        return buffer.toString();
    }
}

