/*
 * Decompiled with CFR 0.152.
 */
package io.spring.up.tool;

import com.esotericsoftware.reflectasm.ConstructorAccess;
import com.esotericsoftware.reflectasm.MethodAccess;
import io.spring.up.tool.fn.Fn;
import java.lang.reflect.Constructor;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

class Instance {
    private static final ConcurrentMap<String, Object> SINGLETON = new ConcurrentHashMap<String, Object>();
    private static final ConcurrentMap<String, Class<?>> CLASSES = new ConcurrentHashMap();

    Instance() {
    }

    static <T> T singleton(Class<?> clazz, Object ... args) {
        Object reference = Fn.getJvm(() -> Fn.pool(SINGLETON, clazz.getName(), () -> Instance.instance(clazz, args)), clazz);
        return (T)Fn.getJvm(() -> reference, reference);
    }

    static <T> T instance(Class<?> clazz, Object ... args) {
        Object reference = Fn.getJvm(() -> Instance.construct(clazz, args), clazz);
        return (T)Fn.getJvm(() -> reference, reference);
    }

    static Class<?> clazz(String name) {
        return Fn.pool(CLASSES, name, () -> Fn.getJvm(() -> Thread.currentThread().getContextClassLoader().loadClass(name), name));
    }

    static <T> T invokeObject(Object instance, String name, Object ... args) {
        return (T)Fn.getJvm(null, () -> {
            MethodAccess access = MethodAccess.get(instance.getClass());
            Object result = access.invoke(instance, name, args);
            return null == result ? null : result;
        }, new Object[]{instance, name});
    }

    private static <T> T construct(Class<?> clazz, Object ... args) {
        return (T)Fn.getJvm(() -> {
            Constructor<?>[] constructors;
            Object ret = null;
            for (Constructor<?> constructor : constructors = clazz.getDeclaredConstructors()) {
                if (0 == args.length) {
                    ret = Instance.construct(clazz);
                }
                if (args.length != constructor.getParameterTypes().length) continue;
                Object reference = constructor.newInstance(args);
                ret = null == reference ? null : reference;
            }
            return ret;
        }, clazz, args);
    }

    private static <T> T construct(Class<T> clazz) {
        return (T)Fn.getJvm(() -> {
            ConstructorAccess access = ConstructorAccess.get((Class)clazz);
            return access.newInstance();
        }, clazz);
    }
}

