/*
 * Decompiled with CFR 0.152.
 */
package io.spring.up.tool;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ByteArraySerializer;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.InstantSerializer;
import com.fasterxml.jackson.databind.JsonArrayDeserializer;
import com.fasterxml.jackson.databind.JsonArraySerializer;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonObjectDeserializer;
import com.fasterxml.jackson.databind.JsonObjectSerializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import io.spring.up.core.data.JsonArray;
import io.spring.up.core.data.JsonObject;
import io.spring.up.tool.To;
import io.spring.up.tool.Types;
import io.spring.up.tool.fn.Fn;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Jackson {
    private static final Logger LOGGER = LoggerFactory.getLogger(Jackson.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();

    Jackson() {
    }

    static ObjectMapper getMapper() {
        return MAPPER;
    }

    static <T, R extends Iterable> R serializeJson(T t) {
        String content = Jackson.serialize(t);
        return (R)Fn.getJvm(null, () -> {
            if (content.trim().startsWith("{")) {
                return new JsonObject(content);
            }
            return new JsonObject(content);
        }, new Object[]{content});
    }

    static <T> String serialize(T t) {
        return Fn.getJvm(null, () -> Fn.getJvm(() -> MAPPER.writeValueAsString(t), t), new Object[]{t});
    }

    static <T> T deserialize(JsonObject value, Class<T> type) {
        return (T)Fn.getJvm(null, () -> Jackson.deserialize(value.encode(), type), new Object[]{value});
    }

    static <T> T deserialize(JsonArray value, Class<T> type) {
        return (T)Fn.getJvm(null, () -> Jackson.deserialize(value.encode(), type), new Object[]{value});
    }

    static <T> List<T> deserialize(JsonArray value, TypeReference<List<T>> type) {
        return Fn.getJvm(new ArrayList(), () -> (List)Jackson.deserialize(value.encode(), type), value);
    }

    static <T> T deserialize(String value, Class<T> type) {
        return (T)Fn.getJvm(null, () -> Fn.getJvm(() -> MAPPER.readValue(value, type), new Object[0]), new Object[]{value});
    }

    static <T> T deserialize(String value, TypeReference<T> type) {
        return (T)Fn.getJvm(null, () -> Fn.getJvm(() -> MAPPER.readValue(value, type), new Object[0]), new Object[]{value});
    }

    static Object readJson(Object value, JsonObject data, String key) {
        return Fn.getNull(value, () -> {
            Object result = data.getValue(key);
            return Fn.getNull(value, () -> result, result);
        }, data, key);
    }

    static Integer readInt(Integer value, JsonObject data, String key) {
        return Fn.getNull(value, () -> {
            Object result = data.getValue(key);
            return Types.isInteger(result) ? To.toInteger(result) : value;
        }, data, key);
    }

    static {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        MAPPER.setDateFormat((DateFormat)dateFormat);
        MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        MAPPER.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        MAPPER.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        MAPPER.configure(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, true);
        SimpleModule module = new SimpleModule();
        module.addSerializer(JsonObject.class, (JsonSerializer)new JsonObjectSerializer());
        module.addSerializer(JsonArray.class, (JsonSerializer)new JsonArraySerializer());
        module.addSerializer(Instant.class, (JsonSerializer)new InstantSerializer());
        module.addSerializer(byte[].class, (JsonSerializer)new ByteArraySerializer());
        module.addDeserializer(JsonObject.class, (JsonDeserializer)new JsonObjectDeserializer());
        module.addDeserializer(JsonArray.class, (JsonDeserializer)new JsonArrayDeserializer());
        MAPPER.registerModule((Module)module);
        MAPPER.findAndRegisterModules();
    }
}

