/*
 * Decompiled with CFR 0.152.
 */
package io.spring.up.tool;

import io.spring.up.tool.fn.Fn;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class Numeric {
    Numeric() {
    }

    private static boolean isMatch(String regex, String original) {
        return Fn.getNull(false, () -> {
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(original);
            return matcher.matches();
        }, regex, original);
    }

    static boolean isPositive(String original) {
        return Numeric.isMatch("^\\+{0,1}[0-9]\\d*", original);
    }

    static boolean isNegative(String original) {
        return Numeric.isMatch("^-[0-9]\\d*", original);
    }

    static boolean isInteger(String original) {
        return Numeric.isMatch("[+-]{0,1}0", original) || Numeric.isPositive(original) || Numeric.isNegative(original);
    }

    static boolean isDecimal(String original) {
        return Numeric.isMatch("[-+]{0,1}\\d+\\.\\d*|[-+]{0,1}\\d*\\.\\d+", original);
    }

    static boolean isReal(String original) {
        return Numeric.isInteger(original) || Numeric.isDecimal(original);
    }

    static boolean inRange(Integer value, Integer min, Integer max) {
        if (null == min && null == max) {
            return true;
        }
        if (null != min && null != max) {
            return min <= value && value <= max;
        }
        return null != min && min <= value || null != max && value <= max;
    }

    static class Decimal {
        Decimal() {
        }

        public static boolean isPositive(String original) {
            return Numeric.isMatch("\\+{0,1}[0]\\.[1-9]*|\\+{0,1}[1-9]\\d*\\.\\d*", original);
        }

        public static boolean isNegative(String original) {
            return Numeric.isMatch("^-[0]\\.[1-9]*|^-[1-9]\\d*\\.\\d*", original);
        }
    }
}

