/*
 * Decompiled with CFR 0.152.
 */
package io.spring.up.tool;

import io.spring.up.core.data.JsonArray;
import io.spring.up.core.data.JsonObject;
import io.spring.up.tool.Period;
import java.math.BigDecimal;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

class Types {
    private static final ConcurrentMap<Class<?>, Class<?>> UNBOXES = new ConcurrentHashMap<Class<?>, Class<?>>(){
        {
            this.put(Integer.class, Integer.TYPE);
            this.put(Long.class, Long.TYPE);
            this.put(Short.class, Short.TYPE);
            this.put(Boolean.class, Boolean.TYPE);
            this.put(Character.class, Character.TYPE);
            this.put(Double.class, Double.TYPE);
            this.put(Float.class, Float.TYPE);
            this.put(Byte.class, Byte.TYPE);
        }
    };

    Types() {
    }

    static boolean isJArray(Object value) {
        return null != value && Types.isJArray(value.getClass());
    }

    static boolean isJArray(Class<?> clazz) {
        return null != clazz && JsonArray.class == clazz;
    }

    static boolean isJObject(Object value) {
        return null != value && Types.isJObject(value.getClass());
    }

    static boolean isJObject(Class<?> clazz) {
        return null != clazz && JsonObject.class == clazz;
    }

    static boolean isVoid(Class<?> clazz) {
        return null != clazz && (Void.class == clazz || Void.TYPE == clazz);
    }

    static boolean isInteger(Class<?> clazz) {
        return null != clazz && (Integer.TYPE == clazz || Integer.class == clazz || Long.TYPE == clazz || Long.class == clazz || Short.TYPE == clazz || Short.class == clazz);
    }

    static boolean isInteger(Object value) {
        return null != value && Types.isInteger(value.getClass());
    }

    static boolean isDecimal(Object value) {
        return null != value && Types.isDecimal(value.getClass());
    }

    static boolean isDecimal(Class<?> clazz) {
        return null != clazz && (BigDecimal.class == clazz || Double.TYPE == clazz || Double.class == clazz || Float.TYPE == clazz || Float.class == clazz);
    }

    static boolean isDate(Object value) {
        return null != value && Period.isValid(value.toString());
    }

    static boolean isBoolean(Class<?> clazz) {
        return null != clazz && (Boolean.TYPE == clazz || Boolean.class == clazz);
    }

    static boolean isBoolean(Object value) {
        String literal;
        boolean logical = false;
        if (null != value && ("true".equalsIgnoreCase(literal = value.toString()) || Integer.valueOf(1).toString().equalsIgnoreCase(literal) || "false".equalsIgnoreCase(literal) || Integer.valueOf(0).toString().equalsIgnoreCase(literal))) {
            logical = true;
        }
        return logical;
    }

    static boolean isPrimary(Class<?> source) {
        return UNBOXES.values().contains(source);
    }
}

