/*
 * Decompiled with CFR 0.152.
 */
package io.spring.up.tool;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.spring.up.core.data.JsonArray;
import io.spring.up.core.data.JsonObject;
import io.spring.up.tool.Codec;
import io.spring.up.tool.IO;
import io.spring.up.tool.Instance;
import io.spring.up.tool.It;
import io.spring.up.tool.Jackson;
import io.spring.up.tool.Net;
import io.spring.up.tool.Numeric;
import io.spring.up.tool.Period;
import io.spring.up.tool.To;
import io.spring.up.tool.Types;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.function.BiConsumer;

public class Ut {
    public static Properties ioProp(String filename) {
        return IO.getProp(filename);
    }

    public static File ioFile(String filename) {
        return IO.getFile(filename);
    }

    public static URL ioURL(String filename) {
        return IO.getURL(filename);
    }

    public static String ioString(String filename) {
        return IO.getString(filename);
    }

    public static JsonArray ioJArray(String filename) {
        return IO.getJArray(filename);
    }

    public static JsonObject ioJObject(String filename) {
        return IO.getJObject(filename);
    }

    public static <T> T ioJYaml(String filename) {
        return IO.getJYaml(filename);
    }

    public static InputStream ioStream(String filename) {
        return IO.getStream(filename);
    }

    public static <T> T instance(String name, Object ... args) {
        return Instance.instance(Instance.clazz(name), args);
    }

    public static <T> T instance(Class<?> clazz, Object ... args) {
        return Instance.instance(clazz, args);
    }

    public static <T> T singleton(String name, Object ... args) {
        return Instance.singleton(Instance.clazz(name), args);
    }

    public static <T> T singleton(Class<?> clazz, Object ... args) {
        return Instance.singleton(clazz, args);
    }

    public static <T> T invoke(Object instance, String methodName, Object ... args) {
        return Instance.invokeObject(instance, methodName, args);
    }

    public static Class<?> clazz(String name) {
        return Instance.clazz(name);
    }

    public static void itJObject(JsonObject object, BiConsumer<String, Object> consumer) {
        It.itJObject(object, consumer);
    }

    public static <T> void itJArray(JsonArray array, Class<T> clazz, BiConsumer<T, Integer> consumer) {
        It.itJArray(array, clazz, consumer);
    }

    public static void itJArray(JsonArray array, BiConsumer<JsonObject, Integer> consumer) {
        It.itJArray(array, JsonObject.class, consumer);
    }

    public static boolean isPositive(String original) {
        return Numeric.isPositive(original);
    }

    public static boolean isNegative(String original) {
        return Numeric.isNegative(original);
    }

    public static boolean isReal(String original) {
        return Numeric.isReal(original);
    }

    public static boolean isDecimal(String original) {
        return Numeric.isDecimal(original);
    }

    public static boolean isDecimal(Object value) {
        return Types.isDecimal(value);
    }

    public static boolean isDecimal(Class<?> clazz) {
        return Types.isDecimal(clazz);
    }

    public static boolean isInteger(String original) {
        return Numeric.isInteger(original);
    }

    public static boolean isInteger(Object value) {
        return Types.isInteger(value);
    }

    public static boolean isInteger(Class<?> clazz) {
        return Types.isInteger(clazz);
    }

    public static boolean isJArray(Object value) {
        return Types.isJArray(value);
    }

    public static boolean isJArray(Class<?> clazz) {
        return Types.isJArray(clazz);
    }

    public static boolean isJObject(Class<?> clazz) {
        return Types.isJObject(clazz);
    }

    public static boolean isJObject(Object value) {
        return Types.isJObject(value);
    }

    public static boolean isBoolean(Object value) {
        return Types.isBoolean(value);
    }

    public static boolean isBoolean(Class<?> clazz) {
        return Types.isBoolean(clazz);
    }

    public static boolean isPrimary(Class<?> clazz) {
        return Types.isPrimary(clazz);
    }

    public static boolean isVoid(Class<?> clazz) {
        return Types.isVoid(clazz);
    }

    public static boolean isDate(Object value) {
        return Types.isDate(value);
    }

    public static boolean inRange(Integer value, Integer min, Integer max) {
        return Numeric.inRange(value, min, max);
    }

    public static Object readJson(JsonObject data, String key) {
        return Jackson.readJson(null, data, key);
    }

    public static Object readJson(Object value, JsonObject data, String key) {
        return Jackson.readJson(value, data, key);
    }

    public static JsonObject readJson(JsonObject value, JsonObject data, String key) {
        Object result = Jackson.readJson(value, data, key);
        return null == result ? new JsonObject() : (JsonObject)result;
    }

    public static String readJson(String value, JsonObject data, String key) {
        Object result = Jackson.readJson(value, data, key);
        return null == result ? value : result.toString();
    }

    public static Integer readInt(Integer value, JsonObject data, String key) {
        return Jackson.readInt(value, data, key);
    }

    public static <T extends Enum<T>> T toEnum(Class<T> clazz, String input) {
        return To.toEnum(clazz, input);
    }

    public static LocalDateTime toDateTime(String literal) {
        return Period.toDateTime(literal);
    }

    public static LocalDate toDate(String literal) {
        return Period.toDate(literal);
    }

    public static LocalTime toTime(String literal) {
        return Period.toTime(literal);
    }

    public static int toMonth(String literal) {
        return Period.toMonth(literal);
    }

    public static int toMonth(Date date) {
        return Period.toMonth(date);
    }

    public static int toYear(String literal) {
        return Period.toYear(literal);
    }

    public static int toYear(Date date) {
        return Period.toYear(date);
    }

    public static Integer toInteger(Object value) {
        return To.toInteger(value);
    }

    public static String encryptMD5(String literal) {
        return Codec.encryptMD5(literal);
    }

    public static String encryptSHA256(String literal) {
        return Codec.encryptSHA256(literal);
    }

    public static String encryptSHA512(String literal) {
        return Codec.encryptSHA512(literal);
    }

    public static Date parse(String literal) {
        return Period.parse(literal);
    }

    public static Date parse(LocalTime time) {
        return Period.parse(time);
    }

    public static Date parse(LocalDateTime datetime) {
        return Period.parse(datetime);
    }

    public static Date parse(LocalDate date) {
        return Period.parse(date);
    }

    public static Date parseFull(String literal) {
        return Period.parseFull(literal);
    }

    public static <T, R extends Iterable> R serializeJson(T t) {
        return Jackson.serializeJson(t);
    }

    public static <T> String serialize(T t) {
        return Jackson.serialize(t);
    }

    public static <T> T deserialize(JsonObject value, Class<T> type) {
        return Jackson.deserialize(value, type);
    }

    public static <T> T deserialize(JsonArray value, Class<T> type) {
        return Jackson.deserialize(value, type);
    }

    public static <T> List<T> deserialize(JsonArray value, TypeReference<List<T>> type) {
        return Jackson.deserialize(value, type);
    }

    public static <T> T deserialize(String value, Class<T> type) {
        return Jackson.deserialize(value, type);
    }

    public static <T> T deserialize(String value, TypeReference<T> type) {
        return Jackson.deserialize(value, type);
    }

    public static ObjectMapper getJacksonMapper() {
        return Jackson.getMapper();
    }

    public static boolean netOk(String host, int port) {
        return Net.isReach(host, port);
    }

    public static String netIPv4() {
        return Net.getIPv4();
    }

    public static String netIPv6() {
        return Net.getIPv6();
    }

    public static String netHostname() {
        return Net.netHostname();
    }

    public static String netIP() {
        return Net.getIP();
    }
}

