/*
 * Decompiled with CFR 0.152.
 */
package io.spring.up.tool.fn;

import io.spring.up.tool.fn.Actuator;
import io.spring.up.tool.fn.Jvm;
import io.spring.up.tool.fn.JvmActuator;
import io.spring.up.tool.fn.JvmSupplier;
import io.spring.up.tool.fn.Null;
import io.spring.up.tool.fn.Pool;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;

public final class Fn {
    public static <T> T getNull(T defaultValue, Supplier<T> supplier, Object ... reference) {
        return Null.get(defaultValue, supplier, reference);
    }

    public static <T> T getNull(Supplier<T> supplier, Object ... reference) {
        return Null.get(null, supplier, reference);
    }

    public static void safeNull(Actuator actuator, Object ... reference) {
        Null.execute(actuator, reference);
    }

    public static <T> T getJvm(T defaultValue, JvmSupplier<T> supplier, Object ... reference) {
        return Jvm.get(defaultValue, supplier, reference);
    }

    public static <T> T getJvm(JvmSupplier<T> supplier, Object ... reference) {
        return Jvm.get(null, supplier, reference);
    }

    public static void safeJvm(JvmActuator actuator, Object ... reference) {
        Jvm.execute(actuator, reference);
    }

    public static <K, V> V pool(ConcurrentMap<K, V> pool, K key, Supplier<V> poolFn) {
        return Pool.exec(pool, key, poolFn);
    }
}

