/*
 * Decompiled with CFR 0.152.
 */
package io.spring.up.tool.fn;

import io.spring.up.exception.AbstractException;
import io.spring.up.tool.fn.JvmActuator;
import io.spring.up.tool.fn.JvmSupplier;
import java.util.Arrays;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Jvm {
    private static final Logger LOGGER = LoggerFactory.getLogger(Jvm.class);

    Jvm() {
    }

    static <T> T get(T defaultValue, JvmSupplier<T> supplier, Object ... reference) {
        T ret = defaultValue;
        try {
            boolean match = Arrays.stream(reference).allMatch(Objects::nonNull);
            if (match) {
                ret = supplier.get();
                return null == ret ? defaultValue : ret;
            }
        }
        catch (AbstractException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            LOGGER.error(ex.getMessage());
            ex.printStackTrace();
        }
        return ret;
    }

    static <T> void execute(JvmActuator actuator, Object ... reference) {
        try {
            boolean match = Arrays.stream(reference).allMatch(Objects::nonNull);
            if (match) {
                actuator.execute();
            }
        }
        catch (AbstractException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            LOGGER.error(ex.getMessage());
            ex.printStackTrace();
        }
    }
}

