/*
 * Decompiled with CFR 0.152.
 */
package io.spring.up.tool.net;

import io.spring.up.tool.fn.Fn;
import io.spring.up.tool.net.IPFilter;
import io.spring.up.tool.net.IPFilterFactory;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;

public class IPHost {
    private static final IPHost instance = new IPHost();

    private IPHost() {
    }

    public static IPHost getInstance() {
        return instance;
    }

    public String getExtranetIPv4Address() {
        return this.searchNetworkInterfaces(IPFilterFactory.getIPv4AcceptFilter());
    }

    public String getExtranetIPv6Address() {
        return this.searchNetworkInterfaces(IPFilterFactory.getIPv6AcceptFilter());
    }

    public String getExtranetIPAddress() {
        return this.searchNetworkInterfaces(IPFilterFactory.getIPAllAcceptFilter());
    }

    private String searchNetworkInterfaces(IPFilter ipFilter) {
        return Fn.getJvm("", () -> {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                if (networkInterface.isLoopback() || networkInterface.isVirtual() || !networkInterface.isUp()) continue;
                Enumeration<InetAddress> addressEnumeration = networkInterface.getInetAddresses();
                while (addressEnumeration.hasMoreElements()) {
                    InetAddress inetAddress = addressEnumeration.nextElement();
                    String address = inetAddress.getHostAddress();
                    if (!ipFilter.accept(address)) continue;
                    return address;
                }
            }
            return "";
        }, ipFilter);
    }
}

