/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.stats;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class OperatingSystemMemoryInfo
implements JsonpSerializable {
    private final long freeInBytes;
    private final int freePercent;
    private final long totalInBytes;
    private final long usedInBytes;
    private final int usedPercent;
    public static final JsonpDeserializer<OperatingSystemMemoryInfo> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, OperatingSystemMemoryInfo::setupOperatingSystemMemoryInfoDeserializer);

    private OperatingSystemMemoryInfo(Builder builder) {
        this.freeInBytes = ApiTypeHelper.requireNonNull(builder.freeInBytes, this, "freeInBytes");
        this.freePercent = ApiTypeHelper.requireNonNull(builder.freePercent, this, "freePercent");
        this.totalInBytes = ApiTypeHelper.requireNonNull(builder.totalInBytes, this, "totalInBytes");
        this.usedInBytes = ApiTypeHelper.requireNonNull(builder.usedInBytes, this, "usedInBytes");
        this.usedPercent = ApiTypeHelper.requireNonNull(builder.usedPercent, this, "usedPercent");
    }

    public static OperatingSystemMemoryInfo of(Function<Builder, ObjectBuilder<OperatingSystemMemoryInfo>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long freeInBytes() {
        return this.freeInBytes;
    }

    public final int freePercent() {
        return this.freePercent;
    }

    public final long totalInBytes() {
        return this.totalInBytes;
    }

    public final long usedInBytes() {
        return this.usedInBytes;
    }

    public final int usedPercent() {
        return this.usedPercent;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("free_in_bytes");
        generator.write(this.freeInBytes);
        generator.writeKey("free_percent");
        generator.write(this.freePercent);
        generator.writeKey("total_in_bytes");
        generator.write(this.totalInBytes);
        generator.writeKey("used_in_bytes");
        generator.write(this.usedInBytes);
        generator.writeKey("used_percent");
        generator.write(this.usedPercent);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupOperatingSystemMemoryInfoDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::freeInBytes, JsonpDeserializer.longDeserializer(), "free_in_bytes");
        op.add(Builder::freePercent, JsonpDeserializer.integerDeserializer(), "free_percent");
        op.add(Builder::totalInBytes, JsonpDeserializer.longDeserializer(), "total_in_bytes");
        op.add(Builder::usedInBytes, JsonpDeserializer.longDeserializer(), "used_in_bytes");
        op.add(Builder::usedPercent, JsonpDeserializer.integerDeserializer(), "used_percent");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<OperatingSystemMemoryInfo> {
        private Long freeInBytes;
        private Integer freePercent;
        private Long totalInBytes;
        private Long usedInBytes;
        private Integer usedPercent;

        public final Builder freeInBytes(long value) {
            this.freeInBytes = value;
            return this;
        }

        public final Builder freePercent(int value) {
            this.freePercent = value;
            return this;
        }

        public final Builder totalInBytes(long value) {
            this.totalInBytes = value;
            return this;
        }

        public final Builder usedInBytes(long value) {
            this.usedInBytes = value;
            return this;
        }

        public final Builder usedPercent(int value) {
            this.usedPercent = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public OperatingSystemMemoryInfo build() {
            this._checkSingleUse();
            return new OperatingSystemMemoryInfo(this);
        }
    }
}

