/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.common.log.dialect.log4j;

import cn.hutool.core.util.StrUtil;
import com.aizuda.snailjob.common.log.dialect.AbstractLog;
import com.aizuda.snailjob.common.log.factory.LogFactory;
import com.aizuda.snailjob.common.log.level.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.MDC;
import org.apache.log4j.Priority;

public class Log4jLog
extends AbstractLog {
    private static final long serialVersionUID = -6843151523380063975L;
    private final Logger logger;

    public Log4jLog(Logger logger) {
        this.logger = logger;
    }

    public Log4jLog(Class<?> clazz) {
        this(null == clazz ? "null" : clazz.getName());
    }

    public Log4jLog(String name) {
        this(Logger.getLogger((String)name));
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public void trace(Boolean remote, String fqcn, String format, Object ... arguments) {
        this.log(Level.TRACE, remote, fqcn, format, arguments);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public void debug(Boolean remote, String fqcn, String format, Object ... arguments) {
        this.log(Level.DEBUG, remote, fqcn, format, arguments);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public void info(Boolean remote, String fqcn, String format, Object ... arguments) {
        this.log(Level.INFO, remote, fqcn, format, arguments);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isEnabledFor((Priority)org.apache.log4j.Level.WARN);
    }

    @Override
    public void warn(Boolean remote, String fqcn, String format, Object ... arguments) {
        this.log(Level.WARN, remote, fqcn, format, arguments);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isEnabledFor((Priority)org.apache.log4j.Level.ERROR);
    }

    @Override
    public void error(Boolean remote, String fqcn, String format, Object ... arguments) {
        this.log(Level.ERROR, remote, fqcn, format, arguments);
    }

    @Override
    public void log(Level level, Boolean remote, String fqcn, String format, Object ... arguments) {
        org.apache.log4j.Level log4jLevel = switch (level) {
            case Level.TRACE -> org.apache.log4j.Level.TRACE;
            case Level.DEBUG -> org.apache.log4j.Level.DEBUG;
            case Level.INFO -> org.apache.log4j.Level.INFO;
            case Level.WARN -> org.apache.log4j.Level.WARN;
            case Level.ERROR -> org.apache.log4j.Level.ERROR;
            default -> throw new Error(StrUtil.format((CharSequence)"Can not identify level: {}", (Object[])new Object[]{level}));
        };
        if (this.logger.isEnabledFor((Priority)log4jLevel)) {
            if (remote.booleanValue()) {
                MDC.put((String)"remote", (Object)remote.toString());
            }
            this.logger.log(fqcn, (Priority)log4jLevel, (Object)StrUtil.format((CharSequence)format, (Object[])arguments), LogFactory.extractThrowable(arguments));
        }
    }
}

