/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.retry.task.support.dispatch.actor.result;

import akka.actor.AbstractActor;
import cn.hutool.core.lang.Assert;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.IdempotentStrategy;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.common.triple.ImmutableTriple;
import com.aizuda.snailjob.server.retry.task.support.RetryContext;
import com.aizuda.snailjob.server.retry.task.support.idempotent.IdempotentHolder;
import com.aizuda.snailjob.server.retry.task.support.retry.RetryExecutor;
import com.aizuda.snailjob.template.datasource.access.AccessTemplate;
import com.aizuda.snailjob.template.datasource.persistence.po.RetryTask;
import java.time.LocalDateTime;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="NoRetryActor")
@Scope(value="prototype")
public class NoRetryActor
extends AbstractActor {
    private final IdempotentStrategy<String> idempotentStrategy = IdempotentHolder.getRetryIdempotent();
    private final AccessTemplate accessTemplate;

    public AbstractActor.Receive createReceive() {
        return this.receiveBuilder().match(RetryExecutor.class, retryExecutor -> {
            RetryContext retryContext = retryExecutor.getRetryContext();
            RetryTask retryTask = retryContext.getRetryTask();
            retryTask.setRetryCount(null);
            try {
                retryTask.setUpdateDt(LocalDateTime.now());
                Assert.isTrue((1 == this.accessTemplate.getRetryTaskAccess().updateById(retryTask.getGroupName(), retryTask.getNamespaceId(), (Object)retryTask) ? 1 : 0) != 0, () -> new SnailJobServerException("\u66f4\u65b0\u91cd\u8bd5\u4efb\u52a1\u5931\u8d25. groupName:[{}] uniqueId:[{}]", new Object[]{retryTask.getGroupName(), retryTask.getUniqueId()}));
            }
            catch (Exception e) {
                SnailJobLog.LOCAL.error("\u66f4\u65b0\u91cd\u8bd5\u4efb\u52a1\u5931\u8d25", new Object[]{e});
            }
            finally {
                this.idempotentStrategy.clear((Object)ImmutableTriple.of((Object)retryTask.getGroupName(), (Object)retryTask.getNamespaceId(), (Object)retryTask.getId()).toString());
                this.getContext().stop(this.getSelf());
            }
        }).build();
    }

    public NoRetryActor(AccessTemplate accessTemplate) {
        this.accessTemplate = accessTemplate;
    }
}

