/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.retry.task.support.timer;

import com.aizuda.snailjob.server.common.TimerTask;
import com.aizuda.snailjob.server.retry.task.support.timer.RetryTimerWheel;
import io.netty.util.Timeout;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTimerTask
implements TimerTask<String> {
    private static final Logger log = LoggerFactory.getLogger(AbstractTimerTask.class);
    protected String groupName;
    protected String uniqueId;
    protected String namespaceId;

    public void run(Timeout timeout) throws Exception {
        log.debug("\u5f00\u59cb\u6267\u884c\u91cd\u8bd5\u4efb\u52a1. \u5f53\u524d\u65f6\u95f4:[{}] groupName:[{}] uniqueId:[{}] namespaceId:[{}]", new Object[]{LocalDateTime.now(), this.groupName, this.uniqueId, this.namespaceId});
        try {
            this.doRun(timeout);
        }
        catch (Exception e) {
            log.error("\u91cd\u8bd5\u4efb\u52a1\u6267\u884c\u5931\u8d25 groupName:[{}] uniqueId:[{}] namespaceId:[{}]", new Object[]{this.groupName, this.uniqueId, this.namespaceId, e});
        }
        finally {
            RetryTimerWheel.clearCache((String)this.idempotentKey());
        }
    }

    protected abstract void doRun(Timeout var1);
}

