/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.jwt.internal.org.bouncycastle.pqc.jcajce.provider.mceliece;

import com.auth0.jwt.internal.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.auth0.jwt.internal.org.bouncycastle.asn1.ASN1Primitive;
import com.auth0.jwt.internal.org.bouncycastle.asn1.DERNull;
import com.auth0.jwt.internal.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.auth0.jwt.internal.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.auth0.jwt.internal.org.bouncycastle.crypto.CipherParameters;
import com.auth0.jwt.internal.org.bouncycastle.pqc.asn1.McElieceCCA2PrivateKey;
import com.auth0.jwt.internal.org.bouncycastle.pqc.crypto.mceliece.McElieceCCA2Parameters;
import com.auth0.jwt.internal.org.bouncycastle.pqc.crypto.mceliece.McElieceCCA2PrivateKeyParameters;
import com.auth0.jwt.internal.org.bouncycastle.pqc.jcajce.spec.McElieceCCA2PrivateKeySpec;
import com.auth0.jwt.internal.org.bouncycastle.pqc.math.linearalgebra.GF2Matrix;
import com.auth0.jwt.internal.org.bouncycastle.pqc.math.linearalgebra.GF2mField;
import com.auth0.jwt.internal.org.bouncycastle.pqc.math.linearalgebra.Permutation;
import com.auth0.jwt.internal.org.bouncycastle.pqc.math.linearalgebra.PolynomialGF2mSmallM;
import java.io.IOException;
import java.security.PrivateKey;

public class BCMcElieceCCA2PrivateKey
implements CipherParameters,
PrivateKey {
    private static final long serialVersionUID = 1L;
    private String oid;
    private int n;
    private int k;
    private GF2mField field;
    private PolynomialGF2mSmallM goppaPoly;
    private Permutation p;
    private GF2Matrix h;
    private PolynomialGF2mSmallM[] qInv;
    private McElieceCCA2Parameters mcElieceCCA2Params;

    public BCMcElieceCCA2PrivateKey(String string, int n, int n2, GF2mField gF2mField, PolynomialGF2mSmallM polynomialGF2mSmallM, Permutation permutation, GF2Matrix gF2Matrix, PolynomialGF2mSmallM[] polynomialGF2mSmallMArray) {
        this.oid = string;
        this.n = n;
        this.k = n2;
        this.field = gF2mField;
        this.goppaPoly = polynomialGF2mSmallM;
        this.p = permutation;
        this.h = gF2Matrix;
        this.qInv = polynomialGF2mSmallMArray;
    }

    public BCMcElieceCCA2PrivateKey(McElieceCCA2PrivateKeySpec mcElieceCCA2PrivateKeySpec) {
        this(mcElieceCCA2PrivateKeySpec.getOIDString(), mcElieceCCA2PrivateKeySpec.getN(), mcElieceCCA2PrivateKeySpec.getK(), mcElieceCCA2PrivateKeySpec.getField(), mcElieceCCA2PrivateKeySpec.getGoppaPoly(), mcElieceCCA2PrivateKeySpec.getP(), mcElieceCCA2PrivateKeySpec.getH(), mcElieceCCA2PrivateKeySpec.getQInv());
    }

    public BCMcElieceCCA2PrivateKey(McElieceCCA2PrivateKeyParameters mcElieceCCA2PrivateKeyParameters) {
        this(mcElieceCCA2PrivateKeyParameters.getOIDString(), mcElieceCCA2PrivateKeyParameters.getN(), mcElieceCCA2PrivateKeyParameters.getK(), mcElieceCCA2PrivateKeyParameters.getField(), mcElieceCCA2PrivateKeyParameters.getGoppaPoly(), mcElieceCCA2PrivateKeyParameters.getP(), mcElieceCCA2PrivateKeyParameters.getH(), mcElieceCCA2PrivateKeyParameters.getQInv());
        this.mcElieceCCA2Params = mcElieceCCA2PrivateKeyParameters.getParameters();
    }

    public String getAlgorithm() {
        return "McEliece";
    }

    public int getN() {
        return this.n;
    }

    public int getK() {
        return this.k;
    }

    public int getT() {
        return this.goppaPoly.getDegree();
    }

    public GF2mField getField() {
        return this.field;
    }

    public PolynomialGF2mSmallM getGoppaPoly() {
        return this.goppaPoly;
    }

    public Permutation getP() {
        return this.p;
    }

    public GF2Matrix getH() {
        return this.h;
    }

    public PolynomialGF2mSmallM[] getQInv() {
        return this.qInv;
    }

    public String toString() {
        String string = "";
        string = string + " extension degree of the field      : " + this.n + "\n";
        string = string + " dimension of the code              : " + this.k + "\n";
        string = string + " irreducible Goppa polynomial       : " + this.goppaPoly + "\n";
        return string;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof BCMcElieceCCA2PrivateKey)) {
            return false;
        }
        BCMcElieceCCA2PrivateKey bCMcElieceCCA2PrivateKey = (BCMcElieceCCA2PrivateKey)object;
        return this.n == bCMcElieceCCA2PrivateKey.n && this.k == bCMcElieceCCA2PrivateKey.k && this.field.equals(bCMcElieceCCA2PrivateKey.field) && this.goppaPoly.equals(bCMcElieceCCA2PrivateKey.goppaPoly) && this.p.equals(bCMcElieceCCA2PrivateKey.p) && this.h.equals(bCMcElieceCCA2PrivateKey.h);
    }

    public int hashCode() {
        return this.k + this.n + this.field.hashCode() + this.goppaPoly.hashCode() + this.p.hashCode() + this.h.hashCode();
    }

    public String getOIDString() {
        return this.oid;
    }

    protected ASN1ObjectIdentifier getOID() {
        return new ASN1ObjectIdentifier("1.3.6.1.4.1.8301.3.1.3.4.2");
    }

    protected ASN1Primitive getAlgParams() {
        return null;
    }

    public byte[] getEncoded() {
        PrivateKeyInfo privateKeyInfo;
        Object object;
        McElieceCCA2PrivateKey mcElieceCCA2PrivateKey = new McElieceCCA2PrivateKey(new ASN1ObjectIdentifier(this.oid), this.n, this.k, this.field, this.goppaPoly, this.p, this.h, this.qInv);
        try {
            object = new AlgorithmIdentifier(this.getOID(), DERNull.INSTANCE);
            privateKeyInfo = new PrivateKeyInfo((AlgorithmIdentifier)object, mcElieceCCA2PrivateKey);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        try {
            object = privateKeyInfo.getEncoded();
            return object;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public String getFormat() {
        return null;
    }

    public McElieceCCA2Parameters getMcElieceCCA2Parameters() {
        return this.mcElieceCCA2Params;
    }
}

