/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.inference;

import com.azure.ai.inference.models.ChatChoice;
import com.azure.ai.inference.models.ChatCompletions;
import com.azure.ai.inference.models.ChatCompletionsOptions;
import com.azure.ai.inference.models.ChatCompletionsToolCall;
import com.azure.ai.inference.models.ChatRequestMessage;
import com.azure.ai.inference.models.ChatRole;
import com.azure.ai.inference.models.CompletionsFinishReason;
import com.azure.ai.inference.models.CompletionsUsage;
import com.azure.ai.inference.models.StreamingChatChoiceUpdate;
import com.azure.ai.inference.models.StreamingChatCompletionsUpdate;
import com.azure.ai.inference.models.StreamingChatResponseMessageUpdate;
import com.azure.ai.inference.models.StreamingChatResponseToolCallUpdate;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Configuration;
import com.azure.core.util.ConfigurationProperty;
import com.azure.core.util.ConfigurationPropertyBuilder;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.tracing.SpanKind;
import com.azure.core.util.tracing.StartSpanOptions;
import com.azure.core.util.tracing.Tracer;
import com.azure.json.JsonProviders;
import com.azure.json.JsonWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.List;
import java.util.StringJoiner;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

final class ChatCompletionClientTracer {
    public static final String OTEL_SCHEMA_URL = "https://opentelemetry.io/schemas/1.29.0";
    private static final ClientLogger LOGGER = new ClientLogger(ChatCompletionClientTracer.class);
    private static final String INFERENCE_GEN_AI_SYSTEM_NAME = "az.ai.inference";
    private static final String FINISH_REASON_ERROR = "{\"finish_reason\": \"error\"}";
    private static final String FINISH_REASON_CANCELLED = "{\"finish_reason\": \"cancelled\"}";
    private static final StartSpanOptions START_SPAN_OPTIONS = new StartSpanOptions(SpanKind.CLIENT);
    private static final ConfigurationProperty<Boolean> CAPTURE_MESSAGE_CONTENT = ConfigurationPropertyBuilder.ofBoolean((String)"azure.tracing.gen_ai.content_recording_enabled").environmentVariableName("AZURE_TRACING_GEN_AI_CONTENT_RECORDING_ENABLED").systemPropertyName("azure.tracing.gen_ai.content_recording_enabled").shared(true).defaultValue((Object)false).build();
    private static final Configuration GLOBAL_CONFIG = Configuration.getGlobalConfiguration();
    private final String host;
    private final int port;
    private final boolean captureContent;
    private final Tracer tracer;

    ChatCompletionClientTracer(String endpoint, Configuration configuration, Tracer tracer) {
        URL url = ChatCompletionClientTracer.parse(endpoint);
        if (url != null) {
            this.host = url.getHost();
            this.port = url.getPort() == -1 ? url.getDefaultPort() : url.getPort();
        } else {
            this.host = null;
            this.port = -1;
        }
        this.captureContent = configuration == null ? ((Boolean)GLOBAL_CONFIG.get(CAPTURE_MESSAGE_CONTENT)).booleanValue() : ((Boolean)configuration.get(CAPTURE_MESSAGE_CONTENT)).booleanValue();
        this.tracer = tracer;
    }

    ChatCompletions traceSyncComplete(ChatCompletionsOptions request, SyncCompleteOperation operation, BinaryData completeRequest, RequestOptions requestOptions) {
        ChatCompletions chatCompletions;
        block11: {
            if (!this.tracer.isEnabled()) {
                return operation.invoke(completeRequest, requestOptions);
            }
            Context span = this.tracer.start(this.spanName(request), START_SPAN_OPTIONS, ChatCompletionClientTracer.parentSpan(requestOptions));
            if (this.tracer.isRecording(span)) {
                this.traceCompletionRequestAttributes(request, span);
                this.traceCompletionRequestEvents(request.getMessages(), span);
            }
            AutoCloseable ignored = this.tracer.makeSpanCurrent(span);
            try {
                ChatCompletions response = operation.invoke(completeRequest, requestOptions.setContext(span));
                if (this.tracer.isRecording(span)) {
                    this.traceCompletionResponseAttributes(response, span);
                    this.traceCompletionResponseEvents(response, span);
                }
                this.tracer.end(null, null, span);
                chatCompletions = response;
                if (ignored == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    this.tracer.end(null, (Throwable)e, span);
                    ChatCompletionClientTracer.sneakyThrows(e);
                    return null;
                }
            }
            ignored.close();
        }
        return chatCompletions;
    }

    Mono<ChatCompletions> traceComplete(ChatCompletionsOptions request, CompleteOperation operation, BinaryData completeRequest, RequestOptions requestOptions) {
        if (!this.tracer.isEnabled()) {
            return operation.invoke(completeRequest, requestOptions);
        }
        Mono resourceSupplier = Mono.fromSupplier(() -> {
            Context span = this.tracer.start(this.spanName(request), START_SPAN_OPTIONS, ChatCompletionClientTracer.parentSpan(requestOptions));
            if (this.tracer.isRecording(span)) {
                this.traceCompletionRequestAttributes(request, span);
                this.traceCompletionRequestEvents(request.getMessages(), span);
            }
            return span;
        });
        Function<Context, Mono> resourceClosure = span -> {
            RequestOptions rOptions = requestOptions.setContext(span);
            return operation.invoke(completeRequest, rOptions).map(response -> {
                if (this.tracer.isRecording(span)) {
                    this.traceCompletionResponseAttributes((ChatCompletions)response, (Context)span);
                    this.traceCompletionResponseEvents((ChatCompletions)response, (Context)span);
                }
                return response;
            });
        };
        Function<Context, Mono> asyncComplete = span -> {
            this.tracer.end(null, null, span);
            return Mono.empty();
        };
        BiFunction<Context, Throwable, Mono> asyncError = (span, throwable) -> {
            if (this.tracer.isRecording(span)) {
                this.traceChoiceEvent(FINISH_REASON_ERROR, (Context)span);
            }
            this.tracer.end(null, throwable, span);
            return Mono.empty();
        };
        Function<Context, Mono> asyncCancel = span -> {
            if (this.tracer.isRecording(span)) {
                this.traceChoiceEvent(FINISH_REASON_CANCELLED, (Context)span);
            }
            this.tracer.end("cancelled", null, span);
            return Mono.empty();
        };
        return Mono.usingWhen((Publisher)resourceSupplier, resourceClosure, asyncComplete, asyncError, asyncCancel);
    }

    Flux<StreamingChatCompletionsUpdate> traceStreamingCompletion(ChatCompletionsOptions request, StreamingCompleteOperation operation, BinaryData completeRequest, RequestOptions requestOptions) {
        if (!this.tracer.isEnabled()) {
            return operation.invoke(completeRequest, requestOptions);
        }
        StreamingChatCompletionsState state = new StreamingChatCompletionsState(this.captureContent, request, operation, completeRequest, requestOptions);
        Mono resourceSupplier = Mono.fromSupplier(() -> {
            StreamingChatCompletionsState resource = state;
            Context span = this.tracer.start(this.spanName(resource.request), START_SPAN_OPTIONS, ChatCompletionClientTracer.parentSpan(resource.requestOptions));
            if (this.tracer.isRecording(span)) {
                this.traceCompletionRequestAttributes(resource.request, span);
                this.traceCompletionRequestEvents(resource.request.getMessages(), span);
            }
            return resource.setSpan(span);
        });
        Function<StreamingChatCompletionsState, Flux> resourceClosure = resource -> {
            Context span = ((StreamingChatCompletionsState)resource).span;
            RequestOptions rOptions = ((StreamingChatCompletionsState)resource).requestOptions.setContext(span);
            Flux<StreamingChatCompletionsUpdate> completionChunks = ((StreamingChatCompletionsState)resource).operation.invoke(((StreamingChatCompletionsState)resource).completeRequest, rOptions);
            if (this.tracer.isRecording(span)) {
                return completionChunks.doOnNext(resource::onNextChunk);
            }
            return completionChunks;
        };
        Function<StreamingChatCompletionsState, Mono> asyncComplete = resource -> {
            Context span = ((StreamingChatCompletionsState)resource).span;
            if (this.tracer.isRecording(span)) {
                StreamingChatCompletionsUpdate lastChunk = ((StreamingChatCompletionsState)resource).lastChunk;
                String finishReasons = resource.getFinishReasons();
                this.traceCompletionResponseAttributes(lastChunk, finishReasons, span);
                this.traceChoiceEvent(resource.toJson(), span);
            }
            this.tracer.end(null, null, span);
            return Mono.empty();
        };
        BiFunction<StreamingChatCompletionsState, Throwable, Mono> asyncError = (resource, throwable) -> {
            Context span = ((StreamingChatCompletionsState)resource).span;
            if (this.tracer.isRecording(span)) {
                this.traceChoiceEvent(FINISH_REASON_ERROR, span);
            }
            this.tracer.end(null, throwable, span);
            return Mono.empty();
        };
        Function<StreamingChatCompletionsState, Mono> asyncCancel = resource -> {
            Context span = ((StreamingChatCompletionsState)resource).span;
            if (this.tracer.isRecording(span)) {
                this.traceChoiceEvent(FINISH_REASON_CANCELLED, span);
            }
            this.tracer.end("cancelled", null, span);
            return Mono.empty();
        };
        return Flux.usingWhen((Publisher)resourceSupplier, resourceClosure, asyncComplete, asyncError, asyncCancel);
    }

    private String spanName(ChatCompletionsOptions completeRequest) {
        return CoreUtils.isNullOrEmpty((CharSequence)completeRequest.getModel()) ? "chat" : "chat " + completeRequest.getModel();
    }

    private void traceCompletionRequestAttributes(ChatCompletionsOptions request, Context span) {
        String modelId = request.getModel();
        this.tracer.setAttribute("gen_ai.operation.name", "chat", span);
        this.tracer.setAttribute("gen_ai.system", INFERENCE_GEN_AI_SYSTEM_NAME, span);
        this.tracer.setAttribute("gen_ai.request.model", CoreUtils.isNullOrEmpty((CharSequence)modelId) ? "chat" : modelId, span);
        if (request.getFrequencyPenalty() != null) {
            this.tracer.setAttribute("gen_ai.request.frequency_penalty", (Object)request.getFrequencyPenalty(), span);
        }
        if (request.getMaxTokens() != null) {
            this.tracer.setAttribute("gen_ai.request.max_tokens", (Object)request.getMaxTokens(), span);
        }
        if (request.getPresencePenalty() != null) {
            this.tracer.setAttribute("gen_ai.request.presence_penalty", (Object)request.getPresencePenalty(), span);
        }
        if (request.getStop() != null) {
            StringJoiner stopSequence = new StringJoiner(",", "[", "]");
            for (String stop : request.getStop()) {
                stopSequence.add(stop);
            }
            this.tracer.setAttribute("gen_ai.request.stop_sequences", stopSequence.toString(), span);
        }
        if (request.getTemperature() != null) {
            this.tracer.setAttribute("gen_ai.request.temperature", (Object)request.getTemperature(), span);
        }
        if (request.getTopP() != null) {
            this.tracer.setAttribute("gen_ai.request.top_p", (Object)request.getTopP(), span);
        }
        if (this.host != null) {
            this.tracer.setAttribute("server.address", this.host, span);
            if (this.port != 443) {
                this.tracer.setAttribute("server.port", (long)this.port, span);
            }
        }
    }

    private void traceCompletionRequestEvents(List<ChatRequestMessage> messages, Context span) {
        if (!this.captureContent || messages == null) {
            return;
        }
        for (ChatRequestMessage message : messages) {
            ChatRole role = message.getRole();
            if (role == null) continue;
            String eventName = "gen_ai." + role.getValue() + ".message";
            String eventContent = this.toJsonString(message);
            if (eventContent == null) continue;
            HashMap<String, String> eventAttributes = new HashMap<String, String>(2);
            eventAttributes.put("gen_ai.system", INFERENCE_GEN_AI_SYSTEM_NAME);
            eventAttributes.put("gen_ai.event.content", eventContent);
            this.tracer.addEvent(eventName, eventAttributes, null, span);
        }
    }

    private void traceCompletionResponseAttributes(ChatCompletions response, Context span) {
        List<ChatChoice> choices;
        this.tracer.setAttribute("gen_ai.response.id", response.getId(), span);
        this.tracer.setAttribute("gen_ai.response.model", response.getModel(), span);
        CompletionsUsage usage = response.getUsage();
        if (usage != null) {
            this.tracer.setAttribute("gen_ai.usage.input_tokens", (long)usage.getPromptTokens(), span);
            this.tracer.setAttribute("gen_ai.usage.output_tokens", (long)usage.getCompletionTokens(), span);
        }
        if ((choices = response.getChoices()) != null) {
            this.tracer.setAttribute("gen_ai.response.finish_reasons", ChatCompletionClientTracer.getFinishReasons(choices), span);
        }
    }

    private void traceCompletionResponseAttributes(StreamingChatCompletionsUpdate response, String finishReasons, Context span) {
        this.tracer.setAttribute("gen_ai.response.id", response.getId(), span);
        this.tracer.setAttribute("gen_ai.response.model", response.getModel(), span);
        CompletionsUsage usage = response.getUsage();
        if (usage != null) {
            this.tracer.setAttribute("gen_ai.usage.input_tokens", (long)usage.getPromptTokens(), span);
            this.tracer.setAttribute("gen_ai.usage.output_tokens", (long)usage.getCompletionTokens(), span);
        }
        this.tracer.setAttribute("gen_ai.response.finish_reasons", finishReasons, span);
    }

    private void traceCompletionResponseEvents(ChatCompletions response, Context span) {
        List<ChatChoice> choices = response.getChoices();
        if (choices != null) {
            for (ChatChoice choice : choices) {
                this.traceChoiceEvent(this.toJsonString(choice), span);
            }
        }
    }

    private void traceChoiceEvent(String choiceContent, Context span) {
        HashMap<String, String> eventAttributes = new HashMap<String, String>(2);
        eventAttributes.put("gen_ai.system", INFERENCE_GEN_AI_SYSTEM_NAME);
        eventAttributes.put("gen_ai.event.content", choiceContent);
        this.tracer.addEvent("gen_ai.choice", eventAttributes, null, span);
    }

    private String toJsonString(ChatRequestMessage message) {
        try {
            return message.toJsonString();
        }
        catch (IOException e) {
            LOGGER.verbose("'ChatRequestMessage' serialization error", new Object[]{e});
            return null;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String toJsonString(ChatChoice choice) {
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            String string;
            block16: {
                JsonWriter writer = JsonProviders.createWriter((OutputStream)stream);
                try {
                    List<ChatCompletionsToolCall> toolCalls;
                    writer.writeStartObject();
                    writer.writeStartObject("message");
                    if (this.captureContent) {
                        writer.writeStringField("content", choice.getMessage().getContent());
                    }
                    if (choice.getMessage() != null && (toolCalls = choice.getMessage().getToolCalls()) != null && !toolCalls.isEmpty()) {
                        writer.writeArrayField("tool_calls", toolCalls, (w, toolCall) -> {
                            if (this.captureContent) {
                                toolCall.toJson((JsonWriter)w);
                            } else {
                                w.writeStartObject();
                                w.writeStringField("id", toolCall.getId());
                                w.writeStringField("type", toolCall.getType());
                                w.writeEndObject();
                            }
                        });
                    }
                    writer.writeEndObject();
                    CompletionsFinishReason finishReason = choice.getFinishReason();
                    if (finishReason != null) {
                        writer.writeStringField("finish_reason", finishReason.getValue());
                    }
                    writer.writeIntField("index", choice.getIndex());
                    writer.writeEndObject();
                    writer.flush();
                    string = new String(stream.toByteArray(), StandardCharsets.UTF_8);
                    if (writer == null) break block16;
                }
                catch (Throwable throwable) {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                writer.close();
            }
            return string;
        }
        catch (IOException e) {
            LOGGER.verbose("'ChatChoice' serialization error", new Object[]{e});
            return null;
        }
    }

    private static String getFinishReasons(List<ChatChoice> choices) {
        StringJoiner finishReasons = new StringJoiner(",", "[", "]");
        for (ChatChoice choice : choices) {
            CompletionsFinishReason finishReason = choice.getFinishReason();
            if (finishReason == null) continue;
            finishReasons.add(finishReason.getValue());
        }
        return finishReasons.toString();
    }

    private static URL parse(String endpoint) {
        if (CoreUtils.isNullOrEmpty((CharSequence)endpoint)) {
            return null;
        }
        try {
            URI uri = new URI(endpoint);
            return uri.toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            LOGGER.atWarning().log("service endpoint uri parse error.", new Object[]{e});
            return null;
        }
    }

    private static <E extends Throwable> void sneakyThrows(Throwable e) throws E {
        throw e;
    }

    private static Context parentSpan(RequestOptions requestOptions) {
        return requestOptions.getContext() == null ? Context.NONE : requestOptions.getContext();
    }

    @FunctionalInterface
    public static interface SyncCompleteOperation {
        public ChatCompletions invoke(BinaryData var1, RequestOptions var2);
    }

    @FunctionalInterface
    public static interface CompleteOperation {
        public Mono<ChatCompletions> invoke(BinaryData var1, RequestOptions var2);
    }

    @FunctionalInterface
    public static interface StreamingCompleteOperation {
        public Flux<StreamingChatCompletionsUpdate> invoke(BinaryData var1, RequestOptions var2);
    }

    private static final class StreamingChatCompletionsState {
        private final boolean captureContent;
        private final ChatCompletionsOptions request;
        private final StreamingCompleteOperation operation;
        private final BinaryData completeRequest;
        private final RequestOptions requestOptions;
        private final StringBuilder content;
        private final ArrayDeque<StreamingChatResponseToolCallUpdate> toolCalls;
        private final ArrayDeque<String> toolCallIds;
        private final ArrayDeque<CompletionsFinishReason> finishReasons;
        private Context span;
        private StreamingChatCompletionsUpdate lastChunk;
        private CompletionsFinishReason finishReason;
        private int index;

        StreamingChatCompletionsState(boolean captureContent, ChatCompletionsOptions request, StreamingCompleteOperation operation, BinaryData completeRequest, RequestOptions requestOptions) {
            this.captureContent = captureContent;
            this.request = request;
            this.operation = operation;
            this.completeRequest = completeRequest;
            this.requestOptions = requestOptions;
            this.content = new StringBuilder();
            this.toolCalls = new ArrayDeque();
            this.toolCallIds = new ArrayDeque();
            this.finishReasons = new ArrayDeque();
        }

        StreamingChatCompletionsState setSpan(Context context) {
            this.span = context;
            return this;
        }

        void onNextChunk(StreamingChatCompletionsUpdate chunk) {
            this.lastChunk = chunk;
            List<StreamingChatChoiceUpdate> choices = chunk.getChoices();
            if (choices == null || choices.isEmpty()) {
                return;
            }
            for (StreamingChatChoiceUpdate choice : choices) {
                StreamingChatResponseMessageUpdate delta;
                this.finishReason = choice.getFinishReason();
                this.index = choice.getIndex();
                if (choice.getFinishReason() != null) {
                    this.finishReasons.add(choice.getFinishReason());
                }
                if ((delta = choice.getDelta()) == null) continue;
                List<StreamingChatResponseToolCallUpdate> toolCalls = delta.getToolCalls();
                if (this.captureContent) {
                    if (delta.getContent() != null) {
                        this.content.append(delta.getContent());
                    }
                    if (toolCalls == null) continue;
                    this.toolCalls.addAll(toolCalls);
                    continue;
                }
                if (toolCalls == null) continue;
                List ids = toolCalls.stream().map(StreamingChatResponseToolCallUpdate::getId).filter(s -> !CoreUtils.isNullOrEmpty((CharSequence)s)).collect(Collectors.toList());
                this.toolCallIds.addAll(ids);
            }
        }

        /*
         * Enabled aggressive exception aggregation
         */
        String toJson() {
            try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
                String string;
                block18: {
                    JsonWriter writer = JsonProviders.createWriter((OutputStream)stream);
                    try {
                        writer.writeStartObject();
                        writer.writeStartObject("message");
                        if (this.captureContent) {
                            StreamingChatResponseToolCallUpdate toolCall;
                            writer.writeStringField("content", this.content.toString());
                            writer.writeStartArray("tool_calls");
                            while ((toolCall = this.toolCalls.poll()) != null) {
                                toolCall.toJson(writer);
                            }
                            writer.writeEndArray();
                        } else {
                            String toolCallId;
                            writer.writeStartArray("tool_calls");
                            while ((toolCallId = this.toolCallIds.poll()) != null) {
                                writer.writeStartObject();
                                writer.writeStringField("id", toolCallId);
                                writer.writeEndObject();
                            }
                            writer.writeEndArray();
                        }
                        writer.writeEndObject();
                        if (this.finishReason != null) {
                            writer.writeStringField("finish_reason", this.finishReason.getValue());
                        }
                        writer.writeIntField("index", this.index);
                        writer.writeEndObject();
                        writer.flush();
                        string = new String(stream.toByteArray(), StandardCharsets.UTF_8);
                        if (writer == null) break block18;
                    }
                    catch (Throwable throwable) {
                        if (writer != null) {
                            try {
                                writer.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    writer.close();
                }
                return string;
            }
            catch (IOException e) {
                LOGGER.verbose("'StreamingChatCompletionsState' serialization error", new Object[]{e});
                return null;
            }
        }

        String getFinishReasons() {
            CompletionsFinishReason reason;
            StringJoiner finishReasonsSj = new StringJoiner(",", "[", "]");
            while ((reason = this.finishReasons.poll()) != null) {
                finishReasonsSj.add(reason.getValue());
            }
            return finishReasonsSj.toString();
        }
    }
}

