/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test;

import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpClientProvider;
import com.azure.core.test.InterceptorManager;
import com.azure.core.test.TestContextManager;
import com.azure.core.test.TestMode;
import com.azure.core.test.ThreadDumper;
import com.azure.core.test.implementation.TestingHelpers;
import com.azure.core.test.junitextensions.TestContextManagerParameterResolver;
import com.azure.core.test.utils.HttpURLConnectionHttpClient;
import com.azure.core.test.utils.TestResourceNamer;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={TestContextManagerParameterResolver.class})
public abstract class TestBase {
    private static final ClientLogger LOGGER = new ClientLogger(TestBase.class);
    private static final String AZURE_TEST_DEBUG = "AZURE_TEST_DEBUG";
    private static final String AZURE_TEST_HTTP_CLIENTS = "AZURE_TEST_HTTP_CLIENTS";
    public static final String AZURE_TEST_HTTP_CLIENTS_VALUE_ALL = "ALL";
    public static final String AZURE_TEST_HTTP_CLIENTS_VALUE_NETTY = "NettyAsyncHttpClient";
    public static final String AZURE_TEST_SERVICE_VERSIONS_VALUE_ALL = "ALL";
    private static boolean enableTestProxy;
    private static final Duration PLAYBACK_POLL_INTERVAL;
    private static final String CONFIGURED_HTTP_CLIENTS_TO_TEST;
    private static final boolean DEFAULT_TO_NETTY;
    private static final List<String> CONFIGURED_HTTP_CLIENTS;
    private static final AtomicReference<HttpClient> TEST_PROXY_HTTP_CLIENT;
    static TestMode testMode;
    private final ClientLogger logger = new ClientLogger(TestBase.class);
    protected InterceptorManager interceptorManager;
    protected TestResourceNamer testResourceNamer;
    protected TestContextManager testContextManager;
    private long testStartTimeMillis;

    @BeforeAll
    public static void setupClass() {
        testMode = TestBase.initializeTestMode();
    }

    @BeforeEach
    public void setupTest(TestContextManager testContextManager) {
        this.testContextManager = testContextManager;
        Assumptions.assumeTrue((boolean)testContextManager.didTestRun(), (String)"Test does not allow playback and was ran in 'TestMode.PLAYBACK'");
        ThreadDumper.addRunningTest(testContextManager.getTrackerTestName());
        this.logger.info("Test Mode: {}, Name: {}", new Object[]{testContextManager.getTestMode(), testContextManager.getTrackerTestName()});
        if (TestBase.shouldLogExecutionStatus()) {
            System.out.println("Starting test " + testContextManager.getTrackerTestName() + ".");
            this.testStartTimeMillis = System.currentTimeMillis();
        }
        try {
            this.interceptorManager = new InterceptorManager(testContextManager);
        }
        catch (UncheckedIOException e) {
            this.logger.error("Could not create interceptor for {}", new Object[]{testContextManager.getTestName(), e});
            Assertions.fail((Throwable)e);
        }
        if (TestBase.isTestProxyEnabled()) {
            this.interceptorManager.setHttpClient(TestBase.getTestProxyHttpClient());
            this.testResourceNamer = new TestResourceNamer(testContextManager, this.interceptorManager.getProxyVariableConsumer(), this.interceptorManager.getProxyVariableSupplier());
            if (testContextManager.getTestMode() == TestMode.PLAYBACK && !testContextManager.doNotRecordTest()) {
                this.interceptorManager.getPlaybackClient();
            } else if (testContextManager.getTestMode() == TestMode.RECORD && !testContextManager.doNotRecordTest()) {
                this.interceptorManager.getRecordPolicy();
            }
        } else {
            this.testResourceNamer = new TestResourceNamer(testContextManager, this.interceptorManager.getRecordedData());
        }
        this.beforeTest();
    }

    @AfterEach
    public void teardownTest() {
        if (TestBase.shouldLogExecutionStatus()) {
            if (this.testStartTimeMillis > 0L) {
                long duration = System.currentTimeMillis() - this.testStartTimeMillis;
                System.out.println("Finished test " + this.testContextManager.getTrackerTestName() + " in " + duration + " ms.");
            } else {
                System.out.println("Finished test " + this.testContextManager.getTrackerTestName() + ", duration unknown.");
            }
        }
        if (this.testContextManager != null) {
            ThreadDumper.removeRunningTest(this.testContextManager.getTrackerTestName());
            if (this.testContextManager.didTestRun()) {
                this.afterTest();
                this.interceptorManager.close();
            }
        }
    }

    public TestMode getTestMode() {
        return testMode;
    }

    @Deprecated
    protected String getTestName() {
        if (this.testContextManager != null) {
            return this.testContextManager.getTestName();
        }
        return null;
    }

    protected void beforeTest() {
    }

    protected void afterTest() {
    }

    public static Stream<HttpClient> getHttpClients() {
        if (testMode == TestMode.PLAYBACK && !enableTestProxy) {
            return Stream.of(new HttpClient[]{null});
        }
        ArrayList<HttpClient> httpClientsToTest = new ArrayList<HttpClient>();
        Iterator<HttpClientProvider> iterator = ServiceLoader.load(HttpClientProvider.class).iterator();
        while (iterator.hasNext()) {
            try {
                HttpClientProvider httpClientProvider = iterator.next();
                if (!TestBase.includeHttpClientOrHttpClientProvider(httpClientProvider.getClass().getSimpleName().toLowerCase(Locale.ROOT))) continue;
                httpClientsToTest.add(httpClientProvider.createInstance());
            }
            catch (LinkageError | ServiceConfigurationError error) {
                LOGGER.atWarning().log(() -> "Skipping HttpClientProvider due to LinkageError.", (Throwable)error);
            }
        }
        return httpClientsToTest.stream();
    }

    public static boolean shouldClientBeTested(HttpClient client) {
        return TestBase.includeHttpClientOrHttpClientProvider(client.getClass().getSimpleName().toLowerCase(Locale.ROOT));
    }

    private static boolean includeHttpClientOrHttpClientProvider(String name) {
        if ("ALL".equalsIgnoreCase(CONFIGURED_HTTP_CLIENTS_TO_TEST)) {
            return true;
        }
        return CONFIGURED_HTTP_CLIENTS.stream().anyMatch(name::contains);
    }

    static TestMode initializeTestMode() {
        return TestingHelpers.getTestMode();
    }

    public static boolean isTestProxyEnabled() {
        return enableTestProxy;
    }

    protected static void setTestProxyEnabled() {
        enableTestProxy = true;
    }

    protected Path getTestClassPath() {
        return this.testContextManager.getTestClassPath();
    }

    protected void sleepIfRunningAgainstService(long millis) {
        if (testMode == TestMode.PLAYBACK) {
            return;
        }
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException ex) {
            throw this.logger.logExceptionAsWarning((RuntimeException)new IllegalStateException(ex));
        }
    }

    protected <T, U> SyncPoller<T, U> setPlaybackSyncPollerPollInterval(SyncPoller<T, U> syncPoller) {
        return testMode == TestMode.PLAYBACK ? syncPoller.setPollInterval(PLAYBACK_POLL_INTERVAL) : syncPoller;
    }

    protected <T, U> PollerFlux<T, U> setPlaybackPollerFluxPollInterval(PollerFlux<T, U> pollerFlux) {
        return testMode == TestMode.PLAYBACK ? pollerFlux.setPollInterval(PLAYBACK_POLL_INTERVAL) : pollerFlux;
    }

    protected HttpClient getHttpClientOrUsePlayback(HttpClient httpClient) {
        return testMode == TestMode.PLAYBACK ? this.interceptorManager.getPlaybackClient() : httpClient;
    }

    private static HttpClient getTestProxyHttpClient() {
        return TEST_PROXY_HTTP_CLIENT.updateAndGet(httpClient -> httpClient == null ? TestBase.getHttpClients().findFirst().orElse(new HttpURLConnectionHttpClient()) : httpClient);
    }

    static boolean shouldLogExecutionStatus() {
        return (Boolean)Configuration.getGlobalConfiguration().get(AZURE_TEST_DEBUG, (Object)false);
    }

    static {
        PLAYBACK_POLL_INTERVAL = Duration.ofMillis(1L);
        CONFIGURED_HTTP_CLIENTS_TO_TEST = Configuration.getGlobalConfiguration().get(AZURE_TEST_HTTP_CLIENTS);
        DEFAULT_TO_NETTY = CoreUtils.isNullOrEmpty((CharSequence)CONFIGURED_HTTP_CLIENTS_TO_TEST);
        TEST_PROXY_HTTP_CLIENT = new AtomicReference();
        CONFIGURED_HTTP_CLIENTS = new ArrayList<String>();
        if (DEFAULT_TO_NETTY) {
            CONFIGURED_HTTP_CLIENTS.add("netty");
        } else {
            for (String configuredHttpClient : CONFIGURED_HTTP_CLIENTS_TO_TEST.split(",")) {
                if (CoreUtils.isNullOrEmpty((CharSequence)configuredHttpClient)) continue;
                CONFIGURED_HTTP_CLIENTS.add(configuredHttpClient.trim().toLowerCase(Locale.ROOT));
            }
        }
    }
}

