/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test.implementation;

import com.azure.core.http.HttpClient;
import com.azure.core.test.TestBase;
import com.azure.core.test.TestMode;
import com.azure.core.test.annotation.AzureMethodSource;
import com.azure.core.test.implementation.TestingHelpers;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.ServiceVersion;
import com.azure.core.util.logging.ClientLogger;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.support.AnnotationConsumer;
import org.junit.platform.commons.support.ReflectionSupport;

public final class AzureMethodSourceArgumentsProvider
implements ArgumentsProvider,
AnnotationConsumer<AzureMethodSource> {
    private static final TestMode TEST_MODE = TestingHelpers.getTestMode();
    private static final Map<Class<? extends ServiceVersion>, ServiceVersion> CLASS_TO_LATEST_SERVICE_VERSION = new ConcurrentHashMap<Class<? extends ServiceVersion>, ServiceVersion>();
    private static final Map<Class<? extends ServiceVersion>, Map<String, ServiceVersion>> CLASS_TO_MAP_STRING_SERVICE_VERSION = new ConcurrentHashMap<Class<? extends ServiceVersion>, Map<String, ServiceVersion>>();
    private static final String MUST_BE_STATIC = "Source supplier method is required to be static. Method: %s.";
    private static final String MUST_BE_STREAM_ARGUMENTS = "Source supplier method is required to return Stream<Arguments>. Return type: %s.";
    private final ClientLogger logger = new ClientLogger(AzureMethodSourceArgumentsProvider.class);
    private String minimumServiceVersion;
    private String maximumServiceVersion;
    private Class<? extends ServiceVersion> serviceVersionType;
    private String sourceSupplier;
    private boolean useHttpClientPermutation;

    public void accept(AzureMethodSource annotation) {
        this.minimumServiceVersion = annotation.minimumServiceVersion();
        this.maximumServiceVersion = annotation.maximumServiceVersion();
        this.serviceVersionType = annotation.serviceVersionType();
        if (!Enum.class.isAssignableFrom(this.serviceVersionType)) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'serviceVersionType' isn't an instance of Enum."));
        }
        this.sourceSupplier = annotation.sourceSupplier();
        this.useHttpClientPermutation = annotation.useHttpClientPermutation();
    }

    public Stream<? extends Arguments> provideArguments(ExtensionContext context) throws Exception {
        List<Object> httpClientsToUse = Collections.singletonList(null);
        if (!this.useHttpClientPermutation && TEST_MODE != TestMode.PLAYBACK) {
            httpClientsToUse = TestBase.getHttpClients().collect(Collectors.toList());
        }
        boolean testAllServiceVersions = (Boolean)Configuration.getGlobalConfiguration().get("AZURE_TEST_ALL_SERVICE_VERSIONS", (Object)false);
        List<? extends ServiceVersion> serviceVersionsToUse = AzureMethodSourceArgumentsProvider.getServiceVersions(this.minimumServiceVersion, this.maximumServiceVersion, this.serviceVersionType, TEST_MODE, testAllServiceVersions);
        List<Arguments> testValues = null;
        if (!CoreUtils.isNullOrEmpty((CharSequence)this.sourceSupplier)) {
            Object source = AzureMethodSourceArgumentsProvider.invokeSupplierMethod(context, this.sourceSupplier);
            testValues = AzureMethodSourceArgumentsProvider.convertSupplierSourceToArguments(source);
        }
        if (!this.useHttpClientPermutation && testValues == null) {
            return serviceVersionsToUse.stream().map(xva$0 -> Arguments.arguments((Object[])new Object[]{xva$0}));
        }
        if (!this.useHttpClientPermutation) {
            return AzureMethodSourceArgumentsProvider.createNonHttpPermutations(serviceVersionsToUse, testValues).stream();
        }
        if (testValues == null) {
            return AzureMethodSourceArgumentsProvider.createHttpServiceVersionPermutations(httpClientsToUse, serviceVersionsToUse).stream();
        }
        if (CoreUtils.isNullOrEmpty(httpClientsToUse)) {
            return AzureMethodSourceArgumentsProvider.createFullPermutations(Collections.singletonList(null), serviceVersionsToUse, testValues).stream();
        }
        return AzureMethodSourceArgumentsProvider.createFullPermutations(httpClientsToUse, serviceVersionsToUse, testValues).stream();
    }

    static List<? extends ServiceVersion> getServiceVersions(String minimumServiceVersion, String maximumServiceVersion, Class<? extends ServiceVersion> serviceVersionType, TestMode testMode, boolean testAllServiceVersions) {
        AzureMethodSourceArgumentsProvider.loadServiceVersion(serviceVersionType);
        if (testAllServiceVersions && testMode == TestMode.LIVE) {
            int minimumOrdinal = AzureMethodSourceArgumentsProvider.getServiceVersionRangeBound(minimumServiceVersion, serviceVersionType, false);
            int maximumOrdinal = AzureMethodSourceArgumentsProvider.getServiceVersionRangeBound(maximumServiceVersion, serviceVersionType, true);
            return CLASS_TO_MAP_STRING_SERVICE_VERSION.get(serviceVersionType).values().stream().filter(sv -> {
                int ordinal = ((Enum)sv).ordinal();
                return ordinal >= minimumOrdinal && ordinal <= maximumOrdinal;
            }).collect(Collectors.toList());
        }
        Enum<?> maximumServiceVersionEnum = AzureMethodSourceArgumentsProvider.getEnumOrNull(maximumServiceVersion, serviceVersionType);
        ServiceVersion latestServiceVersion = CLASS_TO_LATEST_SERVICE_VERSION.get(serviceVersionType);
        if (maximumServiceVersionEnum == null) {
            return Collections.singletonList(latestServiceVersion);
        }
        if (maximumServiceVersionEnum.ordinal() >= ((Enum)latestServiceVersion).ordinal()) {
            return Collections.singletonList(latestServiceVersion);
        }
        return Collections.singletonList(CLASS_TO_MAP_STRING_SERVICE_VERSION.get(serviceVersionType).get(maximumServiceVersion));
    }

    private static int getServiceVersionRangeBound(String serviceVersion, Class<? extends ServiceVersion> serviceVersionType, boolean isMaximum) {
        Enum<?> serviceVersionEnum = AzureMethodSourceArgumentsProvider.getEnumOrNull(serviceVersion, serviceVersionType);
        if (serviceVersionEnum == null) {
            return isMaximum ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        }
        return serviceVersionEnum.ordinal();
    }

    private static Enum<?> getEnumOrNull(String serviceVersion, Class<? extends ServiceVersion> serviceVersionType) {
        return CoreUtils.isNullOrEmpty((CharSequence)serviceVersion) ? null : (Enum)CLASS_TO_MAP_STRING_SERVICE_VERSION.get(serviceVersionType).get(serviceVersion);
    }

    private static void loadServiceVersion(Class<? extends ServiceVersion> serviceVersionType) {
        CLASS_TO_MAP_STRING_SERVICE_VERSION.computeIfAbsent(serviceVersionType, type -> {
            try {
                ServiceVersion[] serviceVersions = (ServiceVersion[])serviceVersionType.getMethod("values", new Class[0]).invoke((Object)serviceVersionType, new Object[0]);
                TreeMap<String, ServiceVersion> stringServiceVersionMap = new TreeMap<String, ServiceVersion>();
                for (ServiceVersion serviceVersion : serviceVersions) {
                    stringServiceVersionMap.put(serviceVersion.getVersion(), serviceVersion);
                }
                return stringServiceVersionMap;
            }
            catch (ReflectiveOperationException ex) {
                throw new IllegalStateException(ex);
            }
        });
        CLASS_TO_LATEST_SERVICE_VERSION.computeIfAbsent(serviceVersionType, type -> {
            try {
                return (ServiceVersion)serviceVersionType.getMethod("getLatest", new Class[0]).invoke((Object)serviceVersionType, new Object[0]);
            }
            catch (ReflectiveOperationException ex) {
                throw new IllegalStateException(ex);
            }
        });
    }

    static Object invokeSupplierMethod(ExtensionContext context, String sourceSupplier) throws Exception {
        Optional sourceSupplierMethod;
        if (sourceSupplier.contains("#")) {
            String[] classAndMethod = sourceSupplier.split("#", 2);
            Class sourceSupplierClass = (Class)ReflectionSupport.tryToLoadClass((String)classAndMethod[0]).get();
            sourceSupplierMethod = ReflectionSupport.findMethod((Class)sourceSupplierClass, (String)classAndMethod[1], (Class[])new Class[0]);
        } else {
            Class sourceSupplierClass = context.getRequiredTestClass();
            sourceSupplierMethod = ReflectionSupport.findMethod((Class)sourceSupplierClass, (String)sourceSupplier, (Class[])new Class[0]);
        }
        if (!sourceSupplierMethod.isPresent()) {
            throw new IllegalArgumentException(String.format("Unable to find 'sourceSupplier' method %s.", sourceSupplierMethod));
        }
        AzureMethodSourceArgumentsProvider.validateSourceSupplier((Method)sourceSupplierMethod.get());
        return ReflectionSupport.invokeMethod((Method)((Method)sourceSupplierMethod.get()), (Object)sourceSupplier, (Object[])new Object[0]);
    }

    static void validateSourceSupplier(Method sourceMethod) {
        int modifiers = sourceMethod.getModifiers();
        if ((modifiers | 8) != modifiers) {
            throw new IllegalArgumentException(String.format(MUST_BE_STATIC, sourceMethod.getName()));
        }
        Type returnType = sourceMethod.getGenericReturnType();
        boolean validReturnType = returnType instanceof ParameterizedType;
        if (!validReturnType) {
            throw new IllegalArgumentException(String.format(MUST_BE_STREAM_ARGUMENTS, returnType));
        }
        ParameterizedType parameterizedType = (ParameterizedType)returnType;
        boolean bl = validReturnType = parameterizedType.getRawType() instanceof Class && Stream.class.isAssignableFrom((Class)parameterizedType.getRawType()) && parameterizedType.getActualTypeArguments().length == 1 && parameterizedType.getActualTypeArguments()[0] instanceof Class && Arguments.class.isAssignableFrom((Class)parameterizedType.getActualTypeArguments()[0]);
        if (!validReturnType) {
            throw new IllegalArgumentException(String.format(MUST_BE_STREAM_ARGUMENTS, returnType));
        }
    }

    static List<Arguments> convertSupplierSourceToArguments(Object source) {
        if (source instanceof Stream) {
            return ((Stream)source).map(AzureMethodSourceArgumentsProvider::convertToArguments).collect(Collectors.toList());
        }
        throw new IllegalStateException("'sourceSupplier' returned an unsupported type: " + source.getClass());
    }

    static Arguments convertToArguments(Object value) {
        if (value instanceof Arguments) {
            return (Arguments)value;
        }
        throw new IllegalStateException("Test parameterized source is an unsupported type: " + value.getClass());
    }

    static List<Arguments> createHttpServiceVersionPermutations(List<HttpClient> httpClients, List<? extends ServiceVersion> serviceVersions) {
        ArrayList<Arguments> arguments = new ArrayList<Arguments>();
        for (HttpClient httpClient : httpClients) {
            for (ServiceVersion serviceVersion : serviceVersions) {
                arguments.add(Arguments.of((Object[])new Object[]{httpClient, serviceVersion}));
            }
        }
        return arguments;
    }

    static List<Arguments> createNonHttpPermutations(List<? extends ServiceVersion> serviceVersions, List<Arguments> parameterizedTestingValues) {
        ArrayList<Arguments> arguments = new ArrayList<Arguments>();
        for (ServiceVersion serviceVersion : serviceVersions) {
            for (Arguments parameterizedTestingValue : parameterizedTestingValues) {
                arguments.add(AzureMethodSourceArgumentsProvider.prependArguments(serviceVersion, null, parameterizedTestingValue));
            }
        }
        return arguments;
    }

    static List<Arguments> createFullPermutations(List<HttpClient> httpClients, List<? extends ServiceVersion> serviceVersions, List<Arguments> parameterizedTestingValues) {
        ArrayList<Arguments> arguments = new ArrayList<Arguments>();
        for (HttpClient httpClient : httpClients) {
            for (ServiceVersion serviceVersion : serviceVersions) {
                for (Arguments parameterizedTestingValue : parameterizedTestingValues) {
                    arguments.add(AzureMethodSourceArgumentsProvider.prependArguments(httpClient, serviceVersion, parameterizedTestingValue));
                }
            }
        }
        return arguments;
    }

    private static Arguments prependArguments(Object prepend, Object optionalPrepend, Arguments arguments) {
        boolean hasOptionalPrepend = optionalPrepend != null;
        Object[] previousArgs = arguments.get();
        Object[] newArgs = new Object[previousArgs.length + 1 + (hasOptionalPrepend ? 1 : 0)];
        newArgs[0] = prepend;
        if (hasOptionalPrepend) {
            newArgs[1] = optionalPrepend;
        }
        System.arraycopy(previousArgs, 0, newArgs, hasOptionalPrepend ? 2 : 1, previousArgs.length);
        return Arguments.of((Object[])newArgs);
    }
}

