/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test.models;

import com.azure.core.test.implementation.TestingHelpers;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public class TestProxyRecordingOptions
implements JsonSerializable<TestProxyRecordingOptions> {
    private boolean autoRedirect = false;
    private ProxyTransport proxyTransportOptions;

    public boolean isAutoRedirect() {
        return this.autoRedirect;
    }

    public TestProxyRecordingOptions setAutoRedirect(boolean autoRedirect) {
        this.autoRedirect = autoRedirect;
        return this;
    }

    public ProxyTransport getTransportOptions() {
        return this.proxyTransportOptions;
    }

    public TestProxyRecordingOptions setTransportOptions(ProxyTransport proxyTransportOptions) {
        this.proxyTransportOptions = proxyTransportOptions;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return jsonWriter.writeStartObject().writeBooleanField("HandleRedirects", this.autoRedirect).writeJsonField("Transport", (JsonSerializable)this.proxyTransportOptions).writeEndObject();
    }

    public static TestProxyRecordingOptions fromJson(JsonReader jsonReader) throws IOException {
        return TestingHelpers.readObject(jsonReader, TestProxyRecordingOptions::new, (testProxyRecordingOptions, fieldName, reader) -> {
            if ("HandleRedirects".equals(fieldName)) {
                testProxyRecordingOptions.autoRedirect = reader.getBoolean();
            } else if ("Transport".equals(fieldName)) {
                testProxyRecordingOptions.proxyTransportOptions = ProxyTransport.fromJson(reader);
            } else {
                reader.skipChildren();
            }
        });
    }

    public static class ProxyTransport
    implements JsonSerializable<ProxyTransport> {
        private List<Certificate> certificates;
        private String tLSValidationCert;

        public List<Certificate> getCertificates() {
            return this.certificates;
        }

        public ProxyTransport setCertificates(List<Certificate> certificates) {
            this.certificates = certificates;
            return this;
        }

        public String gettLSValidationCert() {
            return this.tLSValidationCert;
        }

        public ProxyTransport settLSValidationCert(String tLSValidationCert) {
            this.tLSValidationCert = tLSValidationCert;
            return this;
        }

        public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
            return jsonWriter.writeStartObject().writeArrayField("Certificates", this.certificates, JsonWriter::writeJson).writeStringField("TLSValidationCert", this.tLSValidationCert).writeEndObject();
        }

        public static ProxyTransport fromJson(JsonReader jsonReader) throws IOException {
            return TestingHelpers.readObject(jsonReader, ProxyTransport::new, (proxyTransport, fieldName, reader) -> {
                if ("Certificates".equals(fieldName)) {
                    proxyTransport.certificates = reader.readArray(Certificate::fromJson);
                } else if ("TLSValidationCert".equals(fieldName)) {
                    proxyTransport.tLSValidationCert = reader.getString();
                } else {
                    reader.skipChildren();
                }
            });
        }
    }

    public static class Certificate
    implements JsonSerializable<Certificate> {
        private String pemValue;
        private String pemKey;

        public String getPemValue() {
            return this.pemValue;
        }

        public Certificate setPemValue(String pemValue) {
            this.pemValue = pemValue;
            return this;
        }

        public String getPemKey() {
            return this.pemKey;
        }

        public Certificate setPemKey(String pemKey) {
            this.pemKey = pemKey;
            return this;
        }

        public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
            return jsonWriter.writeStartObject().writeStringField("PemValue", this.pemValue).writeStringField("PemKey", this.pemKey).writeEndObject();
        }

        public static Certificate fromJson(JsonReader jsonReader) throws IOException {
            return TestingHelpers.readObject(jsonReader, Certificate::new, (certificate, fieldName, reader) -> {
                if ("PemValue".equals(fieldName)) {
                    certificate.pemValue = reader.getString();
                } else if ("PemKey".equals(fieldName)) {
                    certificate.pemKey = reader.getString();
                } else {
                    reader.skipChildren();
                }
            });
        }
    }
}

