/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.orm.adapter;

import com.frameworkset.common.poolman.PreparedDBUtil;
import com.frameworkset.orm.adapter.DB;
import com.frameworkset.orm.platform.PlatformSybaseImpl;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DBSybase
extends DB {
    public static final String DATE_FORMAT = "yyyyMMdd HH:mm:ss";

    protected DBSybase() {
        this.platform = new PlatformSybaseImpl();
    }

    @Override
    public String toUpperCase(String in) {
        return "UPPER(" + in + ")";
    }

    @Override
    public String ignoreCase(String in) {
        return "UPPER(" + in + ")";
    }

    @Override
    public String getIDMethodType() {
        return "autoincrement";
    }

    @Override
    public String getIDMethodSQL(Object unused) {
        return "select @@identity";
    }

    @Override
    public void lockTable(Connection con, String table) throws SQLException {
        Statement statement = con.createStatement();
        StringBuilder stmt = new StringBuilder();
        stmt.append("SELECT next_id FROM ").append(table).append(" FOR UPDATE");
        statement.executeQuery(stmt.toString());
    }

    @Override
    public void unlockTable(Connection con, String table) throws SQLException {
        con.commit();
    }

    @Override
    public boolean supportsNativeLimit() {
        return true;
    }

    @Override
    public int getLimitStyle() {
        return 3;
    }

    @Override
    public String getDateString(Date date) {
        char delim = this.getStringDelimiter();
        return delim + new SimpleDateFormat(DATE_FORMAT).format(date) + delim;
    }

    @Override
    public void setObject(PreparedDBUtil dbutil, int i, Object o) throws SQLException {
        if (o == null) {
            dbutil.setObject(i, o, 12);
        } else {
            super.setObject(dbutil, i, o);
        }
    }
}

