/*
 * Decompiled with CFR 0.152.
 */
package com.caspar.hoe;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.regex.Pattern;

public class NumberHoe {
    private static final String[] CN_UPPER_NUMBER = new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396"};
    private static final String[] CN_UPPER_MONETRAY_UNIT = new String[]{"\u5206", "\u89d2", "\u5143", "\u62fe", "\u4f70", "\u4edf", "\u4e07", "\u62fe", "\u4f70", "\u4edf", "\u4ebf", "\u62fe", "\u4f70", "\u4edf", "\u5146", "\u62fe", "\u4f70", "\u4edf"};
    private static final String CN_FULL = "\u6574";
    private static final String CN_NEGATIVE = "\u8d1f";
    private static final int MONEY_PRECISION = 2;
    private static final String CN_ZEOR_FULL = "\u96f6\u5143\u6574";

    public static boolean isPositiveInteger(String str) {
        return Pattern.compile("[1-9]\\d*").matcher(str).matches();
    }

    public static boolean isNonPositiveInteger(String str) {
        return Pattern.compile("-[1-9]\\d*|0*").matcher(str).matches();
    }

    public static boolean isNegativeInteger(String str) {
        return Pattern.compile("-[1-9]\\d*").matcher(str).matches();
    }

    public static boolean isNonNegativeInteger(String str) {
        return Pattern.compile("[1-9]\\d*|0").matcher(str).matches();
    }

    public static boolean isNumber(String str) {
        return Pattern.compile("(\\-|\\+)?\\d+(\\.\\d+)?").matcher(str).matches();
    }

    public static int gcd(int a, int b) {
        return a % b == 0 ? b : NumberHoe.gcd(b, a % b);
    }

    public static int gcd(int ... numbers) {
        int[] intArr = Arrays.copyOf(numbers, numbers.length);
        Arrays.sort(intArr);
        int tmpGcd = intArr[0];
        for (int i = 0; i < intArr.length - 1; ++i) {
            tmpGcd = NumberHoe.gcd(tmpGcd, intArr[i + 1]);
        }
        return tmpGcd;
    }

    public static int lcm(int a, int b) {
        return a * b / NumberHoe.gcd(a, b);
    }

    public static int lcm(int ... numbers) {
        int[] intArr = Arrays.copyOf(numbers, numbers.length);
        Arrays.sort(intArr);
        int product = 0;
        for (int i = 0; i < intArr.length - 1; ++i) {
            product = intArr[i] * intArr[i + 1];
        }
        return product / NumberHoe.gcd(numbers);
    }

    public static String toCNMontrayUnit(BigDecimal money) {
        StringBuffer sb = new StringBuffer();
        int signum = money.signum();
        if (signum == 0) {
            return CN_ZEOR_FULL;
        }
        long number = money.movePointRight(2).setScale(0, 4).abs().longValue();
        long scale = number % 100L;
        int numUnit = 0;
        int numIndex = 0;
        boolean getZero = false;
        if (scale <= 0L) {
            numIndex = 2;
            number /= 100L;
            getZero = true;
        }
        if (scale > 0L && scale % 10L <= 0L) {
            numIndex = 1;
            number /= 10L;
            getZero = true;
        }
        int zeroSize = 0;
        while (number > 0L) {
            numUnit = (int)(number % 10L);
            if (numUnit > 0) {
                if (numIndex == 9 && zeroSize >= 3) {
                    sb.insert(0, CN_UPPER_MONETRAY_UNIT[6]);
                }
                if (numIndex == 13 && zeroSize >= 3) {
                    sb.insert(0, CN_UPPER_MONETRAY_UNIT[10]);
                }
                sb.insert(0, CN_UPPER_MONETRAY_UNIT[numIndex]);
                sb.insert(0, CN_UPPER_NUMBER[numUnit]);
                getZero = false;
                zeroSize = 0;
            } else {
                ++zeroSize;
                if (!getZero) {
                    sb.insert(0, CN_UPPER_NUMBER[numUnit]);
                }
                if (numIndex == 2) {
                    if (number > 0L) {
                        sb.insert(0, CN_UPPER_MONETRAY_UNIT[numIndex]);
                    }
                } else if ((numIndex - 2) % 4 == 0 && number % 1000L > 0L) {
                    sb.insert(0, CN_UPPER_MONETRAY_UNIT[numIndex]);
                }
                getZero = true;
            }
            number /= 10L;
            ++numIndex;
        }
        if (signum == -1) {
            sb.insert(0, CN_NEGATIVE);
        }
        if (scale <= 0L) {
            sb.append(CN_FULL);
        }
        return sb.toString();
    }

    public static String toCNMontrayUnit(String numberStr) {
        return NumberHoe.toCNMontrayUnit(new BigDecimal(numberStr));
    }
}

