/*
 * Decompiled with CFR 0.152.
 */
package com.caspar.hoe;

import com.caspar.hoe.HtmlChar;
import com.caspar.hoe.HtmlCharCode;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;

public class StringHoe {
    public static final String EMPTY = "";
    public static final String SPACE = " ";

    public static String append(String ... appends) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < appends.length; ++i) {
            sb.append(appends[i]);
        }
        return sb.toString();
    }

    public static String appendPre(String str, String ... appends) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < appends.length; ++i) {
            sb.append(appends[i]);
        }
        return sb.append(str).toString();
    }

    public static String collapseWhitespace(String value) {
        return StringHoe.trim(value).replaceAll("\\s\\s+", SPACE);
    }

    public static int countMatches(CharSequence str, CharSequence sub) {
        if (StringHoe.isEmpty(str) || StringHoe.isEmpty(sub)) {
            return 0;
        }
        int count = 0;
        int idx = 0;
        while ((idx = str.toString().indexOf(sub.toString(), idx)) != -1) {
            ++count;
            idx += sub.length();
        }
        return count;
    }

    public static int countMatches(CharSequence str, char ch) {
        if (StringHoe.isEmpty(str)) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (ch != str.charAt(i)) continue;
            ++count;
        }
        return count;
    }

    public static String htmlDecodeHtmlCode(String encodedHtml) {
        return StringHoe.htmlDecode(encodedHtml, 0);
    }

    public static String htmlDecodeDecimalCode(String encodedHtml) {
        return StringHoe.htmlDecode(encodedHtml, 1);
    }

    public static String htmlEncodeByHtmlCode(String html) {
        return StringHoe.htmlEncode(html, 0);
    }

    public static String htmlEncodeByDecimalCode(String html) {
        return StringHoe.htmlEncode(html, 1);
    }

    public static boolean isEmpty(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0 || "null".equalsIgnoreCase(cs.toString())) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotEmpty(CharSequence cs) {
        return !StringHoe.isEmpty(cs);
    }

    public static String md5Bit32(String source) {
        return StringHoe.md5(source, 32);
    }

    public static String md5Bit16(String source) {
        return StringHoe.md5(source, 16);
    }

    public static String trim(String value) {
        return value == null ? null : value.trim();
    }

    public static String trimAll(String str) {
        return str.replaceAll("\\s*", EMPTY);
    }

    public static String trimLeft(String value) {
        return value.replaceAll("^\\s+", EMPTY);
    }

    public static String trimRight(String value) {
        return value.replaceAll("\\s+$", EMPTY);
    }

    public static String left(String str, int len) {
        if (str == null) {
            return null;
        }
        if (len < 0) {
            return EMPTY;
        }
        if (str.length() <= len) {
            return str;
        }
        return str.substring(0, len);
    }

    public static String right(String str, int len) {
        if (str == null) {
            return null;
        }
        if (len < 0) {
            return EMPTY;
        }
        if (str.length() <= len) {
            return str;
        }
        return str.substring(str.length() - len);
    }

    public static String mid(String str, int pos, int len) {
        if (str == null) {
            return null;
        }
        if (len < 0 || pos > str.length()) {
            return EMPTY;
        }
        if (pos < 0) {
            pos = 0;
        }
        if (str.length() <= pos + len) {
            return str.substring(pos);
        }
        return str.substring(pos, pos + len);
    }

    public static String join(Object[] array, String separator) {
        if (array == null) {
            return null;
        }
        return StringHoe.join(array, separator, 0, array.length);
    }

    public static String join(long[] array, String separator) {
        if (array == null) {
            return null;
        }
        return StringHoe.join(array, separator, 0, array.length);
    }

    public static String join(int[] array, String separator) {
        if (array == null) {
            return null;
        }
        return StringHoe.join(array, separator, 0, array.length);
    }

    public static String join(byte[] array, String separator) {
        if (array == null) {
            return null;
        }
        return StringHoe.join(array, separator, 0, array.length);
    }

    public static String join(short[] array, String separator) {
        if (array == null) {
            return null;
        }
        return StringHoe.join(array, separator, 0, array.length);
    }

    public static String join(double[] array, String separator) {
        if (array == null) {
            return null;
        }
        return StringHoe.join(array, separator, 0, array.length);
    }

    public static String join(float[] array, String separator) {
        if (array == null) {
            return null;
        }
        return StringHoe.join(array, separator, 0, array.length);
    }

    public static String join(Object[] array, String separator, int startIndex, int endIndex) {
        int noOfItems;
        if (array == null) {
            return null;
        }
        if (separator == null) {
            separator = EMPTY;
        }
        if ((noOfItems = endIndex - startIndex) <= 0) {
            return EMPTY;
        }
        StringBuilder buf = new StringBuilder(noOfItems * 16);
        for (int i = startIndex; i < endIndex; ++i) {
            if (i > startIndex) {
                buf.append(separator);
            }
            if (array[i] == null) continue;
            buf.append(array[i]);
        }
        return buf.toString();
    }

    public static String join(long[] array, String separator, int startIndex, int endIndex) {
        if (array == null) {
            return null;
        }
        Object[] arrayNew = new Long[array.length];
        for (int i = 0; i < array.length; ++i) {
            arrayNew[i] = array[i];
        }
        return StringHoe.join(arrayNew, separator, startIndex, endIndex);
    }

    public static String join(int[] array, String separator, int startIndex, int endIndex) {
        if (array == null) {
            return null;
        }
        Object[] arrayNew = new Integer[array.length];
        for (int i = 0; i < array.length; ++i) {
            arrayNew[i] = array[i];
        }
        return StringHoe.join(arrayNew, separator, startIndex, endIndex);
    }

    public static String join(short[] array, String separator, int startIndex, int endIndex) {
        if (array == null) {
            return null;
        }
        Object[] arrayNew = new Short[array.length];
        for (int i = 0; i < array.length; ++i) {
            arrayNew[i] = array[i];
        }
        return StringHoe.join(arrayNew, separator, startIndex, endIndex);
    }

    public static String join(byte[] array, String separator, int startIndex, int endIndex) {
        if (array == null) {
            return null;
        }
        Object[] arrayNew = new Byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            arrayNew[i] = array[i];
        }
        return StringHoe.join(arrayNew, separator, startIndex, endIndex);
    }

    public static String join(char[] array, String separator, int startIndex, int endIndex) {
        if (array == null) {
            return null;
        }
        Object[] arrayNew = new Character[array.length];
        for (int i = 0; i < array.length; ++i) {
            arrayNew[i] = Character.valueOf(array[i]);
        }
        return StringHoe.join(arrayNew, separator, startIndex, endIndex);
    }

    public static String join(double[] array, String separator, int startIndex, int endIndex) {
        if (array == null) {
            return null;
        }
        Object[] arrayNew = new Double[array.length];
        for (int i = 0; i < array.length; ++i) {
            arrayNew[i] = array[i];
        }
        return StringHoe.join(arrayNew, separator, startIndex, endIndex);
    }

    public static String join(float[] array, String separator, int startIndex, int endIndex) {
        if (array == null) {
            return null;
        }
        Object[] arrayNew = new Float[array.length];
        for (int i = 0; i < array.length; ++i) {
            arrayNew[i] = Float.valueOf(array[i]);
        }
        return StringHoe.join(arrayNew, separator, startIndex, endIndex);
    }

    public static String padLeft(String value, String pad, int length) {
        if (value.length() > length) {
            return value;
        }
        return StringHoe.append(StringHoe.repeat(pad, length - value.length()), value);
    }

    public static String padRight(String value, String pad, int length) {
        if (value.length() > length) {
            return value;
        }
        return StringHoe.append(value, StringHoe.repeat(pad, length - value.length()));
    }

    public static String toCamelCase(String value) {
        return StringHoe.lowerFirst(StringHoe.toStudlyCase(value));
    }

    public static String toStudlyCase(String value) {
        if (StringHoe.isEmpty(value)) {
            return null;
        }
        String[] words = StringHoe.collapseWhitespace(StringHoe.trim(value)).split("\\s*(_|-|\\s)\\s*");
        StringBuffer sb = new StringBuffer();
        for (String w : words) {
            sb.append(StringHoe.upperFirst(w));
        }
        return sb.toString();
    }

    public static String toDecamelize(String value, String separator) {
        if (separator == null) {
            separator = SPACE;
        }
        String camelCasedString = StringHoe.toCamelCase(value);
        String[] words = camelCasedString.split("(?=\\p{Upper})");
        StringBuffer sb = new StringBuffer();
        for (String w : words) {
            sb.append(StringHoe.lowerFirst(w)).append(separator);
        }
        return StringHoe.removeLast(sb.toString());
    }

    public static String toKebabCase(String value) {
        return StringHoe.toDecamelize(value, "-");
    }

    public static String toSnakeCase(String value) {
        return StringHoe.toDecamelize(value, "_");
    }

    public static String[] lines(String input) {
        if (input == null) {
            return new String[0];
        }
        return input.split("\r\n?|\n");
    }

    public static String reverse(String str) {
        if (str == null) {
            return null;
        }
        return new StringBuilder(str).reverse().toString();
    }

    public static String repeat(String value, int multiplier) {
        if (StringHoe.isEmpty(value)) {
            return null;
        }
        if (multiplier < 0) {
            throw new IllegalArgumentException(Long.toString(multiplier));
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < multiplier; ++i) {
            sb.append(value);
        }
        return sb.toString();
    }

    public static String repeat(String value, String separator, int multiplier) {
        if (StringHoe.isEmpty(value)) {
            return null;
        }
        if (multiplier < 0) {
            throw new IllegalArgumentException(Long.toString(multiplier));
        }
        if (separator == null) {
            separator = EMPTY;
        }
        Object[] strArr = new String[multiplier];
        for (int i = 0; i < multiplier; ++i) {
            strArr[i] = value;
        }
        return StringHoe.join(strArr, separator);
    }

    public static String removeFirst(String value) {
        return StringHoe.right(value, value.length() - 1);
    }

    public static String removeLast(String value) {
        return StringHoe.left(value, value.length() - 1);
    }

    public static String removeNonWords(String value) {
        return value.replaceAll("[^\\w]+", EMPTY);
    }

    public static String upperFirst(String value) {
        if (StringHoe.isEmpty(value)) {
            return null;
        }
        return StringHoe.left(value, 1).toUpperCase() + StringHoe.right(value, value.length() - 1);
    }

    public static String lowerFirst(String value) {
        if (StringHoe.isEmpty(value)) {
            return null;
        }
        return StringHoe.left(value, 1).toLowerCase() + StringHoe.right(value, value.length() - 1);
    }

    private static String md5(String source, int bit) {
        if (source == null || source == EMPTY) {
            return null;
        }
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(source.getBytes(Charset.defaultCharset()));
            byte[] tmp = md.digest();
            char[] chstr = new char[tmp.length * 2];
            int k = 0;
            for (int i = 0; i < tmp.length; ++i) {
                byte byte0 = tmp[i];
                chstr[k++] = hexDigits[byte0 >>> 4 & 0xF];
                chstr[k++] = hexDigits[byte0 & 0xF];
            }
            source = new String(chstr);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        if (bit == 16) {
            return source.substring(8, 24);
        }
        return source;
    }

    private static String htmlDecode(String encodedHtml, int encodedType) {
        String str = StringHoe.collapseWhitespace(encodedHtml);
        block4: for (Map.Entry<String, HtmlChar> entry : HtmlCharCode.decodedEntities.entrySet()) {
            switch (encodedType) {
                case 0: {
                    str = str.replaceAll(entry.getKey(), entry.getValue().getName());
                    continue block4;
                }
                case 1: {
                    str = str.replaceAll(entry.getKey(), entry.getValue().getDecimalCode());
                    continue block4;
                }
            }
            str = str.replaceAll(entry.getKey(), entry.getValue().getDecimalCode());
        }
        return str;
    }

    private static String htmlEncode(String html, int encodedType) {
        String str = StringHoe.collapseWhitespace(html);
        block4: for (Map.Entry<String, HtmlChar> entry : HtmlCharCode.decodedEntities.entrySet()) {
            switch (encodedType) {
                case 0: {
                    str = str.replaceAll(entry.getValue().getName(), entry.getKey());
                    continue block4;
                }
                case 1: {
                    str = str.replaceAll(entry.getValue().getDecimalCode(), entry.getKey());
                    continue block4;
                }
            }
            str = str.replaceAll(entry.getValue().getDecimalCode(), entry.getKey());
        }
        return str;
    }
}

