/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.sortedsets;

import com.github.fppt.jedismock.datastructures.RMZSet;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.exception.ArgumentException;
import com.github.fppt.jedismock.operations.AbstractRedisOperation;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.RedisBase;
import java.util.ArrayList;
import java.util.List;

@RedisCommand(value="zmscore")
class ZMScore
extends AbstractRedisOperation {
    ZMScore(RedisBase base, List<Slice> params) {
        super(base, params);
    }

    @Override
    protected Slice response() {
        if (this.params().size() < 2) {
            throw new ArgumentException("*ERR*wrong*number*arg*");
        }
        Slice key = this.params().get(0);
        RMZSet mapDBObj = this.getZSetFromBaseOrCreateEmpty(key);
        ArrayList<Slice> result = new ArrayList<Slice>();
        for (int i = 1; i < this.params().size(); ++i) {
            Double score = mapDBObj.getScore(this.params().get(i));
            result.add(score == null ? Response.NULL : Response.bulkString(Slice.create(String.valueOf(Math.round(score)))));
        }
        return Response.array(result);
    }
}

