/*
 * Decompiled with CFR 0.152.
 */
package com.github.microwww.redis.database;

import com.github.microwww.redis.util.Assert;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;

public abstract class AbstractValueData<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final AtomicLong version = new AtomicLong(0L);
    public static final int NEVER_EXPIRE = -1;
    long expire = -1L;
    T data;

    public long getExpire() {
        return this.expire;
    }

    public void setExpire(long expire) {
        this.expire = expire;
        this.version.getAndIncrement();
    }

    public void setSecondsExpire(int expire) {
        if (expire <= 0) {
            expire = 0;
        }
        this.expire = System.currentTimeMillis() + (long)(expire * 1000);
    }

    public T getData() {
        return this.data;
    }

    protected void setData(T data) {
        Assert.isNotNull(data, "Not null");
        this.version.getAndIncrement();
        this.data = data;
    }

    public String getType() {
        return "string";
    }

    public boolean isExpired() {
        if (this.expire < 0L) {
            return false;
        }
        return this.expire <= System.currentTimeMillis();
    }

    public AtomicLong getVersion() {
        return this.version;
    }
}

