/*
 * Decompiled with CFR 0.152.
 */
package com.github.microwww.redis.database;

import com.github.microwww.redis.database.AbstractValueData;
import com.github.microwww.redis.database.Bytes;
import com.github.microwww.redis.database.DataLock;
import com.github.microwww.redis.database.HashKey;
import com.github.microwww.redis.database.RedisDatabase;
import com.github.microwww.redis.logger.LogFactory;
import com.github.microwww.redis.logger.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Optional;
import java.util.stream.Collectors;

public class ListData
extends AbstractValueData<List<Bytes>>
implements DataLock {
    private static final Logger log = LogFactory.getLogger(ListData.class);
    private final ChangeObservable addEvent = new ChangeObservable();
    private final List<Bytes> origin;

    public ListData() {
        this(-1);
    }

    public ListData(int exp) {
        this(new ArrayList<Bytes>(), exp);
    }

    public ListData(List<Bytes> origin, int exp) {
        this.origin = origin;
        this.data = Collections.unmodifiableList(origin);
        this.expire = exp;
    }

    @Override
    public String getType() {
        return "list";
    }

    public void subscribe(Observer sub) {
        this.addEvent.subscribe(sub);
    }

    public void unsubscribe(Observer sub) {
        this.addEvent.deleteObserver(sub);
    }

    public synchronized Optional<Bytes> getByIndex(int index) {
        int max = this.origin.size();
        if ((index = this.index(index)) >= max) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.origin.get(index));
    }

    public synchronized boolean findAndOffsetInsert(byte[] pivot, int offset, byte[] value) {
        int index = this.indexOf(pivot);
        if (index >= 0) {
            this.origin.add(index + offset, new Bytes(value));
            this.version.incrementAndGet();
            this.addEvent.publish(this);
            return true;
        }
        return false;
    }

    public synchronized int indexOf(byte[] val) {
        int index = -1;
        for (int i = 0; i < this.origin.size(); ++i) {
            Bytes bytes = this.origin.get(i);
            if (!Bytes.eq(bytes, val)) continue;
            index = i;
            break;
        }
        return index;
    }

    public synchronized Bytes remove(int index) {
        Bytes remove = this.origin.remove(index);
        this.version.incrementAndGet();
        return remove;
    }

    public synchronized Optional<Bytes> leftPop() {
        Bytes rm = null;
        if (!this.origin.isEmpty()) {
            rm = this.remove(0);
        }
        return Optional.ofNullable(rm);
    }

    public synchronized void leftAdd(byte[] ... bytes) {
        for (byte[] a : bytes) {
            this.origin.add(0, new Bytes(a));
        }
        if (bytes.length > 0) {
            this.version.incrementAndGet();
        }
        this.addEvent.publish(this);
    }

    public synchronized byte[][] range(int from, int includeTo) {
        int max = this.origin.size();
        from = this.index(from);
        int to = this.index(includeTo) + 1;
        if (from >= max) {
            return new byte[0][];
        }
        int end = Math.min(max, to);
        byte[][] byt = new byte[end - from][];
        for (int i = 0; i < byt.length; ++i) {
            byt[i] = this.origin.get(from + i).getBytes();
        }
        return byt;
    }

    private synchronized int index(int index) {
        if (index < 0) {
            return this.origin.size() + index;
        }
        return index;
    }

    public synchronized int remove(int count, byte[] val) {
        int ct = 0;
        if (count > 0) {
            int size = this.origin.size();
            for (int i = 0; i < size; ++i) {
                if (!Bytes.eq(this.origin.get(i), val)) continue;
                this.origin.remove(i);
                if (--count > 0) {
                    --i;
                    --size;
                    ++ct;
                    continue;
                }
                break;
            }
        } else {
            count = Math.abs(count);
            int size = this.origin.size();
            if (count == 0) {
                count = size;
            }
            for (int i = size - 1; i >= 0; --i) {
                if (!Bytes.eq(this.origin.get(i), val)) continue;
                this.origin.remove(i);
                ++ct;
                if (--count > 0) {
                    continue;
                }
                break;
            }
        }
        if (ct > 0) {
            this.version.incrementAndGet();
        }
        return ct;
    }

    public synchronized Bytes set(int index, byte[] element) {
        Bytes set = this.origin.set(index, new Bytes(element));
        this.version.incrementAndGet();
        return set;
    }

    public synchronized void trim(int start, int includeStop) {
        int from = this.index(start);
        int to = this.index(includeStop);
        int max = this.origin.size();
        if (from >= max || from > to) {
            this.origin.clear();
            this.version.incrementAndGet();
            return;
        }
        for (int i = this.origin.size() - 1; i >= 0; --i) {
            if (i < from) {
                this.remove(i);
            }
            if (i <= to) continue;
            this.remove(i);
        }
    }

    public synchronized Optional<Bytes> rightPop() {
        Bytes or = null;
        if (!this.origin.isEmpty()) {
            or = this.remove(this.origin.size() - 1);
        }
        return Optional.ofNullable(or);
    }

    public synchronized Optional<Bytes> pop2push(RedisDatabase db, HashKey target) {
        return this.rightPop().map(e -> {
            ListData dest = db.getOrCreate(target, ListData::new);
            return dest.sync(() -> {
                dest.leftAdd(new byte[][]{e.getBytes()});
                return e;
            });
        });
    }

    public synchronized void rightAdd(byte[] ... bytes) {
        this.origin.addAll(Arrays.stream(bytes).map(Bytes::new).collect(Collectors.toList()));
        this.version.incrementAndGet();
        this.addEvent.publish(this);
    }

    public static class ChangeObservable
    extends Observable {
        public void publish(ListData list) {
            this.setChanged();
            this.notifyObservers(list);
        }

        public void subscribe(Observer o) {
            this.addObserver(o);
        }
    }
}

