/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.alloydb;

import com.google.cloud.alloydb.AsyncRateLimiter;
import com.google.cloud.alloydb.ConnectionInfo;
import com.google.cloud.alloydb.RefreshCalculator;
import com.google.cloud.alloydb.TerminalException;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Refresher {
    private static final Logger logger = LoggerFactory.getLogger(Refresher.class);
    private static final long DEFAULT_CONNECT_TIMEOUT_MS = 45000L;
    private final ListeningScheduledExecutorService executor;
    private final Object connectionInfoGuard = new Object();
    private final AsyncRateLimiter rateLimiter;
    private final RefreshCalculator refreshCalculator;
    private final Supplier<ListenableFuture<ConnectionInfo>> refreshOperation;
    private final String name;
    @GuardedBy(value="connectionInfoGuard")
    private ListenableFuture<ConnectionInfo> current;
    @GuardedBy(value="connectionInfoGuard")
    private ListenableFuture<ConnectionInfo> next;
    @GuardedBy(value="connectionInfoGuard")
    private boolean refreshRunning;
    @GuardedBy(value="connectionInfoGuard")
    private Throwable currentRefreshFailure;
    @GuardedBy(value="connectionInfoGuard")
    private boolean closed;
    @GuardedBy(value="connectionInfoGuard")
    private boolean triggerNextRefresh = true;

    Refresher(String name, ListeningScheduledExecutorService executor, Supplier<ListenableFuture<ConnectionInfo>> refreshOperation, AsyncRateLimiter rateLimiter) {
        this(name, executor, new RefreshCalculator(), refreshOperation, rateLimiter, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Refresher(String name, ListeningScheduledExecutorService executor, RefreshCalculator refreshCalculator, Supplier<ListenableFuture<ConnectionInfo>> refreshOperation, AsyncRateLimiter rateLimiter, boolean triggerNextRefresh) {
        this.name = name;
        this.executor = executor;
        this.refreshCalculator = refreshCalculator;
        this.refreshOperation = refreshOperation;
        this.rateLimiter = rateLimiter;
        this.triggerNextRefresh = triggerNextRefresh;
        Object object = this.connectionInfoGuard;
        synchronized (object) {
            this.forceRefresh();
            this.current = this.next;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConnectionInfo getConnectionInfo(long timeoutMs) {
        ListenableFuture<ConnectionInfo> f;
        Object object = this.connectionInfoGuard;
        synchronized (object) {
            if (this.closed) {
                throw new IllegalStateException("Connection closed");
            }
            f = this.current;
        }
        try {
            return (ConnectionInfo)f.get(timeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            Object object2 = this.connectionInfoGuard;
            synchronized (object2) {
                if (this.currentRefreshFailure != null) {
                    throw new RuntimeException(String.format("Unable to get valid instance data within %d ms. Last refresh attempt failed:", timeoutMs) + this.currentRefreshFailure.getMessage(), this.currentRefreshFailure);
                }
            }
            throw new RuntimeException(String.format("Unable to get valid instance data within %d ms. No refresh has completed.", timeoutMs), e);
        }
        catch (InterruptedException | ExecutionException ex) {
            Throwable cause = ex.getCause();
            Throwables.throwIfUnchecked((Throwable)cause);
            throw new RuntimeException(cause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forceRefresh() {
        Object object = this.connectionInfoGuard;
        synchronized (object) {
            if (this.closed) {
                throw new IllegalStateException("Connection closed");
            }
            if (this.refreshRunning) {
                return;
            }
            if (this.next != null) {
                this.next.cancel(false);
            }
            logger.debug(String.format("[%s] Force Refresh: the next refresh operation was cancelled. Scheduling new refresh operation immediately.", this.name));
            this.next = this.startRefreshAttempt();
        }
    }

    void refreshIfExpired() {
        ConnectionInfo info = this.getConnectionInfo(45000L);
        logger.debug(String.format("[%s] Now = %s, Current client certificate expiration = %s", this.name, Instant.now().toString(), info.getExpiration()));
        if (Instant.now().isAfter(info.getExpiration())) {
            logger.debug(String.format("[%s] Client certificate has expired. Starting next refresh operation immediately.", this.name));
            this.forceRefresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ListenableFuture<ConnectionInfo> startRefreshAttempt() {
        Object object = this.connectionInfoGuard;
        synchronized (object) {
            this.refreshRunning = true;
        }
        logger.debug(String.format("[%s] Refresh Operation: Acquiring rate limiter permit.", this.name));
        ListenableFuture<?> delay = this.rateLimiter.acquireAsync((ScheduledExecutorService)this.executor);
        delay.addListener(() -> logger.debug(String.format("[%s] Refresh Operation: Rate limiter permit acquired.", this.name)), (Executor)this.executor);
        ListenableFuture f = Futures.whenAllComplete((ListenableFuture[])new ListenableFuture[]{delay}).callAsync(this.refreshOperation::get, (Executor)this.executor);
        return Futures.whenAllComplete((ListenableFuture[])new ListenableFuture[]{f}).callAsync(() -> this.handleRefreshResult((ListenableFuture<ConnectionInfo>)f), (Executor)this.executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ListenableFuture<ConnectionInfo> handleRefreshResult(ListenableFuture<ConnectionInfo> connectionInfoFuture) {
        try {
            ConnectionInfo info = (ConnectionInfo)connectionInfoFuture.get();
            logger.debug(String.format("[%s] Refresh Operation: Completed refresh with new certificate expiration at %s.", this.name, info.getExpiration().toString()));
            long secondsToRefresh = this.refreshCalculator.calculateSecondsUntilNextRefresh(Instant.now(), info.getExpiration());
            Object object = this.connectionInfoGuard;
            synchronized (object) {
                this.refreshRunning = false;
                this.currentRefreshFailure = null;
                this.current = Futures.immediateFuture((Object)info);
                if (!this.closed && this.triggerNextRefresh) {
                    logger.debug(String.format("[%s] Refresh Operation: Next operation scheduled at %s.", this.name, Instant.now().plus(secondsToRefresh, ChronoUnit.SECONDS).truncatedTo(ChronoUnit.SECONDS).toString()));
                    this.next = Futures.scheduleAsync(this::startRefreshAttempt, (long)secondsToRefresh, (TimeUnit)TimeUnit.SECONDS, (ScheduledExecutorService)this.executor);
                }
                return this.current;
            }
        }
        catch (InterruptedException | ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof TerminalException) {
                logger.debug(String.format("[%s] Refresh Operation: Failed! No retry.", this.name), (Throwable)e);
                throw (TerminalException)cause;
            }
            logger.debug(String.format("[%s] Refresh Operation: Failed! Starting next refresh operation immediately.", this.name), (Throwable)e);
            Object object = this.connectionInfoGuard;
            synchronized (object) {
                this.currentRefreshFailure = e;
                if (!this.closed) {
                    this.next = this.startRefreshAttempt();
                }
                return this.next;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        Object object = this.connectionInfoGuard;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            if (!this.current.isDone()) {
                this.current.cancel(true);
            }
            if (!this.next.isDone()) {
                this.next.cancel(true);
            }
            this.current = Futures.immediateFailedFuture((Throwable)new RuntimeException("Connection is closed."));
            this.closed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ListenableFuture<ConnectionInfo> getNext() {
        Object object = this.connectionInfoGuard;
        synchronized (object) {
            return this.next;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ListenableFuture<ConnectionInfo> getCurrent() {
        Object object = this.connectionInfoGuard;
        synchronized (object) {
            return this.current;
        }
    }
}

