/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.chat.model;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public record ExtractionTags(String think, String response) {
    public ExtractionTags(String think, String response) {
        this.think = ExtractionTags.stripBrackets(Objects.requireNonNull(think));
        this.response = ExtractionTags.stripBrackets(response);
    }

    public ExtractionTags(String think) {
        this(think, null);
    }

    public static ExtractionTags of(String think, String response) {
        return new ExtractionTags(think, response);
    }

    public static ExtractionTags of(String think) {
        return new ExtractionTags(think);
    }

    public String extractResponse(String content) {
        if (Objects.isNull(this.response)) {
            return content.replaceAll("<" + this.think + ">.*?</" + this.think + ">", "").trim();
        }
        String regex = "(?<=</" + this.think + ">)\\s*<" + this.response + ">(.*)</" + this.response + ">";
        Pattern pattern = Pattern.compile(regex, 32);
        Matcher matcher = pattern.matcher(content);
        return matcher.find() ? matcher.group(1).trim() : null;
    }

    public String extractThinking(String content) {
        Pattern pattern;
        Matcher matcher;
        String regex = "<" + this.think + ">(.*?)</" + this.think + ">";
        if (Objects.nonNull(this.response)) {
            regex = regex + ".*<" + this.response + ">";
        }
        return (matcher = (pattern = Pattern.compile(regex, 32)).matcher(content)).find() ? matcher.group(1).trim() : null;
    }

    private static String stripBrackets(String tag) {
        if (Objects.isNull(tag)) {
            return null;
        }
        if (tag.startsWith("<")) {
            tag = tag.substring(1);
        }
        if (tag.endsWith(">")) {
            tag = tag.substring(0, tag.length() - 1);
        }
        return tag;
    }
}

