/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.timeseries;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.IntStream;

public final class ForecastData {
    private final Map<String, List<Object>> data;

    protected ForecastData(Map<String, List<Object>> data) {
        this.data = Objects.requireNonNullElse(data, new LinkedHashMap());
    }

    public ForecastData add(String key, Object value) {
        this.data.computeIfAbsent(key, k -> new ArrayList()).add(value);
        return this;
    }

    public ForecastData add(String key, Object value, int times) {
        List list = this.data.computeIfAbsent(key, k -> new ArrayList());
        IntStream.range(0, times).forEach(i -> list.add(value));
        return this;
    }

    public ForecastData addAll(String key, Collection<?> values) {
        this.data.computeIfAbsent(key, k -> new ArrayList()).addAll(values);
        return this;
    }

    public ForecastData addAll(String key, Object ... values) {
        return this.addAll(key, new ArrayList<Object>(List.of(values)));
    }

    public boolean containsKey(String key) {
        return this.data.containsKey(key);
    }

    public List<Object> get(String key) {
        return this.data.get(key);
    }

    public Map<String, List<Object>> asMap() {
        return this.data;
    }

    public static ForecastData create() {
        return new ForecastData(null);
    }

    public static ForecastData from(Map<String, List<Object>> data) {
        return new ForecastData(data);
    }

    public String toString() {
        return "ForecastData [data=" + String.valueOf(this.data) + "]";
    }
}

