/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.tokenization;

import com.ibm.watsonx.ai.WatsonxService;
import com.ibm.watsonx.ai.core.Json;
import com.ibm.watsonx.ai.tokenization.TokenizationParameters;
import com.ibm.watsonx.ai.tokenization.TokenizationRequest;
import com.ibm.watsonx.ai.tokenization.TokenizationResponse;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public final class TokenizationService
extends WatsonxService.ModelService {
    protected TokenizationService(Builder builder) {
        super(builder);
        Objects.requireNonNull(builder.getAuthenticationProvider(), "authenticationProvider cannot be null");
    }

    public TokenizationResponse tokenize(String input) {
        return this.tokenize(input, null);
    }

    public CompletableFuture<TokenizationResponse> asyncTokenize(String input) {
        return this.asyncTokenize(input, null);
    }

    public TokenizationResponse tokenize(String input, TokenizationParameters parameters) {
        try {
            HttpRequest httpRequest = this.buildHttpRequest(input, parameters);
            HttpResponse httpReponse = this.syncHttpClient.send(httpRequest, HttpResponse.BodyHandlers.ofString());
            return (TokenizationResponse)Json.fromJson((String)((String)httpReponse.body()), TokenizationResponse.class);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public CompletableFuture<TokenizationResponse> asyncTokenize(String input, TokenizationParameters parameters) {
        HttpRequest httpRequest = this.buildHttpRequest(input, parameters);
        return ((CompletableFuture)this.asyncHttpClient.send(httpRequest, HttpResponse.BodyHandlers.ofString()).thenApplyAsync(r -> (TokenizationResponse)Json.fromJson((String)((String)r.body()), TokenizationResponse.class), this.computationExecutor)).thenApplyAsync(r -> r, this.asyncHttpClient.executor());
    }

    private HttpRequest buildHttpRequest(String input, TokenizationParameters parameters) {
        Objects.requireNonNull(input, "Input cannot be null");
        String modelId = this.modelId;
        String projectId = this.projectId;
        String spaceId = this.spaceId;
        String transactionId = null;
        TokenizationRequest.Parameters requestParameters = null;
        if (Objects.nonNull(parameters)) {
            modelId = Objects.requireNonNullElse(parameters.getModelId(), this.modelId);
            projectId = Optional.ofNullable(parameters.getProjectId()).orElse(this.projectId);
            spaceId = Optional.ofNullable(parameters.getSpaceId()).orElse(this.spaceId);
            transactionId = parameters.getTransactionId();
            requestParameters = parameters.toTokenizationRequestParameters();
        }
        TokenizationRequest tokenizationRequest = new TokenizationRequest(modelId, input, projectId, spaceId, requestParameters);
        HttpRequest.Builder httpRequest = HttpRequest.newBuilder(URI.create(this.url.toString() + "%s/tokenization?version=%s".formatted(ML_API_TEXT_PATH, this.version))).header("Content-Type", "application/json").header("Accept", "application/json").POST(HttpRequest.BodyPublishers.ofString(Json.toJson((Object)tokenizationRequest))).timeout(this.timeout);
        if (Objects.nonNull(transactionId)) {
            httpRequest.header("X-Global-Transaction-Id", transactionId);
        }
        return httpRequest.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends WatsonxService.ModelService.Builder<Builder> {
        private Builder() {
        }

        public TokenizationService build() {
            return new TokenizationService(this);
        }
    }
}

