/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocSaveOptions;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.HtmlFixedSaveOptions;
import com.aspose.words.HtmlSaveOptions;
import com.aspose.words.IDocumentSavingCallback;
import com.aspose.words.ImageSaveOptions;
import com.aspose.words.MarkdownSaveOptions;
import com.aspose.words.OdtSaveOptions;
import com.aspose.words.OoxmlSaveOptions;
import com.aspose.words.PclSaveOptions;
import com.aspose.words.PdfSaveOptions;
import com.aspose.words.PsSaveOptions;
import com.aspose.words.RtfSaveOptions;
import com.aspose.words.SvgSaveOptions;
import com.aspose.words.TxtSaveOptions;
import com.aspose.words.WordML2003SaveOptions;
import com.aspose.words.XamlFixedSaveOptions;
import com.aspose.words.XamlFlowSaveOptions;
import com.aspose.words.XpsSaveOptions;
import com.aspose.words.internal.zzZpx;
import com.aspose.words.internal.zzpG;

public abstract class SaveOptions {
    private boolean zzVVf;
    boolean zzZyw = false;
    boolean zzXGk = true;
    private IDocumentSavingCallback zzx7;
    private boolean zzX8V = true;
    private boolean zzWe2 = false;
    private boolean zzZb0;
    private boolean zzwp = true;
    private boolean zzuk;
    private String zzVPI;
    private boolean zzYmF;
    private boolean zzX9B = false;
    private int zzZyn = 1;
    private int zzW8O = 1;
    private int zzBd = 0;
    private String zzXFi = "";
    private boolean zzXVY = true;
    private boolean zzXh2 = true;
    private boolean zzWqb;
    private boolean zzQw;
    private int zzNr = 0;
    private boolean zzVYU = true;
    private boolean zzWKN = false;

    protected SaveOptions() {
    }

    final boolean zzZ5T() {
        return this.zzZb0;
    }

    public abstract int getSaveFormat();

    public abstract void setSaveFormat(int var1);

    boolean zzYUo() {
        return false;
    }

    boolean zzYrN() {
        return true;
    }

    public boolean getExportGeneratorName() {
        return this.zzwp;
    }

    public void setExportGeneratorName(boolean value) {
        this.zzwp = value;
    }

    public String getTempFolder() {
        return this.zzVPI;
    }

    public void setTempFolder(String value) {
        this.zzVPI = value;
    }

    public boolean getPrettyFormat() {
        return this.zzuk;
    }

    public void setPrettyFormat(boolean value) {
        this.zzuk = value;
    }

    public boolean getUseAntiAliasing() {
        return this.zzYmF;
    }

    public void setUseAntiAliasing(boolean value) {
        this.zzYmF = value;
    }

    public boolean getUseHighQualityRendering() {
        return this.zzX9B;
    }

    public void setUseHighQualityRendering(boolean value) {
        this.zzX9B = value;
    }

    @Deprecated
    public boolean getUpdateSdtContent() {
        return this.zzZyw;
    }

    @Deprecated
    public void setUpdateSdtContent(boolean value) {
        this.zzZyw = value;
    }

    public int getDmlRenderingMode() {
        return this.zzZyn;
    }

    public void setDmlRenderingMode(int value) {
        this.zzZyn = value;
    }

    public int getDmlEffectsRenderingMode() {
        return this.zzBd;
    }

    public void setDmlEffectsRenderingMode(int value) {
        this.zzBd = value;
    }

    public int getImlRenderingMode() {
        return this.zzW8O;
    }

    public void setImlRenderingMode(int value) {
        this.zzW8O = value;
    }

    public String getDefaultTemplate() {
        return this.zzXFi;
    }

    public void setDefaultTemplate(String value) {
        this.zzXFi = value;
    }

    public boolean getUpdateFields() {
        return this.zzXVY;
    }

    public void setUpdateFields(boolean value) {
        this.zzXVY = value;
    }

    public boolean getUpdateLastSavedTimeProperty() {
        return this.zzWqb;
    }

    public void setUpdateLastSavedTimeProperty(boolean value) {
        this.zzWqb = value;
    }

    public boolean getUpdateLastPrintedProperty() {
        return this.zzQw;
    }

    public void setUpdateLastPrintedProperty(boolean value) {
        this.zzQw = value;
    }

    public boolean getUpdateCreatedTimeProperty() {
        return this.zzWKN;
    }

    public void setUpdateCreatedTimeProperty(boolean value) {
        this.zzWKN = value;
    }

    public boolean getMemoryOptimization() {
        return this.zzWe2;
    }

    public void setMemoryOptimization(boolean value) {
        this.zzWe2 = value;
    }

    final boolean zzXTu() {
        return this.zzXh2;
    }

    final boolean zzWYM() {
        return this.zzVYU;
    }

    public static SaveOptions createSaveOptions(int saveFormat) {
        switch (saveFormat) {
            case 10: 
            case 11: {
                return new DocSaveOptions(saveFormat);
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return new OoxmlSaveOptions(saveFormat);
            }
            case 30: {
                return new RtfSaveOptions();
            }
            case 31: {
                return new WordML2003SaveOptions();
            }
            case 40: {
                return new PdfSaveOptions();
            }
            case 47: {
                return new PsSaveOptions();
            }
            case 48: {
                return new PclSaveOptions();
            }
            case 41: {
                return new XpsSaveOptions(41);
            }
            case 46: {
                return new XpsSaveOptions(46);
            }
            case 42: {
                return new XamlFixedSaveOptions();
            }
            case 44: {
                return new SvgSaveOptions();
            }
            case 45: {
                return new HtmlFixedSaveOptions();
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                return new HtmlSaveOptions(saveFormat);
            }
            case 60: 
            case 61: {
                return new OdtSaveOptions(saveFormat);
            }
            case 70: {
                return new TxtSaveOptions();
            }
            case 71: {
                return new XamlFlowSaveOptions();
            }
            case 72: {
                return new XamlFlowSaveOptions(saveFormat);
            }
            case 73: {
                return new MarkdownSaveOptions();
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                return new ImageSaveOptions(saveFormat);
            }
        }
        throw new IllegalArgumentException("Invalid save format requested.");
    }

    public static SaveOptions createSaveOptions(String fileName) throws Exception {
        return SaveOptions.createSaveOptions(FileFormatUtil.zzZxi(zzpG.zzY56(zzZpx.zzoY(fileName))));
    }

    public int getDml3DEffectsRenderingMode() {
        return this.zzNr;
    }

    public void setDml3DEffectsRenderingMode(int value) {
        this.zzNr = value;
    }

    public IDocumentSavingCallback getProgressCallback() {
        return this.zzx7;
    }

    public void setProgressCallback(IDocumentSavingCallback value) {
        this.zzx7 = value;
    }

    public boolean getAllowEmbeddingPostScriptFonts() {
        return this.zzVVf;
    }

    public void setAllowEmbeddingPostScriptFonts(boolean value) {
        this.zzVVf = value;
    }

    final boolean zzW0l() {
        return this.zzX8V;
    }
}

