/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.internal;

import com.aspose.words.internal.zz7b;
import com.aspose.words.internal.zzVPQ;
import com.aspose.words.internal.zzW4t;
import com.aspose.words.internal.zzWvK;
import com.aspose.words.internal.zzXO0;
import com.aspose.words.internal.zzXQt;
import com.aspose.words.internal.zzYlb;
import com.aspose.words.internal.zzZ5z;
import com.aspose.words.internal.zzZp1;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathBuilderSpi;
import java.security.cert.CertPathParameters;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

final class zzWuj
extends CertPathBuilderSpi {
    private final zzW4t zzW5r;
    private zzVPQ zzX68;

    zzWuj(zzW4t zzW4t2) {
        this.zzW5r = zzW4t2;
    }

    @Override
    public final CertPathBuilderResult engineBuild(CertPathParameters params) throws CertPathBuilderException, InvalidAlgorithmParameterException {
        Collection collection;
        zzYlb pkixParams;
        if (params instanceof zzYlb) {
            pkixParams = (zzYlb)params;
        } else if (params instanceof PKIXBuilderParameters) {
            pkixParams = new zzYlb.zzXDP((PKIXBuilderParameters)params).zzYhD();
        } else {
            throw new InvalidAlgorithmParameterException("Parameters must be an instance of " + PKIXBuilderParameters.class.getName() + " or " + zzYlb.class.getName() + ".");
        }
        ArrayList arrayList = new ArrayList();
        zzXQt zzXQt2 = pkixParams.zzYAb().zzYhM();
        try {
            collection = zzXO0.zzXDP(zzXQt2, pkixParams.zzYAb().zzZoB());
            collection.addAll(zzXO0.zzXDP(zzXQt2, pkixParams.zzYAb().zzWP9()));
        }
        catch (zzVPQ zzVPQ2) {
            throw new CertPathBuilderException("Error finding target certificate.", zzVPQ2);
        }
        if (collection.isEmpty()) {
            throw new CertPathBuilderException("No certificate found matching targetContraints.");
        }
        CertPathBuilderResult certPathBuilderResult = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext() && certPathBuilderResult == null) {
            X509Certificate x509Certificate = (X509Certificate)iterator.next();
            certPathBuilderResult = this.zzXDP(x509Certificate, pkixParams, arrayList);
        }
        if (certPathBuilderResult == null && this.zzX68 != null) {
            throw new CertPathBuilderException(this.zzX68.getMessage(), this.zzX68.getCause());
        }
        if (certPathBuilderResult == null) {
            throw new CertPathBuilderException("Unable to find certificate chain.");
        }
        return certPathBuilderResult;
    }

    private CertPathBuilderResult zzXDP(X509Certificate x509Certificate, zzYlb zzYlb2, List list) throws CertPathBuilderException {
        zzWvK zzWvK2;
        zzZ5z zzZ5z2;
        if (list.contains(x509Certificate)) {
            return null;
        }
        if (zzYlb2.zzZz8().contains(x509Certificate)) {
            return null;
        }
        if (zzYlb2.zzYtr() != -1 && list.size() - 1 > zzYlb2.zzYtr()) {
            return null;
        }
        list.add(x509Certificate);
        CertPathBuilderResult certPathBuilderResult = null;
        try {
            zzZ5z2 = new zzZ5z(this.zzW5r);
            zzWvK2 = new zzWvK(this.zzW5r);
        }
        catch (Exception exception) {
            throw new CertPathBuilderException("Exception creating support classes: " + exception.getMessage(), exception);
        }
        try {
            if (zzXO0.zzXDP(x509Certificate, zzYlb2.zzYAb().zzWpM(), zzYlb2.zzYAb().zzWqY()) != null) {
                PKIXCertPathValidatorResult pKIXCertPathValidatorResult;
                CertPath certPath;
                try {
                    certPath = zzZ5z2.engineGenerateCertPath(list);
                }
                catch (Exception exception) {
                    throw new zzVPQ("Certification path could not be constructed from certificate list.", exception);
                }
                try {
                    pKIXCertPathValidatorResult = (PKIXCertPathValidatorResult)zzWvK2.engineValidate(certPath, zzYlb2);
                }
                catch (Exception exception) {
                    throw new zzVPQ("Certification path could not be validated.", exception);
                }
                return new PKIXCertPathBuilderResult(certPath, pKIXCertPathValidatorResult.getTrustAnchor(), pKIXCertPathValidatorResult.getPolicyTree(), pKIXCertPathValidatorResult.getPublicKey());
            }
            ArrayList<zzZp1> arrayList = new ArrayList<zzZp1>();
            arrayList.addAll(zzYlb2.zzYAb().zzZoB());
            try {
                arrayList.addAll(zzXO0.zzXDP(x509Certificate.getExtensionValue(zz7b.zz5F.getId()), zzYlb2.zzYAb().zzWfV()));
            }
            catch (CertificateParsingException certificateParsingException) {
                throw new zzVPQ("No additional X.509 stores can be added from certificate locations.", certificateParsingException);
            }
            HashSet hashSet = new HashSet();
            try {
                hashSet.addAll(zzXO0.zzXDP(x509Certificate, zzYlb2.zzYAb().zzWP9(), arrayList));
            }
            catch (zzVPQ zzVPQ2) {
                throw new zzVPQ("Cannot find issuer certificate for certificate in certification path.", zzVPQ2);
            }
            if (hashSet.isEmpty()) {
                throw new zzVPQ("No issuer certificate for certificate in certification path found.");
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext() && certPathBuilderResult == null) {
                X509Certificate x509Certificate2 = (X509Certificate)iterator.next();
                certPathBuilderResult = this.zzXDP(x509Certificate2, zzYlb2, list);
            }
        }
        catch (zzVPQ zzVPQ3) {
            this.zzX68 = zzVPQ3;
        }
        if (certPathBuilderResult == null) {
            list.remove(x509Certificate);
        }
        return certPathBuilderResult;
    }
}

