/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.cdn;

import com.qiniu.common.Constants;
import com.qiniu.common.QiniuException;
import com.qiniu.http.Client;
import com.qiniu.http.Response;
import com.qiniu.util.Auth;
import com.qiniu.util.Json;
import com.qiniu.util.StringMap;
import java.util.HashMap;

public final class CdnManager {
    private final Auth auth;
    private final String server;
    private final Client client;

    public CdnManager(Auth auth) {
        this(auth, "http://fusion.qiniuapi.com");
    }

    private CdnManager(Auth auth, String server) {
        this.auth = auth;
        this.server = server;
        this.client = new Client(null, false, null, 10, 30, 0);
    }

    public Response refreshUrls(String[] urls) throws QiniuException {
        return this.refreshUrlsAndDirs(urls, null);
    }

    public Response refreshDirs(String[] dirs) throws QiniuException {
        return this.refreshUrlsAndDirs(null, dirs);
    }

    public Response refreshUrlsAndDirs(String[] urls, String[] dirs) throws QiniuException {
        HashMap<String, String[]> req = new HashMap<String, String[]>();
        if (urls != null) {
            req.put("urls", urls);
        }
        if (dirs != null) {
            req.put("dirs", dirs);
        }
        byte[] body = Json.encode(req).getBytes(Constants.UTF_8);
        String url = this.server + "/v2/tune/refresh";
        StringMap headers = this.auth.authorizationV2(url, "POST", body, "application/json");
        return this.client.post(url, body, headers, "application/json");
    }
}

