/*
 * Decompiled with CFR 0.152.
 */
package marytts.language.en.prosody;

public class SentenceType {
    public static final SentenceType declarative = new SentenceType("declarative", "L-L%", "H-L%", "H-", "!H*", "L+H*");
    public static final SentenceType interrogative = new SentenceType("interrogative", "H-H%", "H-L%", "H-", "L*", "H*");
    public static final SentenceType exclamation = new SentenceType("exclamation", "L-L%", "H-L%", "H-", "H*", "H*");
    public static final SentenceType interrogYN = new SentenceType("interrogYN", "H-H%", "H-L%", "H-", "L*", "H*");
    public static final SentenceType interrogWH = new SentenceType("interrogWH", "L-L%", "H-L%", "H-", "H*", "H*");
    private String name;
    private String sentenceFinalBoundary;
    private String nonFinalMajorBoundary;
    private String minorBoundary;
    private String nuclearAccent;
    private String nonNuclearAccent;

    public static SentenceType punctuationType(String punct) {
        if (punct.equals(".")) {
            return declarative;
        }
        if (punct.equals("?")) {
            return interrogative;
        }
        if (punct.equals("!")) {
            return exclamation;
        }
        return null;
    }

    private SentenceType(String name, String sentenceFinalBoundary, String nonFinalMajorBoundary, String minorBoundary, String nuclearAccent, String nonNuclearAccent) {
        this.name = name;
        this.sentenceFinalBoundary = sentenceFinalBoundary;
        this.nonFinalMajorBoundary = nonFinalMajorBoundary;
        this.minorBoundary = minorBoundary;
        this.nuclearAccent = nuclearAccent;
        this.nonNuclearAccent = nonNuclearAccent;
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        return this.name();
    }

    public String sentenceFinalBoundary() {
        return this.sentenceFinalBoundary;
    }

    public String nonFinalMajorBoundary() {
        return this.nonFinalMajorBoundary;
    }

    public String minorBoundary() {
        return this.minorBoundary;
    }

    public String nuclearAccent() {
        return this.nuclearAccent;
    }

    public String nonNuclearAccent() {
        return this.nonNuclearAccent;
    }
}

