/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.adaptation.codebook;

import java.io.IOException;
import java.util.Arrays;
import marytts.signalproc.adaptation.BaselineAdaptationSet;
import marytts.signalproc.adaptation.Context;
import marytts.signalproc.adaptation.IndexMap;
import marytts.signalproc.adaptation.codebook.WeightedCodebookEntry;
import marytts.signalproc.adaptation.codebook.WeightedCodebookFeatureCollection;
import marytts.signalproc.adaptation.codebook.WeightedCodebookFeatureMapper;
import marytts.signalproc.adaptation.codebook.WeightedCodebookFile;
import marytts.signalproc.adaptation.codebook.WeightedCodebookFileHeader;
import marytts.signalproc.adaptation.codebook.WeightedCodebookTrainerParams;
import marytts.signalproc.analysis.EnergyContourRms;
import marytts.signalproc.analysis.Labels;
import marytts.signalproc.analysis.Lsfs;
import marytts.signalproc.analysis.PitchReaderWriter;
import marytts.util.math.MathUtils;
import marytts.util.signal.SignalProcUtils;

public class WeightedCodebookLsfMapper
extends WeightedCodebookFeatureMapper {
    private WeightedCodebookTrainerParams params;

    public WeightedCodebookLsfMapper(WeightedCodebookTrainerParams pa) {
        this.params = new WeightedCodebookTrainerParams(pa);
    }

    @Override
    public void learnMappingFrames(WeightedCodebookFile codebookFile, WeightedCodebookFeatureCollection fcol, BaselineAdaptationSet sourceTrainingSet, BaselineAdaptationSet targetTrainingSet, int[] map) throws IOException {
        assert (this.params.codebookHeader.codebookType == WeightedCodebookFileHeader.FRAMES);
        IndexMap imap = new IndexMap();
        WeightedCodebookEntry entry = null;
        boolean bHeaderWritten = false;
        int i = 0;
        while (i < fcol.indexMapFiles.length) {
            System.out.println("LSF mapping for pair " + String.valueOf(i + 1) + " of " + String.valueOf(fcol.indexMapFiles.length) + ":");
            imap.readFromFile(fcol.indexMapFiles[i]);
            if (imap.files != null && sourceTrainingSet.items.length > i && targetTrainingSet.items.length > i) {
                Lsfs srcFeatures = new Lsfs(sourceTrainingSet.items[i].lsfFile);
                Lsfs tgtFeatures = new Lsfs(targetTrainingSet.items[map[i]].lsfFile);
                PitchReaderWriter sourceF0s = new PitchReaderWriter(sourceTrainingSet.items[i].pitchFile);
                PitchReaderWriter targetF0s = new PitchReaderWriter(targetTrainingSet.items[map[i]].pitchFile);
                Labels sourceLabels = new Labels(sourceTrainingSet.items[i].labelFile);
                Labels targetLabels = new Labels(targetTrainingSet.items[map[i]].labelFile);
                EnergyContourRms sourceEnergies = EnergyContourRms.ReadEnergyFile(sourceTrainingSet.items[i].energyFile);
                EnergyContourRms targetEnergies = EnergyContourRms.ReadEnergyFile(targetTrainingSet.items[map[i]].energyFile);
                if (!bHeaderWritten) {
                    this.params.codebookHeader.lsfParams.dimension = srcFeatures.params.dimension;
                    this.params.codebookHeader.lsfParams.samplingRate = srcFeatures.params.samplingRate;
                    codebookFile.writeCodebookHeader(this.params.codebookHeader);
                    bHeaderWritten = true;
                }
                if (srcFeatures.lsfs != null && srcFeatures.lsfs != null) {
                    int j = 0;
                    while (j < imap.files[0].indicesMap.length) {
                        if (srcFeatures.lsfs.length > imap.files[0].indicesMap[j][0] && tgtFeatures.lsfs.length > imap.files[0].indicesMap[j][1]) {
                            entry = new WeightedCodebookEntry(srcFeatures.params.dimension, 0);
                            entry.setLsfs(srcFeatures.lsfs[imap.files[0].indicesMap[j][0]], tgtFeatures.lsfs[imap.files[0].indicesMap[j][1]]);
                            int index = MathUtils.linearMap(imap.files[0].indicesMap[j][0], 0, srcFeatures.lsfs.length - 1, 0, sourceF0s.contour.length - 1);
                            entry.sourceItem.f0 = sourceF0s.contour[index];
                            index = MathUtils.linearMap(imap.files[0].indicesMap[j][1], 0, tgtFeatures.lsfs.length - 1, 0, targetF0s.contour.length - 1);
                            entry.targetItem.f0 = targetF0s.contour[index];
                            index = SignalProcUtils.frameIndex2LabelIndex(imap.files[0].indicesMap[j][0], sourceLabels, srcFeatures.params.winsize, srcFeatures.params.skipsize);
                            entry.sourceItem.duration = index > 0 ? sourceLabels.items[index].time - sourceLabels.items[index - 1].time : sourceLabels.items[index].time;
                            entry.sourceItem.phn = sourceLabels.items[index].phn;
                            entry.sourceItem.context = new Context(sourceLabels, index, 10);
                            index = SignalProcUtils.frameIndex2LabelIndex(imap.files[0].indicesMap[j][1], targetLabels, tgtFeatures.params.winsize, tgtFeatures.params.skipsize);
                            entry.targetItem.duration = index > 0 ? targetLabels.items[index].time - targetLabels.items[index - 1].time : targetLabels.items[index].time;
                            entry.targetItem.phn = targetLabels.items[index].phn;
                            entry.targetItem.context = new Context(targetLabels, index, 10);
                            index = MathUtils.linearMap(imap.files[0].indicesMap[j][0], 0, srcFeatures.lsfs.length - 1, 0, sourceEnergies.contour.length - 1);
                            index = MathUtils.CheckLimits(index, 0, sourceEnergies.contour.length - 1);
                            entry.sourceItem.energy = sourceEnergies.contour[index];
                            index = MathUtils.linearMap(imap.files[0].indicesMap[j][1], 0, tgtFeatures.lsfs.length - 1, 0, targetEnergies.contour.length - 1);
                            index = MathUtils.CheckLimits(index, 0, targetEnergies.contour.length - 1);
                            entry.targetItem.energy = targetEnergies.contour[index];
                            if (entry.sourceItem.f0 > 10.0 && entry.targetItem.f0 > 10.0 || entry.sourceItem.f0 <= 10.0 && entry.targetItem.f0 <= 10.0) {
                                codebookFile.writeEntry(entry);
                            }
                        }
                        ++j;
                    }
                    System.out.println("Frame pairs processed in file " + String.valueOf(i + 1) + " of " + String.valueOf(fcol.indexMapFiles.length));
                }
            }
            ++i;
        }
    }

    @Override
    public void learnMappingFrameGroups(WeightedCodebookFile codebookFile, WeightedCodebookFeatureCollection fcol, BaselineAdaptationSet sourceTrainingSet, BaselineAdaptationSet targetTrainingSet, int[] map) throws IOException {
        assert (this.params.codebookHeader.codebookType == WeightedCodebookFileHeader.FRAME_GROUPS);
        IndexMap imap = new IndexMap();
        double[] meanSourceEntries = null;
        double[] meanTargetEntries = null;
        String sourcePhn = "";
        String targetPhn = "";
        Context sourceContext = null;
        Context targetContext = null;
        boolean bSourceOK = false;
        boolean bTargetOK = false;
        WeightedCodebookEntry entry = null;
        boolean bHeaderWritten = false;
        int i = 0;
        while (i < fcol.indexMapFiles.length) {
            System.out.println("LSF mapping for pair " + String.valueOf(i + 1) + " of " + String.valueOf(fcol.indexMapFiles.length) + ":");
            imap.readFromFile(fcol.indexMapFiles[i]);
            if (imap.files != null && sourceTrainingSet.items.length > i && targetTrainingSet.items.length > i) {
                Lsfs srcFeatures = new Lsfs(sourceTrainingSet.items[i].lsfFile);
                Lsfs tgtFeatures = new Lsfs(targetTrainingSet.items[map[i]].lsfFile);
                PitchReaderWriter sourceF0s = new PitchReaderWriter(sourceTrainingSet.items[i].pitchFile);
                PitchReaderWriter targetF0s = new PitchReaderWriter(targetTrainingSet.items[map[i]].pitchFile);
                Labels sourceLabels = new Labels(sourceTrainingSet.items[i].labelFile);
                Labels targetLabels = new Labels(targetTrainingSet.items[map[i]].labelFile);
                EnergyContourRms sourceEnergies = EnergyContourRms.ReadEnergyFile(sourceTrainingSet.items[i].energyFile);
                EnergyContourRms targetEnergies = EnergyContourRms.ReadEnergyFile(targetTrainingSet.items[map[i]].energyFile);
                if (!bHeaderWritten) {
                    this.params.codebookHeader.lsfParams.dimension = srcFeatures.params.dimension;
                    this.params.codebookHeader.lsfParams.samplingRate = srcFeatures.params.samplingRate;
                    codebookFile.writeCodebookHeader(this.params.codebookHeader);
                    bHeaderWritten = true;
                }
                if (i == 0) {
                    meanSourceEntries = new double[srcFeatures.params.dimension];
                    meanTargetEntries = new double[tgtFeatures.params.dimension];
                } else {
                    if (meanSourceEntries.length != srcFeatures.params.dimension) {
                        System.out.println("Error! LSF vector size mismatch in source lsf file " + sourceTrainingSet.items[i].lsfFile);
                        return;
                    }
                    if (meanTargetEntries.length != tgtFeatures.params.dimension) {
                        System.out.println("Error! LSF vector size mismatch in target lsf file " + targetTrainingSet.items[map[i]].lsfFile);
                        return;
                    }
                }
                if (srcFeatures.lsfs != null && tgtFeatures.lsfs != null) {
                    int j = 0;
                    while (j < imap.files[0].indicesMap.length) {
                        int index;
                        int n;
                        Arrays.fill(meanSourceEntries, 0.0);
                        Arrays.fill(meanTargetEntries, 0.0);
                        double sourceAverageF0 = 0.0;
                        double targetAverageF0 = 0.0;
                        double sourceAverageDuration = 0.0;
                        double targetAverageDuration = 0.0;
                        double sourceAverageEnergy = 0.0;
                        double targetAverageEnergy = 0.0;
                        int sourceTotalVoiceds = 0;
                        int targetTotalVoiceds = 0;
                        int sourceTotal = 0;
                        int targetTotal = 0;
                        int totalFrames = 0;
                        bSourceOK = false;
                        int middle = (int)Math.floor(0.5 * (double)(imap.files[0].indicesMap[j][0] + imap.files[0].indicesMap[j][1]) + 0.5);
                        int k = imap.files[0].indicesMap[j][0];
                        while (k <= imap.files[0].indicesMap[j][1]) {
                            if (k >= 0 && k < srcFeatures.lsfs.length) {
                                ++totalFrames;
                                bSourceOK = true;
                                n = 0;
                                while (n < srcFeatures.params.dimension) {
                                    int n2 = n;
                                    meanSourceEntries[n2] = meanSourceEntries[n2] + srcFeatures.lsfs[k][n];
                                    ++n;
                                }
                                index = MathUtils.linearMap(k, 0, srcFeatures.lsfs.length - 1, 0, sourceF0s.contour.length - 1);
                                if (sourceF0s.contour[index] > 10.0) {
                                    sourceAverageF0 += sourceF0s.contour[index];
                                    ++sourceTotalVoiceds;
                                }
                                sourceAverageDuration = (index = SignalProcUtils.frameIndex2LabelIndex(k, sourceLabels, srcFeatures.params.winsize, srcFeatures.params.skipsize)) > 0 ? (sourceAverageDuration += sourceLabels.items[index].time - sourceLabels.items[index - 1].time) : (sourceAverageDuration += sourceLabels.items[index].time);
                                if (k == middle) {
                                    sourcePhn = sourceLabels.items[index].phn;
                                    sourceContext = new Context(sourceLabels, index, 10);
                                }
                                index = MathUtils.linearMap(k, 0, srcFeatures.lsfs.length - 1, 0, sourceEnergies.contour.length - 1);
                                index = MathUtils.CheckLimits(index, 0, sourceEnergies.contour.length - 1);
                                sourceAverageEnergy += sourceEnergies.contour[index];
                                ++sourceTotal;
                            }
                            ++k;
                        }
                        if (bSourceOK) {
                            n = 0;
                            while (n < srcFeatures.params.dimension) {
                                int n3 = n++;
                                meanSourceEntries[n3] = meanSourceEntries[n3] / (double)totalFrames;
                            }
                            totalFrames = 0;
                            bTargetOK = false;
                            middle = (int)Math.floor(0.5 * (double)(imap.files[0].indicesMap[j][2] + imap.files[0].indicesMap[j][3]) + 0.5);
                            k = imap.files[0].indicesMap[j][2];
                            while (k <= imap.files[0].indicesMap[j][3]) {
                                if (k >= 0 && k < tgtFeatures.lsfs.length) {
                                    ++totalFrames;
                                    bTargetOK = true;
                                    n = 0;
                                    while (n < tgtFeatures.params.dimension) {
                                        int n4 = n;
                                        meanTargetEntries[n4] = meanTargetEntries[n4] + tgtFeatures.lsfs[k][n];
                                        ++n;
                                    }
                                    index = MathUtils.linearMap(k, 0, tgtFeatures.lsfs.length - 1, 0, targetF0s.contour.length - 1);
                                    if (targetF0s.contour[index] > 10.0) {
                                        targetAverageF0 += targetF0s.contour[index];
                                        ++targetTotalVoiceds;
                                    }
                                    targetAverageDuration = (index = SignalProcUtils.frameIndex2LabelIndex(k, targetLabels, tgtFeatures.params.winsize, tgtFeatures.params.skipsize)) > 0 ? (targetAverageDuration += targetLabels.items[index].time - targetLabels.items[index - 1].time) : (targetAverageDuration += targetLabels.items[index].time);
                                    if (k == middle) {
                                        targetPhn = targetLabels.items[index].phn;
                                        targetContext = new Context(targetLabels, index, 10);
                                    }
                                    index = MathUtils.linearMap(k, 0, tgtFeatures.lsfs.length - 1, 0, targetEnergies.contour.length - 1);
                                    index = MathUtils.CheckLimits(index, 0, targetEnergies.contour.length - 1);
                                    targetAverageEnergy += targetEnergies.contour[index];
                                    ++targetTotal;
                                }
                                ++k;
                            }
                            if (bTargetOK) {
                                n = 0;
                                while (n < tgtFeatures.params.dimension) {
                                    int n5 = n++;
                                    meanTargetEntries[n5] = meanTargetEntries[n5] / (double)totalFrames;
                                }
                                entry = new WeightedCodebookEntry(meanSourceEntries.length, 0);
                                entry.setLsfs(meanSourceEntries, meanTargetEntries);
                                if (sourceTotalVoiceds > 0) {
                                    sourceAverageF0 /= (double)sourceTotalVoiceds;
                                }
                                if (targetTotalVoiceds > 0) {
                                    targetAverageF0 /= (double)targetTotalVoiceds;
                                }
                                entry.sourceItem.f0 = sourceAverageF0;
                                entry.targetItem.f0 = targetAverageF0;
                                if (sourceTotal > 0) {
                                    sourceAverageDuration /= (double)sourceTotal;
                                }
                                if (targetTotal > 0) {
                                    sourceAverageDuration /= (double)targetTotal;
                                }
                                entry.sourceItem.duration = sourceAverageDuration;
                                entry.targetItem.duration = targetAverageDuration;
                                entry.sourceItem.phn = sourcePhn;
                                entry.targetItem.phn = targetPhn;
                                entry.sourceItem.context = new Context(sourceContext);
                                entry.targetItem.context = new Context(targetContext);
                                if (sourceTotal > 0) {
                                    sourceAverageEnergy /= (double)sourceTotal;
                                }
                                if (targetTotal > 0) {
                                    targetAverageEnergy /= (double)targetTotal;
                                }
                                entry.sourceItem.energy = sourceAverageEnergy;
                                entry.targetItem.energy = targetAverageEnergy;
                                if (entry.sourceItem.f0 > 10.0 && entry.targetItem.f0 > 10.0 || entry.sourceItem.f0 <= 10.0 && entry.targetItem.f0 <= 10.0) {
                                    codebookFile.writeEntry(entry);
                                }
                            }
                        }
                        ++j;
                    }
                    System.out.println("Frame pairs processed in file " + String.valueOf(i + 1) + " of " + String.valueOf(fcol.indexMapFiles.length));
                }
            }
            ++i;
        }
    }

    @Override
    public void learnMappingLabels(WeightedCodebookFile codebookFile, WeightedCodebookFeatureCollection fcol, BaselineAdaptationSet sourceTrainingSet, BaselineAdaptationSet targetTrainingSet, int[] map) throws IOException {
        assert (this.params.codebookHeader.codebookType == WeightedCodebookFileHeader.LABELS);
        IndexMap imap = new IndexMap();
        boolean bSourceOK = false;
        boolean bTargetOK = false;
        double[] meanSourceEntries = null;
        double[] meanTargetEntries = null;
        String sourcePhn = "";
        String targetPhn = "";
        Context sourceContext = null;
        Context targetContext = null;
        WeightedCodebookEntry entry = null;
        boolean bHeaderWritten = false;
        int i = 0;
        while (i < fcol.indexMapFiles.length) {
            System.out.println("LSF mapping for pair " + String.valueOf(i + 1) + " of " + String.valueOf(fcol.indexMapFiles.length) + ":");
            imap.readFromFile(fcol.indexMapFiles[i]);
            if (imap.files != null && sourceTrainingSet.items.length > i && targetTrainingSet.items.length > i) {
                Lsfs srcFeatures = new Lsfs(sourceTrainingSet.items[i].lsfFile);
                Lsfs tgtFeatures = new Lsfs(targetTrainingSet.items[map[i]].lsfFile);
                PitchReaderWriter sourceF0s = new PitchReaderWriter(sourceTrainingSet.items[i].pitchFile);
                PitchReaderWriter targetF0s = new PitchReaderWriter(targetTrainingSet.items[map[i]].pitchFile);
                Labels sourceLabels = new Labels(sourceTrainingSet.items[i].labelFile);
                Labels targetLabels = new Labels(targetTrainingSet.items[map[i]].labelFile);
                EnergyContourRms sourceEnergies = EnergyContourRms.ReadEnergyFile(sourceTrainingSet.items[i].energyFile);
                EnergyContourRms targetEnergies = EnergyContourRms.ReadEnergyFile(targetTrainingSet.items[map[i]].energyFile);
                if (!bHeaderWritten) {
                    this.params.codebookHeader.lsfParams.dimension = srcFeatures.params.dimension;
                    this.params.codebookHeader.lsfParams.samplingRate = srcFeatures.params.samplingRate;
                    codebookFile.writeCodebookHeader(this.params.codebookHeader);
                    bHeaderWritten = true;
                }
                if (i == 0) {
                    meanSourceEntries = new double[srcFeatures.params.dimension];
                    meanTargetEntries = new double[tgtFeatures.params.dimension];
                } else {
                    if (meanSourceEntries.length != srcFeatures.params.dimension) {
                        System.out.println("Error! LSF vector size mismatch in source lsf file " + sourceTrainingSet.items[i].lsfFile);
                        return;
                    }
                    if (meanTargetEntries.length != tgtFeatures.params.dimension) {
                        System.out.println("Error! LSF vector size mismatch in target lsf file " + targetTrainingSet.items[map[i]].lsfFile);
                        return;
                    }
                }
                if (srcFeatures.lsfs != null && tgtFeatures.lsfs != null) {
                    int j = 0;
                    while (j < imap.files[0].indicesMap.length) {
                        int index;
                        int n;
                        Arrays.fill(meanSourceEntries, 0.0);
                        Arrays.fill(meanTargetEntries, 0.0);
                        double sourceAverageF0 = 0.0;
                        double targetAverageF0 = 0.0;
                        double sourceAverageDuration = 0.0;
                        double targetAverageDuration = 0.0;
                        double sourceAverageEnergy = 0.0;
                        double targetAverageEnergy = 0.0;
                        int sourceTotalVoiceds = 0;
                        int targetTotalVoiceds = 0;
                        int sourceTotal = 0;
                        int targetTotal = 0;
                        int totalFrames = 0;
                        bSourceOK = false;
                        int middle = (int)Math.floor(0.5 * (double)(imap.files[0].indicesMap[j][0] + imap.files[0].indicesMap[j][1]) + 0.5);
                        int k = imap.files[0].indicesMap[j][0];
                        while (k <= imap.files[0].indicesMap[j][1]) {
                            if (k >= 0 && k < srcFeatures.lsfs.length) {
                                ++totalFrames;
                                bSourceOK = true;
                                n = 0;
                                while (n < srcFeatures.params.dimension) {
                                    int n2 = n;
                                    meanSourceEntries[n2] = meanSourceEntries[n2] + srcFeatures.lsfs[k][n];
                                    ++n;
                                }
                                index = MathUtils.linearMap(k, 0, srcFeatures.lsfs.length - 1, 0, sourceF0s.contour.length - 1);
                                if (sourceF0s.contour[index] > 10.0) {
                                    sourceAverageF0 += sourceF0s.contour[index];
                                    ++sourceTotalVoiceds;
                                }
                                sourceAverageDuration = (index = SignalProcUtils.frameIndex2LabelIndex(k, sourceLabels, srcFeatures.params.winsize, srcFeatures.params.skipsize)) > 0 ? (sourceAverageDuration += sourceLabels.items[index].time - sourceLabels.items[index - 1].time) : (sourceAverageDuration += sourceLabels.items[index].time);
                                if (k == middle) {
                                    sourcePhn = sourceLabels.items[index].phn;
                                    sourceContext = new Context(sourceLabels, index, 10);
                                }
                                index = MathUtils.linearMap(k, 0, srcFeatures.lsfs.length - 1, 0, sourceEnergies.contour.length - 1);
                                index = MathUtils.CheckLimits(index, 0, sourceEnergies.contour.length - 1);
                                sourceAverageEnergy += sourceEnergies.contour[index];
                                ++sourceTotal;
                            }
                            ++k;
                        }
                        if (bSourceOK) {
                            n = 0;
                            while (n < srcFeatures.params.dimension) {
                                int n3 = n++;
                                meanSourceEntries[n3] = meanSourceEntries[n3] / (double)totalFrames;
                            }
                            totalFrames = 0;
                            bTargetOK = false;
                            middle = (int)Math.floor(0.5 * (double)(imap.files[0].indicesMap[j][2] + imap.files[0].indicesMap[j][3]) + 0.5);
                            k = imap.files[0].indicesMap[j][2];
                            while (k <= imap.files[0].indicesMap[j][3]) {
                                if (k >= 0 && k < tgtFeatures.lsfs.length) {
                                    ++totalFrames;
                                    bTargetOK = true;
                                    n = 0;
                                    while (n < tgtFeatures.params.dimension) {
                                        int n4 = n;
                                        meanTargetEntries[n4] = meanTargetEntries[n4] + tgtFeatures.lsfs[k][n];
                                        ++n;
                                    }
                                    index = MathUtils.linearMap(k, 0, tgtFeatures.lsfs.length - 1, 0, targetF0s.contour.length - 1);
                                    if (targetF0s.contour[index] > 10.0) {
                                        targetAverageF0 += targetF0s.contour[index];
                                        ++targetTotalVoiceds;
                                    }
                                    targetAverageDuration = (index = SignalProcUtils.frameIndex2LabelIndex(k, targetLabels, tgtFeatures.params.winsize, tgtFeatures.params.skipsize)) > 0 ? (targetAverageDuration += targetLabels.items[index].time - targetLabels.items[index - 1].time) : (targetAverageDuration += targetLabels.items[index].time);
                                    if (k == middle) {
                                        targetPhn = targetLabels.items[index].phn;
                                        targetContext = new Context(targetLabels, index, 10);
                                    }
                                    index = MathUtils.linearMap(k, 0, tgtFeatures.lsfs.length - 1, 0, targetEnergies.contour.length - 1);
                                    index = MathUtils.CheckLimits(index, 0, targetEnergies.contour.length - 1);
                                    targetAverageEnergy += targetEnergies.contour[index];
                                    ++targetTotal;
                                }
                                ++k;
                            }
                            if (bTargetOK) {
                                n = 0;
                                while (n < tgtFeatures.params.dimension) {
                                    int n5 = n++;
                                    meanTargetEntries[n5] = meanTargetEntries[n5] / (double)totalFrames;
                                }
                                entry = new WeightedCodebookEntry(meanSourceEntries.length, 0);
                                entry.setLsfs(meanSourceEntries, meanTargetEntries);
                                if (sourceTotalVoiceds > 0) {
                                    sourceAverageF0 /= (double)sourceTotalVoiceds;
                                }
                                if (targetTotalVoiceds > 0) {
                                    targetAverageF0 /= (double)targetTotalVoiceds;
                                }
                                entry.sourceItem.f0 = sourceAverageF0;
                                entry.targetItem.f0 = targetAverageF0;
                                if (sourceTotal > 0) {
                                    sourceAverageDuration /= (double)sourceTotal;
                                }
                                if (targetTotal > 0) {
                                    sourceAverageDuration /= (double)targetTotal;
                                }
                                entry.sourceItem.duration = sourceAverageDuration;
                                entry.targetItem.duration = targetAverageDuration;
                                entry.sourceItem.phn = sourcePhn;
                                entry.targetItem.phn = targetPhn;
                                entry.sourceItem.context = new Context(sourceContext);
                                entry.targetItem.context = new Context(targetContext);
                                if (sourceTotal > 0) {
                                    sourceAverageEnergy /= (double)sourceTotal;
                                }
                                if (targetTotal > 0) {
                                    targetAverageEnergy /= (double)targetTotal;
                                }
                                entry.sourceItem.energy = sourceAverageEnergy;
                                entry.targetItem.energy = targetAverageEnergy;
                                if (entry.sourceItem.f0 > 10.0 && entry.targetItem.f0 > 10.0 || entry.sourceItem.f0 <= 10.0 && entry.targetItem.f0 <= 10.0) {
                                    codebookFile.writeEntry(entry);
                                }
                                System.out.println("Label pair " + String.valueOf(j + 1) + " of " + String.valueOf(imap.files[0].indicesMap.length));
                            }
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
    }

    @Override
    public void learnMappingLabelGroups(WeightedCodebookFile codebookFile, WeightedCodebookFeatureCollection fcol, BaselineAdaptationSet sourceTrainingSet, BaselineAdaptationSet targetTrainingSet, int[] map) throws IOException {
        this.learnMappingLabels(codebookFile, fcol, sourceTrainingSet, targetTrainingSet, map);
    }

    @Override
    public void learnMappingSpeech(WeightedCodebookFile codebookFile, WeightedCodebookFeatureCollection fcol, BaselineAdaptationSet sourceTrainingSet, BaselineAdaptationSet targetTrainingSet, int[] map) throws IOException {
        int n;
        assert (this.params.codebookHeader.codebookType == WeightedCodebookFileHeader.SPEECH);
        double[] meanSourceEntries = null;
        double[] meanTargetEntries = null;
        WeightedCodebookEntry entry = null;
        boolean bHeaderWritten = false;
        int totalFramesSrc = 0;
        boolean bSourceOK = false;
        int totalFramesTgt = 0;
        boolean bTargetOK = false;
        int lpOrderSrc = 0;
        int lpOrderTgt = 0;
        int i = 0;
        while (i < fcol.indexMapFiles.length) {
            System.out.println("LSF mapping for pair " + String.valueOf(i + 1) + " of " + String.valueOf(fcol.indexMapFiles.length) + ":");
            if (sourceTrainingSet.items.length > i) {
                int j;
                Lsfs srcFeatures = new Lsfs(sourceTrainingSet.items[i].lsfFile);
                Lsfs tgtFeatures = new Lsfs(targetTrainingSet.items[map[i]].lsfFile);
                if (!bHeaderWritten) {
                    this.params.codebookHeader.lsfParams.dimension = srcFeatures.params.dimension;
                    this.params.codebookHeader.lsfParams.samplingRate = srcFeatures.params.samplingRate;
                    codebookFile.writeCodebookHeader(this.params.codebookHeader);
                    bHeaderWritten = true;
                }
                if (i == 0) {
                    meanSourceEntries = new double[srcFeatures.params.dimension];
                    meanTargetEntries = new double[tgtFeatures.params.dimension];
                    Arrays.fill(meanSourceEntries, 0.0);
                    Arrays.fill(meanTargetEntries, 0.0);
                    lpOrderSrc = srcFeatures.params.dimension;
                    lpOrderTgt = srcFeatures.params.dimension;
                } else {
                    if (meanSourceEntries.length != srcFeatures.params.dimension) {
                        System.out.println("Error! LSF vector size mismatch in source lsf file " + sourceTrainingSet.items[i].lsfFile);
                        return;
                    }
                    if (meanTargetEntries.length != tgtFeatures.params.dimension) {
                        System.out.println("Error! LSF vector size mismatch in target lsf file " + targetTrainingSet.items[map[i]].lsfFile);
                        return;
                    }
                }
                if (srcFeatures.lsfs != null) {
                    j = 0;
                    while (j < srcFeatures.params.numfrm) {
                        ++totalFramesSrc;
                        bSourceOK = true;
                        n = 0;
                        while (n < lpOrderSrc) {
                            int n2 = n;
                            meanSourceEntries[n2] = meanSourceEntries[n2] + srcFeatures.lsfs[j][n];
                            ++n;
                        }
                        ++j;
                    }
                }
                if (tgtFeatures.lsfs != null) {
                    j = 0;
                    while (j < tgtFeatures.params.numfrm) {
                        ++totalFramesTgt;
                        bTargetOK = true;
                        n = 0;
                        while (n < lpOrderTgt) {
                            int n3 = n;
                            meanTargetEntries[n3] = meanTargetEntries[n3] + tgtFeatures.lsfs[j][n];
                            ++n;
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        if (bSourceOK) {
            n = 0;
            while (n < lpOrderSrc) {
                int n4 = n++;
                meanSourceEntries[n4] = meanSourceEntries[n4] / (double)totalFramesSrc;
            }
        }
        if (bTargetOK) {
            n = 0;
            while (n < lpOrderTgt) {
                int n5 = n++;
                meanTargetEntries[n5] = meanTargetEntries[n5] / (double)totalFramesTgt;
            }
        }
        if (bSourceOK && bTargetOK) {
            entry = new WeightedCodebookEntry(meanSourceEntries.length, 0);
            entry.setLsfs(meanSourceEntries, meanTargetEntries);
            codebookFile.writeEntry(entry);
        }
    }
}

