/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.adaptation.outlier;

import java.io.IOException;
import java.util.Arrays;
import marytts.machinelearning.KMeansClusteringTrainer;
import marytts.machinelearning.KMeansClusteringTrainerParams;
import marytts.signalproc.adaptation.BaselineFeatureExtractor;
import marytts.signalproc.adaptation.OutlierStatus;
import marytts.signalproc.adaptation.codebook.WeightedCodebook;
import marytts.signalproc.adaptation.codebook.WeightedCodebookFile;
import marytts.signalproc.adaptation.codebook.WeightedCodebookFileHeader;
import marytts.signalproc.adaptation.outlier.KMeansMappingEliminatorParams;
import marytts.signalproc.analysis.distance.DistanceComputer;
import marytts.util.math.MathUtils;

public class KMeansMappingEliminator {
    KMeansClusteringTrainer sourceLsfClusterer;
    KMeansClusteringTrainer sourceF0Clusterer;
    KMeansClusteringTrainer sourceEnergyClusterer;
    KMeansClusteringTrainer sourceDurationClusterer;
    KMeansClusteringTrainer targetLsfClusterer;
    KMeansClusteringTrainer targetF0Clusterer;
    KMeansClusteringTrainer targetEnergyClusterer;
    KMeansClusteringTrainer targetDurationClusterer;
    KMeansClusteringTrainer sourceClusterer;
    KMeansClusteringTrainer targetClusterer;

    public void eliminate(KMeansMappingEliminatorParams params, String codebookFileIn, String codebookFileOut) {
        this.sourceLsfClusterer = null;
        this.sourceF0Clusterer = null;
        this.sourceEnergyClusterer = null;
        this.sourceDurationClusterer = null;
        this.targetLsfClusterer = null;
        this.targetF0Clusterer = null;
        this.targetEnergyClusterer = null;
        this.targetDurationClusterer = null;
        this.sourceClusterer = null;
        this.targetClusterer = null;
        WeightedCodebookFile fileIn = new WeightedCodebookFile(codebookFileIn, WeightedCodebookFile.OPEN_FOR_READ);
        WeightedCodebook codebookIn = null;
        try {
            codebookIn = fileIn.readCodebookFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int[] acceptanceStatus = new int[codebookIn.header.totalEntries];
        Arrays.fill(acceptanceStatus, OutlierStatus.NON_OUTLIER);
        int totalLsfOutliers = 0;
        int totalDurationOutliers = 0;
        int totalF0Outliers = 0;
        int totalEnergyOutliers = 0;
        int totalOutliers = 0;
        if (codebookIn != null) {
            if (params.isSeparateClustering) {
                if (params.isCheckLsfOutliers) {
                    this.sourceLsfClusterer = this.clusterFeatures(codebookIn, BaselineFeatureExtractor.LSF_FEATURES, 1, params, params.numClustersLsf);
                    this.targetLsfClusterer = this.clusterFeatures(codebookIn, BaselineFeatureExtractor.LSF_FEATURES, 2, params, params.numClustersLsf);
                }
                if (params.isCheckF0Outliers) {
                    this.sourceF0Clusterer = this.clusterFeatures(codebookIn, BaselineFeatureExtractor.F0_FEATURES, 1, params, params.numClustersF0);
                    this.targetF0Clusterer = this.clusterFeatures(codebookIn, BaselineFeatureExtractor.F0_FEATURES, 2, params, params.numClustersF0);
                }
                if (params.isCheckEnergyOutliers) {
                    this.sourceEnergyClusterer = this.clusterFeatures(codebookIn, BaselineFeatureExtractor.ENERGY_FEATURES, 1, params, params.numClustersEnergy);
                    this.targetEnergyClusterer = this.clusterFeatures(codebookIn, BaselineFeatureExtractor.ENERGY_FEATURES, 2, params, params.numClustersEnergy);
                }
                if (params.isCheckDurationOutliers) {
                    this.sourceDurationClusterer = this.clusterFeatures(codebookIn, BaselineFeatureExtractor.DURATION_FEATURES, 1, params, params.numClustersDuration);
                    this.targetDurationClusterer = this.clusterFeatures(codebookIn, BaselineFeatureExtractor.DURATION_FEATURES, 2, params, params.numClustersDuration);
                }
                if (params.eliminationAlgorithm == 1) {
                    if (params.isCheckLsfOutliers) {
                        totalLsfOutliers = this.eliminateLeastLikelyMappings(this.sourceLsfClusterer, this.targetLsfClusterer, acceptanceStatus, BaselineFeatureExtractor.LSF_FEATURES, OutlierStatus.LSF_OUTLIER, params.eliminationLikelihood, params.distanceType);
                        System.out.println("Total lsf outliers = " + String.valueOf(totalLsfOutliers));
                    }
                    if (params.isCheckF0Outliers) {
                        totalF0Outliers = this.eliminateLeastLikelyMappings(this.sourceF0Clusterer, this.targetF0Clusterer, acceptanceStatus, BaselineFeatureExtractor.F0_FEATURES, OutlierStatus.F0_OUTLIER, params.eliminationLikelihood, params.distanceType);
                        System.out.println("Total f0 outliers = " + String.valueOf(totalF0Outliers));
                    }
                    if (params.isCheckDurationOutliers) {
                        totalDurationOutliers = this.eliminateLeastLikelyMappings(this.sourceDurationClusterer, this.targetDurationClusterer, acceptanceStatus, BaselineFeatureExtractor.DURATION_FEATURES, OutlierStatus.DURATION_OUTLIER, params.eliminationLikelihood, params.distanceType);
                        System.out.println("Total duration outliers = " + String.valueOf(totalDurationOutliers));
                    }
                    if (params.isCheckEnergyOutliers) {
                        totalEnergyOutliers = this.eliminateLeastLikelyMappings(this.sourceEnergyClusterer, this.targetEnergyClusterer, acceptanceStatus, BaselineFeatureExtractor.ENERGY_FEATURES, OutlierStatus.ENERGY_OUTLIER, params.eliminationLikelihood, params.distanceType);
                        System.out.println("Total energy outliers = " + String.valueOf(totalEnergyOutliers));
                    }
                } else if (params.eliminationAlgorithm == 2) {
                    if (params.isCheckLsfOutliers) {
                        totalLsfOutliers = this.eliminateMeanDistanceMismatches(codebookIn, this.sourceLsfClusterer, this.targetLsfClusterer, acceptanceStatus, BaselineFeatureExtractor.LSF_FEATURES, OutlierStatus.LSF_OUTLIER, params.totalStandardDeviations.lsf, params.distanceType, params.isGlobalVariance);
                        System.out.println("Total lsf outliers = " + String.valueOf(totalLsfOutliers));
                    }
                    if (params.isCheckF0Outliers) {
                        totalF0Outliers = this.eliminateMeanDistanceMismatches(codebookIn, this.sourceF0Clusterer, this.targetF0Clusterer, acceptanceStatus, BaselineFeatureExtractor.F0_FEATURES, OutlierStatus.F0_OUTLIER, params.totalStandardDeviations.f0, params.distanceType, params.isGlobalVariance);
                        System.out.println("Total f0 outliers = " + String.valueOf(totalF0Outliers));
                    }
                    if (params.isCheckDurationOutliers) {
                        totalDurationOutliers = this.eliminateMeanDistanceMismatches(codebookIn, this.sourceDurationClusterer, this.targetDurationClusterer, acceptanceStatus, BaselineFeatureExtractor.DURATION_FEATURES, OutlierStatus.DURATION_OUTLIER, params.totalStandardDeviations.duration, params.distanceType, params.isGlobalVariance);
                        System.out.println("Total duration outliers = " + String.valueOf(totalDurationOutliers));
                    }
                    if (params.isCheckEnergyOutliers) {
                        totalEnergyOutliers = this.eliminateMeanDistanceMismatches(codebookIn, this.sourceEnergyClusterer, this.targetEnergyClusterer, acceptanceStatus, BaselineFeatureExtractor.ENERGY_FEATURES, OutlierStatus.ENERGY_OUTLIER, params.totalStandardDeviations.energy, params.distanceType, params.isGlobalVariance);
                        System.out.println("Total energy outliers = " + String.valueOf(totalEnergyOutliers));
                    }
                } else if (params.eliminationAlgorithm == 3) {
                    if (params.isCheckLsfOutliers) {
                        totalLsfOutliers = this.eliminateUsingSubclusterMeanDistances(codebookIn, this.sourceLsfClusterer, this.targetLsfClusterer, acceptanceStatus, BaselineFeatureExtractor.LSF_FEATURES, OutlierStatus.LSF_OUTLIER, params.totalStandardDeviations.lsf, params.distanceType);
                        System.out.println("Total lsf outliers = " + String.valueOf(totalLsfOutliers));
                    }
                    if (params.isCheckF0Outliers) {
                        totalF0Outliers = this.eliminateUsingSubclusterMeanDistances(codebookIn, this.sourceF0Clusterer, this.targetF0Clusterer, acceptanceStatus, BaselineFeatureExtractor.F0_FEATURES, OutlierStatus.F0_OUTLIER, params.totalStandardDeviations.f0, params.distanceType);
                        System.out.println("Total f0 outliers = " + String.valueOf(totalF0Outliers));
                    }
                    if (params.isCheckDurationOutliers) {
                        totalDurationOutliers = this.eliminateUsingSubclusterMeanDistances(codebookIn, this.sourceDurationClusterer, this.targetDurationClusterer, acceptanceStatus, BaselineFeatureExtractor.DURATION_FEATURES, OutlierStatus.DURATION_OUTLIER, params.totalStandardDeviations.duration, params.distanceType);
                        System.out.println("Total duration outliers = " + String.valueOf(totalDurationOutliers));
                    }
                    if (params.isCheckEnergyOutliers) {
                        totalEnergyOutliers = this.eliminateUsingSubclusterMeanDistances(codebookIn, this.sourceEnergyClusterer, this.targetEnergyClusterer, acceptanceStatus, BaselineFeatureExtractor.ENERGY_FEATURES, OutlierStatus.ENERGY_OUTLIER, params.totalStandardDeviations.energy, params.distanceType);
                        System.out.println("Total energy outliers = " + String.valueOf(totalEnergyOutliers));
                    }
                }
            } else {
                int desiredFeatures = 0;
                if (params.isCheckLsfOutliers) {
                    desiredFeatures += BaselineFeatureExtractor.LSF_FEATURES;
                }
                if (params.isCheckF0Outliers) {
                    desiredFeatures += BaselineFeatureExtractor.F0_FEATURES;
                }
                if (params.isCheckEnergyOutliers) {
                    desiredFeatures += BaselineFeatureExtractor.ENERGY_FEATURES;
                }
                if (params.isCheckDurationOutliers) {
                    desiredFeatures += BaselineFeatureExtractor.DURATION_FEATURES;
                }
                if (desiredFeatures != 0) {
                    this.sourceClusterer = this.clusterFeatures(codebookIn, desiredFeatures, 1, params, params.numClusters);
                    this.targetClusterer = this.clusterFeatures(codebookIn, desiredFeatures, 2, params, params.numClusters);
                    if (params.eliminationAlgorithm == 1) {
                        totalOutliers = this.eliminateLeastLikelyMappings(this.sourceClusterer, this.targetClusterer, acceptanceStatus, desiredFeatures, OutlierStatus.GENERAL_OUTLIER, params.eliminationLikelihood, params.distanceType);
                    } else if (params.eliminationAlgorithm == 2) {
                        totalOutliers = this.eliminateMeanDistanceMismatches(codebookIn, this.sourceClusterer, this.targetClusterer, acceptanceStatus, BaselineFeatureExtractor.LSF_FEATURES, OutlierStatus.LSF_OUTLIER, params.totalStandardDeviations.general, params.distanceType, params.isGlobalVariance);
                    } else if (params.eliminationAlgorithm == 3) {
                        totalOutliers = this.eliminateUsingSubclusterMeanDistances(codebookIn, this.sourceClusterer, this.targetClusterer, acceptanceStatus, BaselineFeatureExtractor.LSF_FEATURES, OutlierStatus.LSF_OUTLIER, params.totalStandardDeviations.general, params.distanceType);
                    }
                }
                System.out.println("Total outliers = " + String.valueOf(totalOutliers));
            }
            int newTotalEntries = 0;
            int i = 0;
            while (i < codebookIn.header.totalEntries) {
                if (acceptanceStatus[i] == OutlierStatus.NON_OUTLIER) {
                    ++newTotalEntries;
                }
                ++i;
            }
            WeightedCodebookFile codebookOut = new WeightedCodebookFile(codebookFileOut, WeightedCodebookFile.OPEN_FOR_WRITE);
            WeightedCodebookFileHeader headerOut = new WeightedCodebookFileHeader(codebookIn.header);
            headerOut.resetTotalEntries();
            codebookOut.writeCodebookHeader(headerOut);
            i = 0;
            while (i < codebookIn.header.totalEntries) {
                if (acceptanceStatus[i] == OutlierStatus.NON_OUTLIER) {
                    codebookOut.writeEntry(codebookIn.entries[i]);
                }
                ++i;
            }
            codebookOut.close();
            System.out.println("Outliers detected = " + String.valueOf(codebookIn.header.totalEntries - newTotalEntries) + " of " + String.valueOf(codebookIn.header.totalEntries));
        }
    }

    private KMeansClusteringTrainer clusterFeatures(WeightedCodebook codebook, int desiredFeatures, int speakerType, KMeansMappingEliminatorParams params, int numClusters) {
        KMeansClusteringTrainer clusterer = null;
        double[][] features = codebook.getFeatures(speakerType, desiredFeatures);
        clusterer = new KMeansClusteringTrainer();
        double[] globalVariances = MathUtils.getVarianceCols(features);
        KMeansClusteringTrainerParams kmeansParams = new KMeansClusteringTrainerParams();
        kmeansParams.numClusters = numClusters;
        kmeansParams.maxIterations = params.maxIterations;
        kmeansParams.minClusterChangePercent = params.minClusterChangePercent;
        kmeansParams.isDiagonalOutputCovariance = params.isDiagonalCovariance;
        kmeansParams.setGlobalVariances(globalVariances);
        clusterer.train(features, kmeansParams);
        features = null;
        return clusterer;
    }

    private int eliminateLeastLikelyMappings(KMeansClusteringTrainer srcClusterer, KMeansClusteringTrainer tgtClusterer, int[] acceptanceStatus, int desiredFeatures, int desiredOutlierStatus, double eliminationLikelihood, int distanceType) {
        int totalOutliers = 0;
        double[][] targetClusterCounts = new double[srcClusterer.clusters.length][];
        int i = 0;
        while (i < srcClusterer.clusters.length) {
            targetClusterCounts[i] = new double[tgtClusterer.clusters.length];
            Arrays.fill(targetClusterCounts[i], 0.0);
            ++i;
        }
        i = 0;
        while (i < srcClusterer.clusterIndices.length) {
            double[] dArray = targetClusterCounts[srcClusterer.clusterIndices[i]];
            int n = tgtClusterer.clusterIndices[i];
            dArray[n] = dArray[n] + 1.0;
            ++i;
        }
        int[] sortedCountIndices = null;
        i = 0;
        while (i < srcClusterer.clusters.length) {
            sortedCountIndices = MathUtils.quickSort(targetClusterCounts[i]);
            double threshold = eliminationLikelihood * MathUtils.sum(targetClusterCounts[i]);
            double tempSum = 0.0;
            int index = -1;
            int j = 0;
            while (j < targetClusterCounts[i].length) {
                if (tempSum >= threshold) break;
                tempSum += targetClusterCounts[i][j];
                ++index;
                ++j;
            }
            if (index > -1) {
                j = 0;
                while (j <= index) {
                    int k = 0;
                    while (k < tgtClusterer.clusterIndices.length) {
                        if (srcClusterer.clusterIndices[k] == i && tgtClusterer.clusterIndices[k] == sortedCountIndices[j]) {
                            int n = k;
                            acceptanceStatus[n] = acceptanceStatus[n] + desiredOutlierStatus;
                            ++totalOutliers;
                        }
                        ++k;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return totalOutliers;
    }

    private int eliminateMeanDistanceMismatches(WeightedCodebook codebookIn, KMeansClusteringTrainer srcClusterer, KMeansClusteringTrainer tgtClusterer, int[] acceptanceStatus, int desiredFeatures, int desiredOutlierStatus, double totalStandardDeviations, int distanceType, boolean isGlobalVariance) {
        int j;
        int totalOutliers = 0;
        double[][] srcFeatures = codebookIn.getFeatures(1, desiredFeatures);
        double[][] tgtFeatures = codebookIn.getFeatures(1, desiredFeatures);
        double[] boundaryVector = new double[srcFeatures[0].length];
        double[] srcThresholds = new double[srcClusterer.clusters.length];
        int i = 0;
        while (i < srcClusterer.clusters.length) {
            j = 0;
            while (j < boundaryVector.length) {
                boundaryVector[j] = isGlobalVariance ? srcClusterer.clusters[i].meanVector[j] + totalStandardDeviations * srcClusterer.covMatrixGlobal[0][j] : srcClusterer.clusters[i].meanVector[j] + totalStandardDeviations * srcClusterer.clusters[i].covMatrix[0][j];
                ++j;
            }
            if (distanceType == 1) {
                srcThresholds[i] = DistanceComputer.getAbsoluteValueDistance(boundaryVector, srcClusterer.clusters[i].meanVector);
            } else if (distanceType == 2) {
                srcThresholds[i] = DistanceComputer.getEuclideanDistance(boundaryVector, srcClusterer.clusters[i].meanVector);
            } else if (distanceType == 3) {
                srcThresholds[i] = DistanceComputer.getNormalizedEuclideanDistance(boundaryVector, srcClusterer.clusters[i].meanVector, srcClusterer.clusters[i].covMatrix[0]);
            } else if (distanceType == 4) {
                srcThresholds[i] = DistanceComputer.getMahalanobisDistance(boundaryVector, srcClusterer.clusters[i].meanVector, srcClusterer.clusters[i].invCovMatrix);
            }
            ++i;
        }
        double[] tgtThresholds = new double[tgtClusterer.clusters.length];
        boundaryVector = new double[tgtFeatures[0].length];
        i = 0;
        while (i < srcClusterer.clusters.length) {
            j = 0;
            while (j < boundaryVector.length) {
                boundaryVector[j] = isGlobalVariance ? tgtClusterer.clusters[i].meanVector[j] + totalStandardDeviations * tgtClusterer.covMatrixGlobal[0][j] : tgtClusterer.clusters[i].meanVector[j] + totalStandardDeviations * tgtClusterer.clusters[i].covMatrix[0][j];
                ++j;
            }
            if (distanceType == 1) {
                tgtThresholds[i] = DistanceComputer.getAbsoluteValueDistance(boundaryVector, tgtClusterer.clusters[i].meanVector);
            } else if (distanceType == 2) {
                tgtThresholds[i] = DistanceComputer.getEuclideanDistance(boundaryVector, tgtClusterer.clusters[i].meanVector);
            } else if (distanceType == 3) {
                tgtThresholds[i] = DistanceComputer.getNormalizedEuclideanDistance(boundaryVector, tgtClusterer.clusters[i].meanVector, tgtClusterer.clusters[i].covMatrix[0]);
            } else if (distanceType == 4) {
                tgtThresholds[i] = DistanceComputer.getMahalanobisDistance(boundaryVector, tgtClusterer.clusters[i].meanVector, tgtClusterer.clusters[i].invCovMatrix);
            }
            ++i;
        }
        int totalOne2Many = 0;
        int totalMany2One = 0;
        int totalMany2Many = 0;
        double srcDist = 0.0;
        double tgtDist = 0.0;
        i = 0;
        while (i < srcClusterer.clusterIndices.length) {
            if (distanceType == 1) {
                srcDist = DistanceComputer.getAbsoluteValueDistance(srcFeatures[i], srcClusterer.clusters[srcClusterer.clusterIndices[i]].meanVector);
                tgtDist = DistanceComputer.getAbsoluteValueDistance(tgtFeatures[i], tgtClusterer.clusters[tgtClusterer.clusterIndices[i]].meanVector);
            } else if (distanceType == 2) {
                srcDist = DistanceComputer.getEuclideanDistance(srcFeatures[i], srcClusterer.clusters[srcClusterer.clusterIndices[i]].meanVector);
                tgtDist = DistanceComputer.getEuclideanDistance(tgtFeatures[i], tgtClusterer.clusters[tgtClusterer.clusterIndices[i]].meanVector);
            } else if (distanceType == 3) {
                if (!isGlobalVariance) {
                    srcDist = DistanceComputer.getNormalizedEuclideanDistance(srcFeatures[i], srcClusterer.clusters[srcClusterer.clusterIndices[i]].meanVector, srcClusterer.clusters[srcClusterer.clusterIndices[i]].covMatrix[0]);
                    tgtDist = DistanceComputer.getNormalizedEuclideanDistance(tgtFeatures[i], tgtClusterer.clusters[tgtClusterer.clusterIndices[i]].meanVector, tgtClusterer.clusters[tgtClusterer.clusterIndices[i]].covMatrix[0]);
                } else {
                    srcDist = DistanceComputer.getNormalizedEuclideanDistance(srcFeatures[i], srcClusterer.clusters[srcClusterer.clusterIndices[i]].meanVector, srcClusterer.covMatrixGlobal[0]);
                    tgtDist = DistanceComputer.getNormalizedEuclideanDistance(tgtFeatures[i], tgtClusterer.clusters[tgtClusterer.clusterIndices[i]].meanVector, tgtClusterer.covMatrixGlobal[0]);
                }
            } else if (distanceType == 4) {
                if (!isGlobalVariance) {
                    srcDist = DistanceComputer.getMahalanobisDistance(srcFeatures[i], srcClusterer.clusters[srcClusterer.clusterIndices[i]].meanVector, srcClusterer.clusters[srcClusterer.clusterIndices[i]].invCovMatrix);
                    tgtDist = DistanceComputer.getMahalanobisDistance(tgtFeatures[i], tgtClusterer.clusters[tgtClusterer.clusterIndices[i]].meanVector, tgtClusterer.clusters[tgtClusterer.clusterIndices[i]].invCovMatrix);
                } else {
                    srcDist = DistanceComputer.getMahalanobisDistance(srcFeatures[i], srcClusterer.clusters[srcClusterer.clusterIndices[i]].meanVector, srcClusterer.invCovMatrixGlobal);
                    tgtDist = DistanceComputer.getMahalanobisDistance(tgtFeatures[i], tgtClusterer.clusters[tgtClusterer.clusterIndices[i]].meanVector, tgtClusterer.invCovMatrixGlobal);
                }
            }
            if (srcDist < srcThresholds[srcClusterer.clusterIndices[i]] && tgtDist >= tgtThresholds[tgtClusterer.clusterIndices[i]]) {
                int n = i;
                acceptanceStatus[n] = acceptanceStatus[n] + OutlierStatus.ONE2MANY_OUTLIER;
                ++totalOne2Many;
                ++totalOutliers;
            } else if (srcDist >= srcThresholds[srcClusterer.clusterIndices[i]] && tgtDist < tgtThresholds[tgtClusterer.clusterIndices[i]]) {
                int n = i;
                acceptanceStatus[n] = acceptanceStatus[n] + OutlierStatus.MANY2ONE_OUTLIER;
                ++totalMany2One;
                ++totalOutliers;
            } else if (srcDist >= srcThresholds[srcClusterer.clusterIndices[i]] && tgtDist >= tgtThresholds[tgtClusterer.clusterIndices[i]]) {
                int n = i;
                acceptanceStatus[n] = acceptanceStatus[n] + OutlierStatus.MANY2MANY_OUTLIER;
                ++totalMany2Many;
                ++totalOutliers;
            }
            ++i;
        }
        System.out.println("(One2Many=" + String.valueOf(totalOne2Many) + " Many2One=" + String.valueOf(totalMany2One) + " Many2Many=" + String.valueOf(totalMany2Many) + ")");
        return totalOutliers;
    }

    private int eliminateUsingSubclusterMeanDistances(WeightedCodebook codebookIn, KMeansClusteringTrainer srcClusterer, KMeansClusteringTrainer tgtClusterer, int[] acceptanceStatus, int desiredFeatures, int desiredOutlierStatus, double totalStandardDeviations, int distanceType) {
        int totalOutliers = 0;
        return totalOutliers;
    }
}

