/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.analysis;

import java.util.ArrayList;
import java.util.List;
import marytts.signalproc.analysis.Labels;

public class AlignedLabels {
    private Labels first;
    private Labels second;
    private int[] indexMap;
    private List<AlignedTimeStretch> stretches;

    public AlignedLabels(Labels first, Labels second, int[] indexMap) {
        this.first = first;
        this.second = second;
        this.indexMap = indexMap;
        this.stretches = new ArrayList<AlignedTimeStretch>();
        int iFirstStart = 0;
        int iFirstEnd = 0;
        int iSecondStart = 0;
        int iSecondEnd = 0;
        while (iFirstStart < first.items.length) {
            iFirstEnd = iFirstStart;
            iSecondEnd = indexMap[iFirstStart];
            while (iFirstEnd < first.items.length && indexMap[iFirstEnd] == iSecondEnd) {
                ++iFirstEnd;
            }
            double tFirstStart = iFirstStart == 0 ? 0.0 : first.items[iFirstStart - 1].time;
            double tFirstEnd = first.items[--iFirstEnd].time;
            double tSecondStart = iSecondStart == 0 ? 0.0 : second.items[iSecondStart - 1].time;
            double tSecondEnd = second.items[iSecondEnd].time;
            this.stretches.add(new AlignedTimeStretch(tFirstStart, tFirstEnd, tSecondStart, tSecondEnd));
            iFirstStart = iFirstEnd + 1;
            iSecondStart = iSecondEnd + 1;
        }
    }

    public Labels getFirst() {
        return this.first;
    }

    public Labels getSecond() {
        return this.second;
    }

    public int[] getIndexMap() {
        return this.indexMap;
    }

    public double mapTimeFromFirstToSecond(double time1) {
        for (AlignedTimeStretch t : this.stretches) {
            if (!(time1 >= t.firstStart) || !(time1 <= t.firstStart + t.firstDuration)) continue;
            if (t.firstDuration == 0.0) {
                return t.secondStart;
            }
            return t.secondStart + (time1 - t.firstStart) / t.firstDuration * t.secondDuration;
        }
        return -1.0;
    }

    public double mapTimeFromSecondToFirst(double time2) {
        for (AlignedTimeStretch t : this.stretches) {
            if (!(time2 >= t.secondStart) || !(time2 <= t.secondStart + t.secondDuration)) continue;
            if (t.secondDuration == 0.0) {
                return t.firstStart;
            }
            return t.firstStart + (time2 - t.secondStart) / t.secondDuration * t.firstDuration;
        }
        return -1.0;
    }

    public List<AlignedTimeStretch> getAlignedTimeStretches() {
        return this.stretches;
    }

    public static class AlignedTimeStretch {
        public final double firstStart;
        public final double firstDuration;
        public final double secondStart;
        public final double secondDuration;

        public AlignedTimeStretch(double tFirstStart, double tFirstEnd, double tSecondStart, double tSecondEnd) {
            this.firstStart = tFirstStart;
            this.firstDuration = tFirstEnd - tFirstStart;
            this.secondStart = tSecondStart;
            this.secondDuration = tSecondEnd - tSecondStart;
            assert (this.firstDuration >= 0.0);
            assert (this.secondDuration >= 0.0);
        }

        public String toString() {
            return String.format("%.3f+%.3f %.3f+%.3f", this.firstStart, this.firstDuration, this.secondStart, this.secondDuration);
        }
    }
}

