/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.analysis;

public class CepstrumLPCAnalyser {
    public static double[] lpc2lpcc(double[] oneMinusA, double gain, int cepstrumOrder) {
        if (cepstrumOrder <= 0) {
            throw new RuntimeException("The cepstrum order [" + cepstrumOrder + "] must be a positive integer.");
        }
        double[] c = new double[cepstrumOrder + 1];
        int lpcOrder = oneMinusA.length - 1;
        c[0] = Math.log(gain);
        int m = 1;
        while (m <= cepstrumOrder) {
            int k;
            double acc;
            if (m <= lpcOrder) {
                acc = 0.0;
                k = 1;
                while (k < m) {
                    acc += (double)(m - k) * oneMinusA[k] * c[m - k];
                    ++k;
                }
                c[m] = acc / (double)m + oneMinusA[m];
            } else {
                acc = 0.0;
                k = 1;
                while (k <= lpcOrder) {
                    acc += (double)(m - k) * oneMinusA[k] * c[m - k];
                    ++k;
                }
                c[m] = acc / (double)m;
            }
            ++m;
        }
        return c;
    }

    public static double[] lpcc2lpc(double[] c, int lpcOrder) {
        if (lpcOrder <= 0) {
            throw new RuntimeException("The LPC order [" + lpcOrder + "] must be a positive integer.");
        }
        double[] a = new double[lpcOrder + 1];
        int cepstrumOrder = c.length - 1;
        a[0] = 1.0;
        int m = 1;
        while (m <= lpcOrder) {
            int k;
            double acc;
            if (m <= cepstrumOrder) {
                acc = 0.0;
                k = 1;
                while (k < m) {
                    acc += (double)k * a[m - k] * c[k];
                    ++k;
                }
                a[m] = c[m] - acc / (double)m;
            } else {
                acc = 0.0;
                k = 1;
                while (k <= cepstrumOrder) {
                    acc += (double)k * a[m - k] * c[k];
                    ++k;
                }
                a[m] = -acc / (double)m;
            }
            ++m;
        }
        return a;
    }
}

