/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.analysis;

import java.util.Arrays;
import marytts.util.math.ComplexArray;
import marytts.util.math.FFT;
import marytts.util.math.FFTMixedRadix;
import marytts.util.math.Hilbert;
import marytts.util.math.MathUtils;
import marytts.util.signal.SignalProcUtils;

public class CepstrumSpeechAnalyser {
    public static double[] realCepstrum(double[] frame) {
        return CepstrumSpeechAnalyser.realCepstrum(frame, frame.length);
    }

    public static double[] realCepstrum(double[] frame, int fftSize) {
        return CepstrumSpeechAnalyser.complexCepstrum((double[])frame, (int)fftSize).real;
    }

    public static ComplexArray complexCepstrum(double[] frame, int fftSize) {
        double[] real = new double[fftSize];
        double[] imag = new double[fftSize];
        Arrays.fill(real, 0.0);
        Arrays.fill(imag, 0.0);
        System.arraycopy(frame, 0, real, 0, Math.min(frame.length, fftSize));
        if (MathUtils.isPowerOfTwo(fftSize)) {
            FFT.transform(real, imag, false);
        } else {
            FFTMixedRadix.fftComplex(real, imag);
        }
        MathUtils.toPolarCoordinates(real, imag);
        real = MathUtils.log(real);
        if (MathUtils.isPowerOfTwo(fftSize)) {
            FFT.transform(real, imag, true);
            return new ComplexArray(real, imag);
        }
        return FFTMixedRadix.ifft(real, imag);
    }

    public static double[] filterLowPass(double[] realCepstrum, int cutoffIndex) {
        double[] filtered = new double[realCepstrum.length];
        filtered[0] = realCepstrum[0];
        filtered[cutoffIndex] = realCepstrum[cutoffIndex];
        int i = 1;
        while (i < cutoffIndex) {
            filtered[i] = 2.0 * realCepstrum[i];
            ++i;
        }
        return filtered;
    }

    public static double[] systemPhaseResponse(double[] x, int fftSize, int lifterOrder) {
        double[] systemAmpsInNeper = CepstrumSpeechAnalyser.cepstralSmoothedSpectrumInNeper(x, fftSize, lifterOrder);
        return CepstrumSpeechAnalyser.minimumPhaseResponseInRadians(systemAmpsInNeper);
    }

    public static double[] systemPhaseResponse(double[] x, int fs) {
        double[] systemAmpsInNeper = CepstrumSpeechAnalyser.cepstralSmoothedSpectrumInNeper(x, fs);
        return CepstrumSpeechAnalyser.minimumPhaseResponseInRadians(systemAmpsInNeper);
    }

    public static double[] minimumPhaseResponseInRadians(double[] systemAmpsInNeper) {
        ComplexArray phaseResponse = CepstrumSpeechAnalyser.minimumPhaseResponse(systemAmpsInNeper);
        int w = 0;
        while (w < phaseResponse.real.length) {
            phaseResponse.real[w] = Math.atan2(phaseResponse.imag[w], phaseResponse.real[w]);
            ++w;
        }
        return phaseResponse.real;
    }

    public static ComplexArray minimumPhaseResponse(double[] systemAmpsInNeper) {
        ComplexArray phaseResponse = Hilbert.transform(systemAmpsInNeper);
        int w = 0;
        while (w < phaseResponse.real.length) {
            int n = w;
            phaseResponse.real[n] = phaseResponse.real[n] * -1.0;
            int n2 = w++;
            phaseResponse.imag[n2] = phaseResponse.imag[n2] * -1.0;
        }
        return phaseResponse;
    }

    public static double[] cepstralSmoothedSpectrumInNeper(double[] x, int fs) {
        int lifterOrder = SignalProcUtils.getLifterOrder(fs);
        int fftSize = SignalProcUtils.getDFTSize(fs);
        return CepstrumSpeechAnalyser.cepstralSmoothedSpectrumInNeper(x, fftSize, lifterOrder);
    }

    public static double[] cepstralSmoothedSpectrumInNeper(double[] x, int fftSize, int lifterOrder) {
        double[] rceps = CepstrumSpeechAnalyser.realCepstrum(x, fftSize);
        double[] w = new double[rceps.length];
        int i = 0;
        while (i < lifterOrder) {
            w[i] = 1.0;
            ++i;
        }
        i = lifterOrder;
        while (i < w.length) {
            w[i] = 0.0;
            ++i;
        }
        i = 0;
        while (i < w.length) {
            int n = i;
            rceps[n] = rceps[n] * w[i];
            ++i;
        }
        ComplexArray y = FFTMixedRadix.fftReal(rceps, rceps.length);
        return y.real;
    }
}

