/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.analysis;

import java.util.ArrayList;
import java.util.List;
import marytts.signalproc.analysis.FrameBasedAnalyser;
import marytts.signalproc.window.Window;
import marytts.util.data.DoubleDataSource;

public abstract class F0Tracker {
    public static final int DEFAULT_MINF0 = 70;
    public static final int DEFAULT_MAXF0 = 700;
    protected TransitionCost transitionCost = this.getTransitionCost();

    public F0Contour analyse(DoubleDataSource signal, int samplingRate) {
        FrameBasedAnalyser.FrameAnalysisResult oneResult;
        DoubleDataSource preprocessedSignal = this.preprocess(signal);
        FrameBasedAnalyser candidateEstimator = this.getCandidateEstimator(preprocessedSignal, samplingRate);
        F0Contour f0 = new F0Contour(this.transitionCost, candidateEstimator.getFrameShiftTime());
        while ((oneResult = candidateEstimator.analyseNextFrame()) != null) {
            f0.addFrameAnalysis((F0Candidate[])oneResult.get());
        }
        f0.findPath();
        return f0;
    }

    protected abstract DoubleDataSource preprocess(DoubleDataSource var1);

    protected abstract FrameBasedAnalyser getCandidateEstimator(DoubleDataSource var1, int var2);

    protected abstract TransitionCost getTransitionCost();

    public abstract class CandidateEstimator
    extends FrameBasedAnalyser {
        protected int nCandidates;

        public CandidateEstimator(DoubleDataSource signal, Window window, int frameShift, int samplingRate, int nCandidates) {
            super(signal, window, frameShift, samplingRate);
            this.nCandidates = nCandidates;
        }

        public Object analyse(double[] frame) {
            if (frame.length != this.getFrameLengthSamples()) {
                throw new IllegalArgumentException("Expected frame of length " + this.getFrameLengthSamples() + ", got " + frame.length);
            }
            F0Candidate[] candidates = new F0Candidate[this.nCandidates];
            candidates[0] = new F0Candidate();
            this.findCandidates(candidates, frame);
            this.normaliseCandidatesScores(candidates);
            return candidates;
        }

        protected abstract void findCandidates(F0Candidate[] var1, double[] var2);

        protected void normaliseCandidatesScores(F0Candidate[] candidates) {
            double bestScore;
            assert (candidates != null);
            int iBest = 0;
            int i = 0;
            while (i < candidates.length) {
                if (candidates[i] == null) break;
                if (candidates[i].betterThan(candidates[iBest])) {
                    iBest = i;
                }
                ++i;
            }
            if ((bestScore = candidates[iBest].score) == 0.0) {
                return;
            }
            int i2 = 0;
            while (i2 < candidates.length) {
                if (candidates[i2] == null) break;
                candidates[i2].score /= bestScore;
                ++i2;
            }
        }

        protected void addCandidate(F0Candidate[] candidates, F0Candidate newCandidate) {
            int iWorst = 0;
            int i = 0;
            while (i < candidates.length) {
                if (candidates[i] == null) {
                    candidates[i] = newCandidate;
                    return;
                }
                if (candidates[iWorst].betterThan(candidates[i])) {
                    iWorst = i;
                }
                ++i;
            }
            if (newCandidate.betterThan(candidates[iWorst])) {
                candidates[iWorst] = newCandidate;
            }
        }
    }

    public class F0Candidate {
        protected double frequency;
        protected double score;

        protected F0Candidate() {
            this.frequency = Double.NaN;
            this.score = 0.0;
        }

        protected F0Candidate(double frequency, double score) {
            this.frequency = frequency;
            this.score = score;
        }

        public boolean betterThan(F0Candidate other) {
            return this.score > other.score;
        }
    }

    public class F0Contour {
        protected List candidateLattice;
        protected double[] contour;
        protected TransitionCost transitionCost;
        protected double frameShiftTime;

        protected F0Contour(TransitionCost transitionCost, double frameShiftTime) {
            this.candidateLattice = new ArrayList();
            this.contour = null;
            this.transitionCost = transitionCost;
            this.frameShiftTime = frameShiftTime;
        }

        public F0Contour(String ptcFile) {
        }

        protected void addFrameAnalysis(F0Candidate[] candidates) {
            this.candidateLattice.add(candidates);
        }

        protected void findPath() {
            assert (this.candidateLattice != null);
            assert (this.contour == null);
            this.contour = new double[this.candidateLattice.size()];
            int i = 0;
            while (i < this.contour.length) {
                this.contour[i] = this.getBest((int)i).frequency;
                ++i;
            }
        }

        protected F0Candidate getBest(int index) {
            F0Candidate[] candidates = (F0Candidate[])this.candidateLattice.get(index);
            assert (candidates.length >= 1);
            int iBest = 0;
            int i = 0;
            while (i < candidates.length) {
                if (candidates[i] == null) break;
                if (candidates[i].betterThan(candidates[iBest])) {
                    iBest = i;
                }
                ++i;
            }
            return candidates[iBest];
        }

        public double[] getContour() {
            return this.contour;
        }

        public double getFrameShiftTime() {
            return this.frameShiftTime;
        }
    }

    public abstract class TransitionCost {
        protected TransitionCost() {
        }

        protected abstract double getCost(F0Candidate var1, F0Candidate var2);
    }
}

