/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.analysis;

import java.io.IOException;
import marytts.signalproc.analysis.ReflectionCoefficients;
import marytts.util.data.ESTTrackReader;
import marytts.util.data.ESTTrackWriter;

public class Lprefc2Lpc {
    private static float[][] convertData(float[][] lprefc) {
        int lpcOrder = lprefc[0].length;
        double[] k = new double[lpcOrder];
        double[] a = new double[lpcOrder + 1];
        float[][] lpc = new float[lprefc.length][lpcOrder + 1];
        int i = 0;
        while (i < lprefc.length) {
            int j = 0;
            while (j < lpcOrder) {
                k[j] = lprefc[i][j];
                ++j;
            }
            a = ReflectionCoefficients.lprefc2lpc(k);
            lpc[i][0] = 1.0f;
            j = 1;
            while (j <= lpcOrder) {
                lpc[i][j] = (float)a[j];
                ++j;
            }
            ++i;
        }
        return lpc;
    }

    public static void convert(String inFileName, String outFileName) throws IOException {
        ESTTrackReader etr = new ESTTrackReader(inFileName);
        float[][] lpc = Lprefc2Lpc.convertData(etr.getFrames());
        ESTTrackWriter etw = new ESTTrackWriter(etr.getTimes(), lpc, "lpc");
        etw.doWriteAndClose(outFileName, etr.isBinary(), etr.isBigEndian());
    }

    public static void main(String[] args) throws IOException {
        Lprefc2Lpc.convert(args[0], args[1]);
    }
}

