/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.analysis;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import marytts.signalproc.Defaults;
import marytts.signalproc.analysis.FrameBasedAnalyser;
import marytts.signalproc.analysis.LpcAnalyser;
import marytts.signalproc.analysis.LsfFileHeader;
import marytts.signalproc.window.DynamicWindow;
import marytts.util.data.DoubleDataSource;
import marytts.util.data.audio.AudioDoubleDataSource;
import marytts.util.io.StreamUtils;
import marytts.util.math.MathUtils;
import marytts.util.signal.SignalProcUtils;

public class LsfAnalyser {
    static int mpy = 0;
    static int add = 0;
    static int ptr = 0;

    public static double[] lpc2lsfInHz(double[] oneMinusA, int samplingRate) {
        return LsfAnalyser.lpc2lsfInHz(oneMinusA, samplingRate, 4);
    }

    public static double[] lpc2lsfInHz(double[] oneMinusA, int samplingRate, int type) {
        double[] lsp = LsfAnalyser.lpc2lsf(oneMinusA, type);
        int i = 0;
        while (i < lsp.length) {
            int n = i++;
            lsp[n] = lsp[n] * (double)samplingRate;
        }
        return lsp;
    }

    public static double[] lpc2lsfInBark(double[] oneMinusA, int samplingRate) {
        return SignalProcUtils.freq2bark(LsfAnalyser.lpc2lsfInHz(oneMinusA, samplingRate));
    }

    public static double[] lpc2lsfInBark(double[] oneMinusA, int samplingRate, int type) {
        return SignalProcUtils.freq2bark(LsfAnalyser.lpc2lsfInHz(oneMinusA, samplingRate, type));
    }

    public static double[] lpc2lsf(double[] oneMinusA, int type) {
        double Factor;
        int g2_order;
        boolean even;
        int order = oneMinusA.length - 1;
        double[] g1 = new double[100];
        double[] g2 = new double[100];
        double[] g1r = new double[100];
        double[] g2r = new double[100];
        boolean bl = even = (order & 1) == 0;
        if (!even) {
            int g1_order = (order + 1) / 2;
            int g2_order2 = g1_order - 1;
            throw new IllegalArgumentException("Odd order not implemented yet");
        }
        int g1_order = g2_order = order / 2;
        int orderd2 = (order + 1) / 2;
        g1[orderd2] = oneMinusA[0];
        int i = 1;
        while (i <= orderd2) {
            g1[g1_order - i] = oneMinusA[i] + oneMinusA[order + 1 - i];
            ++i;
        }
        g2[orderd2] = oneMinusA[0];
        i = 1;
        while (i <= orderd2) {
            g2[orderd2 - i] = oneMinusA[i] - oneMinusA[order + 1 - i];
            ++i;
        }
        if (even) {
            i = 1;
            while (i <= orderd2) {
                int n = orderd2 - i;
                g1[n] = g1[n] - g1[orderd2 - i + 1];
                ++i;
            }
            i = 1;
            while (i <= orderd2) {
                int n = orderd2 - i;
                g2[n] = g2[n] + g2[orderd2 - i + 1];
                ++i;
            }
        } else {
            i = 2;
            while (i <= orderd2) {
                int n = orderd2 - i;
                g2[n] = g2[n] + g2[orderd2 - i + 2];
                ++i;
            }
        }
        if (type == 1) {
            LsfAnalyser.cheby1(g1, g1_order);
            LsfAnalyser.cheby1(g2, g2_order);
            Factor = 0.5;
        } else if (type == 2) {
            LsfAnalyser.cheby2(g1, g1_order);
            LsfAnalyser.cheby2(g2, g2_order);
            Factor = 0.5;
        } else if (type == 3) {
            LsfAnalyser.cheby3(g1, g1_order);
            LsfAnalyser.cheby3(g2, g2_order);
            Factor = 1.0;
        } else if (type == 4) {
            LsfAnalyser.kw(g1, g1_order);
            LsfAnalyser.kw(g2, g2_order);
            Factor = 0.5;
        } else {
            throw new IllegalArgumentException("valid type values are 1 to 4.\n");
        }
        LsfAnalyser.cacm283(g1, g1_order, g1r);
        LsfAnalyser.cacm283(g2, g2_order, g2r);
        double[] lsp = new double[order];
        i = 0;
        int j = 0;
        while (true) {
            lsp[j++] = Math.acos(Factor * g1r[i]) / (Math.PI * 2);
            if (j >= order) break;
            lsp[j++] = Math.acos(Factor * g2r[i]) / (Math.PI * 2);
            if (j >= order) break;
            ++i;
        }
        return lsp;
    }

    static void cheby1(double[] g, int ord) {
        int i = 2;
        while (i <= ord) {
            int j = ord;
            while (j > i) {
                int n = j - 2;
                g[n] = g[n] - g[j];
                ++add;
                --j;
            }
            int n = j - 2;
            g[n] = g[n] - 2.0 * g[j];
            ++mpy;
            ++add;
            ++i;
        }
    }

    static void cheby2(double[] g, int ord) {
        g[0] = g[0] * 0.5;
        ++mpy;
        int i = 2;
        while (i <= ord) {
            int j = ord;
            while (j >= i) {
                int n = j - 2;
                g[n] = g[n] - g[j];
                ++add;
                --j;
            }
            int n = i - 1;
            g[n] = g[n] * 0.5;
            ++mpy;
            ++i;
        }
        int n = ord;
        g[n] = g[n] * 0.5;
        ++mpy;
    }

    static void cheby3(double[] g, int ord) {
        g[0] = g[0] * 0.5;
        ++mpy;
        int i = 2;
        while (i <= ord) {
            int j = ord;
            while (j >= i) {
                int n = j - 2;
                g[n] = g[n] - g[j];
                ++add;
                int n2 = j;
                g[n2] = g[n2] + g[j];
                ++add;
                --j;
            }
            ++i;
        }
    }

    static void kw(double[] r, int n) {
        double[] s = new double[100];
        double[] c = new double[100];
        s[0] = 1.0;
        s[1] = -2.0;
        s[2] = 2.0;
        int i = 3;
        while (i <= n / 2) {
            s[i] = s[i - 2];
            ++i;
        }
        int k = 0;
        while (k <= n) {
            c[k] = r[k];
            int j = 1;
            i = k + 2;
            while (i <= n) {
                int n2 = k;
                c[n2] = c[n2] + s[j] * r[i];
                ++mpy;
                ++add;
                int n3 = j;
                s[n3] = s[n3] - s[j - 1];
                ++add;
                ++j;
                ++ptr;
                i += 2;
            }
            ++k;
        }
        k = 0;
        while (k <= n) {
            r[k] = c[k];
            ++k;
        }
    }

    static void cacm283(double[] a, int ord, double[] r) {
        int swap;
        int i = 0;
        while (i < ord) {
            r[i] = 2.0 * ((double)i + 0.5) / (double)ord - 1.0;
            ++i;
        }
        double error = 1.0;
        while (error > 1.0E-12) {
            error = 0.0;
            i = 0;
            while (i < ord) {
                double rooti = r[i];
                double val = a[ord];
                double p = a[ord];
                int k = ord - 1;
                while (k >= 0) {
                    val = val * rooti + a[k];
                    if (k != i) {
                        p *= rooti - r[k];
                    }
                    --k;
                }
                double delta = val / p;
                int n = i++;
                r[n] = r[n] - delta;
                error += delta * delta;
            }
        }
        do {
            swap = 0;
            i = 0;
            while (i < ord - 1) {
                if (r[i] < r[i + 1]) {
                    double tmplsp = r[i];
                    r[i] = r[i + 1];
                    r[i + 1] = tmplsp;
                    ++swap;
                }
                ++i;
            }
        } while (swap > 0);
    }

    public static void main2(String[] argv) {
        double[] awc = new double[]{1.0, 0.1077, -0.0424, 0.1737, -0.0278, 0.1759, -0.199, -0.0333, -0.1904, 0.0759, 0.0278, -0.0568, -0.1325, 0.001, -0.001, 0.001, -0.001, 0.001, -5.0E-4, 0.001, -0.001, 0.001, -0.001, 0.001, 2.0E-4};
        double[] a = new double[25];
        double[] lsp = new double[24];
        int type = 0;
        int ord = 12;
        if (argv.length < 1) {
            System.err.println("command: al2sp type order\n");
            System.err.println("type is 1 to 4\n");
            System.err.println("order is 2 to 24\n");
            System.exit(2);
        }
        if (argv.length >= 1) {
            type = Integer.parseInt(argv[0]);
        }
        if (argv.length >= 2) {
            ord = Integer.parseInt(argv[1]);
        }
        if (ord > 24) {
            throw new IllegalArgumentException("Model order is 24 max.\n");
        }
        a[0] = 1.0;
        int i = 1;
        while (i <= ord) {
            a[i] = -awc[i];
            ++i;
        }
        lsp = LsfAnalyser.lpc2lsf(a, type);
        i = 0;
        while (i < ord) {
            System.out.println(String.valueOf(i) + ": " + lsp[i]);
            ++i;
        }
        System.out.println("mpy " + mpy + " add " + add + " ptr " + ptr);
    }

    public static double[] lsfInHz2lpc(double[] lsf, int samplingRate) {
        double[] normalised_lsf = new double[lsf.length];
        int i = 0;
        while (i < lsf.length) {
            normalised_lsf[i] = lsf[i] / (double)samplingRate;
            assert (0.0 <= normalised_lsf[i]);
            assert (normalised_lsf[i] <= 0.5);
            ++i;
        }
        return LsfAnalyser.lsf2lpc(normalised_lsf);
    }

    public static double[] lsfInBark2lpc(double[] lsfsInBark, int samplingRate) {
        return LsfAnalyser.lsfInHz2lpc(SignalProcUtils.bark2freq(lsfsInBark, samplingRate), samplingRate);
    }

    public static double[] lsf2lpc(double[] lsf) {
        MathUtils.quickSort(lsf);
        int P = lsf.length;
        int half_order = P / 2;
        double[] a = new double[P / 2 + 1];
        double[] a1 = new double[P / 2 + 1];
        double[] a2 = new double[P / 2 + 1];
        double[] b = new double[P / 2 + 1];
        double[] b1 = new double[P / 2 + 1];
        double[] b2 = new double[P / 2 + 1];
        double[] p = new double[P / 2];
        double[] q = new double[P / 2];
        double[] oneMinusA = new double[P + 1];
        oneMinusA[0] = 1.0;
        if (lsf[0] <= 0.0 || lsf[0] >= 0.5) {
            throw new IllegalArgumentException("LSFs out of bounds; lsf[0] = " + lsf[0]);
        }
        int i = 1;
        while (i < P) {
            if (lsf[i] <= lsf[i - 1]) {
                throw new IllegalArgumentException("nonmonotonic LSFs");
            }
            if (lsf[i] <= 0.0 || lsf[i] >= 0.5) {
                throw new IllegalArgumentException("LSFs out of bounds; lsf[" + i + "] = " + lsf[i]);
            }
            ++i;
        }
        i = 0;
        while (i < half_order) {
            p[i] = -2.0 * Math.cos(Math.PI * 2 * lsf[2 * i]);
            q[i] = -2.0 * Math.cos(Math.PI * 2 * lsf[2 * i + 1]);
            ++i;
        }
        double xf = 0.0;
        i = 0;
        while (i <= P) {
            double xx = i == 0 ? 1.0 : 0.0;
            a[0] = xx + xf;
            b[0] = xx - xf;
            xf = xx;
            int j = 0;
            while (j < half_order) {
                a[j + 1] = a[j] + p[j] * a1[j] + a2[j];
                b[j + 1] = b[j] + q[j] * b1[j] + b2[j];
                a2[j] = a1[j];
                a1[j] = a[j];
                b2[j] = b1[j];
                b1[j] = b[j];
                ++j;
            }
            if (i > 0) {
                oneMinusA[i] = 0.5 * (a[half_order] + b[half_order]);
            }
            ++i;
        }
        return oneMinusA;
    }

    public static double[][] lsfAnalyzeWavFile(String wavFile, LsfFileHeader params) throws UnsupportedAudioFileException, IOException {
        AudioInputStream inputAudio = AudioSystem.getAudioInputStream(new File(wavFile));
        params.samplingRate = (int)inputAudio.getFormat().getSampleRate();
        int ws = (int)Math.floor((double)(params.winsize * (float)params.samplingRate) + 0.5);
        int ss = (int)Math.floor((double)(params.skipsize * (float)params.samplingRate) + 0.5);
        if (params.dimension < 1) {
            params.dimension = SignalProcUtils.getLPOrder(params.samplingRate);
        }
        AudioDoubleDataSource signal = new AudioDoubleDataSource(inputAudio);
        double[] x = signal.getAllData();
        double[] frm = new double[ws];
        int numfrm = (int)Math.floor((double)(x.length - ws) / (double)ss + 0.5);
        params.numfrm = numfrm > 0 ? numfrm : 0;
        double[][] lsfs = new double[params.numfrm][params.dimension];
        int i = 0;
        while (i < params.numfrm) {
            Arrays.fill(frm, 0.0);
            System.arraycopy(x, i * ss, frm, 0, Math.min(ws, x.length - i * ss));
            lsfs[i] = LsfAnalyser.nonPreemphasizedFrame2LsfsInHz(frm, params.dimension, params.samplingRate, params.windowType, params.preCoef);
            if (params.isBarkScaled) {
                lsfs[i] = SignalProcUtils.freq2bark(lsfs[i]);
            }
            ++i;
        }
        return lsfs;
    }

    public static double[] nonPreemphasizedFrame2Lpcs(double[] nonPreemphasizedFrame, int dimension, int samplingRate, int windowType, float preCoef) {
        double[] preemphasizedFrame = SignalProcUtils.applyPreemphasis(nonPreemphasizedFrame, preCoef);
        return LsfAnalyser.preemphasizedFrame2Lpcs(preemphasizedFrame, dimension, samplingRate, windowType);
    }

    public static double[] preemphasizedFrame2Lpcs(double[] preemphasizedFrame, int dimension, int samplingRate, int windowType) {
        DynamicWindow window = new DynamicWindow(windowType);
        double[] wgt = window.values(preemphasizedFrame.length);
        double[] windowedAndPreemphasizedFrame = new double[preemphasizedFrame.length];
        int j = 0;
        while (j < preemphasizedFrame.length) {
            windowedAndPreemphasizedFrame[j] = preemphasizedFrame[j] * wgt[j];
            ++j;
        }
        return LsfAnalyser.windowedAndPreemphasizedFrame2Lpcs(windowedAndPreemphasizedFrame, dimension, samplingRate);
    }

    public static double[] windowedAndPreemphasizedFrame2Lpcs(double[] windowedAndPreemphasizedFrame, int dimension, int samplingRate) {
        LpcAnalyser.LpCoeffs l = LpcAnalyser.calcLPC(windowedAndPreemphasizedFrame, dimension);
        return l.getOneMinusA();
    }

    public static double[] nonPreemphasizedFrame2LsfsInHz(double[] nonPreemphasizedFrame, int dimension, int samplingRate, int windowType, float preCoef) {
        double[] preemphasizedFrame = SignalProcUtils.applyPreemphasis(nonPreemphasizedFrame, preCoef);
        return LsfAnalyser.preemphasizedFrame2LsfsInHz(preemphasizedFrame, dimension, samplingRate, windowType);
    }

    public static double[] preemphasizedFrame2LsfsInHz(double[] preemphasizedFrame, int dimension, int samplingRate, int windowType) {
        DynamicWindow window = new DynamicWindow(windowType);
        double[] wgt = window.values(preemphasizedFrame.length);
        double[] windowedAndPreemphasizedFrame = new double[preemphasizedFrame.length];
        int j = 0;
        while (j < windowedAndPreemphasizedFrame.length) {
            windowedAndPreemphasizedFrame[j] = preemphasizedFrame[j] * wgt[j];
            ++j;
        }
        return LsfAnalyser.windowedAndPreemphasizedFrame2LsfsInHz(windowedAndPreemphasizedFrame, dimension, samplingRate);
    }

    public static double[] windowedAndPreemphasizedFrame2LsfsInHz(double[] windowedAndPreemphasizedFrame, int dimension, int samplingRate) {
        double[] lpcs = LsfAnalyser.windowedAndPreemphasizedFrame2Lpcs(windowedAndPreemphasizedFrame, dimension, samplingRate);
        return LsfAnalyser.lpc2lsfInHz(lpcs, samplingRate);
    }

    public static void lsfAnalyzeWavFile(String wavFileIn, String lsfFileOut, LsfFileHeader params) throws IOException {
        double[][] lsfs = null;
        try {
            lsfs = LsfAnalyser.lsfAnalyzeWavFile(wavFileIn, params);
        }
        catch (UnsupportedAudioFileException e) {
            e.printStackTrace();
        }
        if (lsfs != null) {
            params.numfrm = lsfs.length;
            LsfAnalyser.writeLsfFile(lsfs, lsfFileOut, params);
        } else {
            params.numfrm = 0;
        }
    }

    public static void writeLsfFile(double[][] lsfs, String lsfFileOut, LsfFileHeader params) throws IOException {
        params.numfrm = lsfs.length;
        DataOutputStream stream = params.writeHeader(lsfFileOut, true);
        LsfAnalyser.writeLsfs(stream, lsfs);
    }

    public static void writeLsfs(DataOutputStream stream, double[][] lsfs) throws IOException {
        if (stream != null && lsfs != null && lsfs.length > 0) {
            int i = 0;
            while (i < lsfs.length) {
                StreamUtils.writeDoubleArray((DataOutput)stream, (double[])lsfs[i]);
                ++i;
            }
            stream.close();
        }
    }

    public static double[][] readLsfFile(String lsfFile) throws IOException {
        LsfFileHeader params = new LsfFileHeader();
        DataInputStream stream = params.readHeader(lsfFile, true);
        return LsfAnalyser.readLsfs(stream, params);
    }

    public static double[][] readLsfs(DataInputStream stream, LsfFileHeader params) throws IOException {
        double[][] lsfs = null;
        if (stream != null && params.numfrm > 0 && params.dimension > 0) {
            lsfs = new double[params.numfrm][];
            int i = 0;
            while (i < lsfs.length) {
                lsfs[i] = StreamUtils.readDoubleArray((DataInput)stream, (int)params.dimension);
                ++i;
            }
            stream.close();
        }
        return lsfs;
    }

    public static void main(String[] args) throws Exception {
        int windowSize = Defaults.getWindowSize();
        Defaults.getWindowType();
        Defaults.getFFTSize();
        int frameShift = Defaults.getFrameShift();
        int p = Integer.getInteger("signalproc.lpcorder", 24);
        AudioInputStream inputAudio = AudioSystem.getAudioInputStream(new File(args[0]));
        int samplingRate = (int)inputAudio.getFormat().getSampleRate();
        AudioDoubleDataSource signal = new AudioDoubleDataSource(inputAudio);
        LpcAnalyser lpcAnalyser = new LpcAnalyser((DoubleDataSource)signal, windowSize, frameShift, samplingRate);
        FrameBasedAnalyser.FrameAnalysisResult<T>[] results = lpcAnalyser.analyseAllFrames();
        int i = 0;
        while (i < results.length) {
            System.out.println("Line spectral frequencies for frame " + i + ":");
            double[] lpc = ((LpcAnalyser.LpCoeffs)results[i].get()).getOneMinusA();
            double[] lsf = LsfAnalyser.lpc2lsf(lpc, 4);
            int j = 0;
            while (j < lsf.length) {
                System.out.println(String.valueOf(j) + ": " + lsf[j] + " = " + lsf[j] * (double)samplingRate);
                ++j;
            }
            double[] lpc_reconstructed = LsfAnalyser.lsf2lpc(lsf);
            System.out.println("LPC coefficients (orig/reconstructed from LSF):");
            int j2 = 0;
            while (j2 < lpc.length) {
                System.out.println(String.valueOf(lpc[j2]) + " " + lpc_reconstructed[j2]);
                ++j2;
            }
            ++i;
        }
    }
}

